/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands.provider;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.commands.packet.AdHocCommandData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CommandsProviderTest {
    @Test
    public void parseErrorWithRequest() throws Exception {
        String errorWithRequest = "<iq id='sid' type='error' from='from@example.com' to='to@example.com'><command xmlns='http://jabber.org/protocol/commands' node='http://example.com' action='execute'></command><error type='cancel'><bad-request xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></error></iq>";
        Stanza requestStanza = PacketParserUtils.parseStanza((String)"<iq id='sid' type='error' from='from@example.com' to='to@example.com'><command xmlns='http://jabber.org/protocol/commands' node='http://example.com' action='execute'></command><error type='cancel'><bad-request xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></error></iq>");
        AdHocCommandData adHocIq = (AdHocCommandData)requestStanza;
        Assertions.assertEquals((Object)IQ.Type.error, (Object)adHocIq.getType());
        Assertions.assertEquals((Object)AdHocCommandData.Action.execute, (Object)adHocIq.getAction());
        StanzaError error = adHocIq.getError();
        Assertions.assertEquals((Object)StanzaError.Type.CANCEL, (Object)error.getType());
        Assertions.assertEquals((Object)StanzaError.Condition.bad_request, (Object)error.getCondition());
    }
}

