/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;

public class Socks5Proxy {
    private static final Logger LOGGER = Logger.getLogger(Socks5Proxy.class.getName());
    private static final List<Socks5Proxy> RUNNING_PROXIES = new CopyOnWriteArrayList<Socks5Proxy>();
    private static Socks5Proxy socks5Server;
    private static boolean localSocks5ProxyEnabled;
    private static int DEFAULT_LOCAL_SOCKS5_PROXY_PORT;
    private int localSocks5ProxyPort = -7777;
    private final Socks5ServerProcess serverProcess;
    private Thread serverThread;
    private ServerSocket serverSocket;
    private final Map<String, Socket> connectionMap = new ConcurrentHashMap<String, Socket>();
    private final List<String> allowedConnections = Collections.synchronizedList(new ArrayList());
    private final Set<InetAddress> localAddresses = new LinkedHashSet<InetAddress>(4);
    private final boolean allowAllConnections;

    Socks5Proxy() {
        Enumeration<NetworkInterface> networkInterfaces;
        this.serverProcess = new Socks5ServerProcess();
        this.allowAllConnections = false;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new IllegalStateException(e);
        }
        HashSet<InetAddress> localAddresses = new HashSet<InetAddress>();
        for (NetworkInterface networkInterface : Collections.list(networkInterfaces)) {
            List<InterfaceAddress> interfaceAddresses = networkInterface.getInterfaceAddresses();
            for (InterfaceAddress interfaceAddress : interfaceAddresses) {
                localAddresses.add(interfaceAddress.getAddress());
            }
        }
        if (localAddresses.isEmpty()) {
            throw new IllegalStateException("Could not determine any local internet address");
        }
        this.replaceLocalAddresses(localAddresses);
    }

    protected Socks5Proxy(ServerSocket serverSocket) {
        this.serverProcess = new Socks5ServerProcess();
        this.serverSocket = serverSocket;
        this.allowAllConnections = true;
        this.startServerThread();
    }

    public static boolean isLocalSocks5ProxyEnabled() {
        return localSocks5ProxyEnabled;
    }

    public static void setLocalSocks5ProxyEnabled(boolean localSocks5ProxyEnabled) {
        Socks5Proxy.localSocks5ProxyEnabled = localSocks5ProxyEnabled;
    }

    private static void checkLocalSocks5ProxyPortArgument(int port) {
        if (Math.abs(port) > 65535) {
            throw new IllegalArgumentException("Local SOCKS5 proxy port must be within (-65535,65535)");
        }
    }

    public static int getDefaultLocalSocks5ProxyPort() {
        return DEFAULT_LOCAL_SOCKS5_PROXY_PORT;
    }

    public static void setDefaultLocalSocsk5ProxyPort(int defaultLocalSocks5ProxyPort) {
        Socks5Proxy.checkLocalSocks5ProxyPortArgument(defaultLocalSocks5ProxyPort);
        DEFAULT_LOCAL_SOCKS5_PROXY_PORT = defaultLocalSocks5ProxyPort;
    }

    public int getLocalSocks5ProxyPort() {
        return this.localSocks5ProxyPort;
    }

    public void setLocalSocks5ProxyPort(int localSocks5ProxyPort) {
        Socks5Proxy.checkLocalSocks5ProxyPortArgument(localSocks5ProxyPort);
        this.localSocks5ProxyPort = localSocks5ProxyPort;
    }

    public static synchronized Socks5Proxy getSocks5Proxy() {
        if (socks5Server == null) {
            socks5Server = new Socks5Proxy();
        }
        if (Socks5Proxy.isLocalSocks5ProxyEnabled()) {
            socks5Server.start();
        }
        return socks5Server;
    }

    public synchronized ServerSocket start() {
        if (this.isRunning()) {
            return this.serverSocket;
        }
        try {
            if (this.getLocalSocks5ProxyPort() < 0) {
                int port = Math.abs(this.getLocalSocks5ProxyPort());
                for (int i = 0; i < 65535 - port; ++i) {
                    try {
                        this.serverSocket = new ServerSocket(port + i);
                        break;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
            } else {
                this.serverSocket = new ServerSocket(this.getLocalSocks5ProxyPort());
            }
            if (this.serverSocket != null) {
                this.startServerThread();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "couldn't setup local SOCKS5 proxy on port " + this.getLocalSocks5ProxyPort(), e);
        }
        return this.serverSocket;
    }

    private synchronized void startServerThread() {
        this.serverThread = new Thread(this.serverProcess);
        this.serverThread.setName("Smack Local SOCKS5 Proxy [" + this.serverSocket + "]");
        this.serverThread.setDaemon(true);
        RUNNING_PROXIES.add(this);
        this.serverThread.start();
    }

    public synchronized void stop() {
        if (!this.isRunning()) {
            return;
        }
        RUNNING_PROXIES.remove(this);
        CloseableUtil.maybeClose((Closeable)this.serverSocket, (Logger)LOGGER);
        if (this.serverThread != null && this.serverThread.isAlive()) {
            try {
                this.serverThread.interrupt();
                this.serverThread.join();
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "SOCKS5 server thread termination was interrupted", e);
            }
        }
        this.serverThread = null;
        this.serverSocket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLocalAddress(InetAddress address) {
        if (address == null) {
            return;
        }
        Set<InetAddress> set = this.localAddresses;
        synchronized (set) {
            this.localAddresses.add(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLocalAddress(InetAddress address) {
        Set<InetAddress> set = this.localAddresses;
        synchronized (set) {
            return this.localAddresses.remove(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InetAddress> getLocalAddresses() {
        Set<InetAddress> set = this.localAddresses;
        synchronized (set) {
            return new ArrayList<InetAddress>(this.localAddresses);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceLocalAddresses(Collection<? extends InetAddress> addresses) {
        if (addresses == null) {
            throw new IllegalArgumentException("list must not be null");
        }
        Set<InetAddress> set = this.localAddresses;
        synchronized (set) {
            this.localAddresses.clear();
            this.localAddresses.addAll(addresses);
        }
    }

    public int getPort() {
        if (!this.isRunning()) {
            return -1;
        }
        return this.serverSocket.getLocalPort();
    }

    protected Socket getSocket(String digest) {
        return this.connectionMap.get(digest);
    }

    public void addTransfer(String digest) {
        this.allowedConnections.add(digest);
    }

    protected void removeTransfer(String digest) {
        this.allowedConnections.remove(digest);
        this.connectionMap.remove(digest);
    }

    public boolean isRunning() {
        return this.serverSocket != null;
    }

    public static Socket getSocketForDigest(String digest) {
        for (Socks5Proxy socks5Proxy : RUNNING_PROXIES) {
            Socket socket = socks5Proxy.getSocket(digest);
            if (socket == null) continue;
            return socket;
        }
        return null;
    }

    static List<Socks5Proxy> getRunningProxies() {
        return RUNNING_PROXIES;
    }

    static {
        localSocks5ProxyEnabled = true;
        DEFAULT_LOCAL_SOCKS5_PROXY_PORT = -7777;
    }

    private class Socks5ServerProcess
    implements Runnable {
        private Socks5ServerProcess() {
        }

        @Override
        public void run() {
            ServerSocket serverSocket;
            while ((serverSocket = Socks5Proxy.this.serverSocket) != null && !serverSocket.isClosed() && !Thread.currentThread().isInterrupted()) {
                Socket socket = null;
                try {
                    socket = serverSocket.accept();
                    this.establishConnection(socket);
                    continue;
                }
                catch (IOException | SmackException e) {
                    LOGGER.log(Level.FINE, "Exception while " + Socks5Proxy.this + " was handling connection", e);
                    CloseableUtil.maybeClose((Closeable)socket, (Logger)LOGGER);
                    continue;
                }
                break;
            }
            return;
        }

        private void establishConnection(Socket socket) throws SmackException, IOException {
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            DataInputStream in = new DataInputStream(socket.getInputStream());
            int b = in.read();
            if (b != 5) {
                throw new SmackException.SmackMessageException("Only SOCKS5 supported: Peer send " + b + " but we expect 5");
            }
            b = in.read();
            byte[] auth = new byte[b];
            in.readFully(auth);
            byte[] authMethodSelectionResponse = new byte[2];
            authMethodSelectionResponse[0] = 5;
            boolean noAuthMethodFound = false;
            for (int i = 0; i < auth.length; ++i) {
                if (auth[i] != 0) continue;
                noAuthMethodFound = true;
                break;
            }
            if (!noAuthMethodFound) {
                authMethodSelectionResponse[1] = -1;
                out.write(authMethodSelectionResponse);
                out.flush();
                throw new SmackException.SmackMessageException("Authentication method not supported");
            }
            authMethodSelectionResponse[1] = 0;
            out.write(authMethodSelectionResponse);
            out.flush();
            byte[] connectionRequest = Socks5Utils.receiveSocks5Message(in);
            String responseDigest = new String(connectionRequest, 5, (int)connectionRequest[4], StandardCharsets.UTF_8);
            if (!Socks5Proxy.this.allowAllConnections && !Socks5Proxy.this.allowedConnections.contains(responseDigest)) {
                connectionRequest[1] = 5;
                out.write(connectionRequest);
                out.flush();
                throw new SmackException.SmackMessageException("Connection with digest '" + responseDigest + "' is not allowed");
            }
            Socks5Proxy.this.connectionMap.put(responseDigest, socket);
            connectionRequest[1] = 0;
            out.write(connectionRequest);
            out.flush();
        }
    }
}

