/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.commands.packet;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.AbstractIqBuilder;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smackx.commands.AdHocCommandNote;
import org.jivesoftware.smackx.commands.SpecificErrorCondition;
import org.jivesoftware.smackx.commands.packet.AdHocCommandDataBuilder;
import org.jivesoftware.smackx.commands.packet.AdHocCommandDataView;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class AdHocCommandData
extends IQ
implements AdHocCommandDataView {
    public static final String ELEMENT = "command";
    public static final String NAMESPACE = "http://jabber.org/protocol/commands";
    private final String node;
    private final String name;
    private final String sessionId;
    private final List<AdHocCommandNote> notes = new ArrayList<AdHocCommandNote>();
    private final DataForm form;
    private final Action action;
    private final Status status;
    private final Set<AllowedAction> actions = EnumSet.noneOf(AllowedAction.class);
    private final AllowedAction executeAction;

    public AdHocCommandData(AdHocCommandDataBuilder builder) {
        super((AbstractIqBuilder)builder, ELEMENT, NAMESPACE);
        this.node = builder.getNode();
        this.name = builder.getName();
        this.sessionId = builder.getSessionId();
        this.notes.addAll(builder.getNotes());
        this.form = builder.getForm();
        this.action = builder.getAction();
        this.status = builder.getStatus();
        this.actions.addAll(builder.getActions());
        this.executeAction = builder.getExecuteAction();
        if (this.executeAction != null && !this.actions.contains((Object)this.executeAction)) {
            throw new IllegalArgumentException("Execute action " + this.executeAction + " is not part of allowed actions: " + this.actions);
        }
    }

    @Override
    public String getNode() {
        return this.node;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public List<AdHocCommandNote> getNotes() {
        return this.notes;
    }

    @Override
    public DataForm getForm() {
        return this.form;
    }

    @Override
    public Action getAction() {
        return this.action;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public Set<AllowedAction> getActions() {
        return this.actions;
    }

    @Override
    public AllowedAction getExecuteAction() {
        return this.executeAction;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.attribute("node", this.node);
        xml.optAttribute("sessionid", this.sessionId);
        xml.optAttribute("status", (Enum)this.status);
        xml.optAttribute("action", (Enum)this.action);
        xml.rightAngleBracket();
        if (this.getType() == IQ.Type.result) {
            xml.halfOpenElement("actions");
            xml.optAttribute("execute", (Enum)this.executeAction);
            if (this.actions.size() == 0) {
                xml.closeEmptyElement();
            } else {
                xml.rightAngleBracket();
                for (AllowedAction action : this.actions) {
                    xml.emptyElement((Enum)action);
                }
                xml.closeElement("actions");
            }
        }
        xml.optAppend((Element)this.form);
        for (AdHocCommandNote note : this.notes) {
            xml.halfOpenElement("note").attribute("type", note.getType().toString()).rightAngleBracket();
            xml.append((CharSequence)note.getValue());
            xml.closeElement("note");
        }
        return xml;
    }

    public static AdHocCommandDataBuilder builder(String node, IqData iqCommon) {
        return new AdHocCommandDataBuilder(node, iqCommon);
    }

    public static AdHocCommandDataBuilder builder(String node, String stanzaId) {
        return new AdHocCommandDataBuilder(node, stanzaId);
    }

    public static AdHocCommandDataBuilder builder(String node, XMPPConnection connection) {
        return new AdHocCommandDataBuilder(node, connection);
    }

    public static enum AllowedAction {
        prev(Action.prev),
        next(Action.next),
        complete(Action.complete);

        public final Action action;

        private AllowedAction(Action action) {
            this.action = action;
        }
    }

    public static enum Action {
        execute(null),
        cancel(null),
        prev(AllowedAction.prev),
        next(AllowedAction.next),
        complete(AllowedAction.complete);

        public final AllowedAction allowedAction;

        private Action(AllowedAction allowedAction) {
            this.allowedAction = allowedAction;
        }
    }

    public static enum Status {
        executing,
        completed,
        canceled;

    }

    public static class SpecificError
    implements XmlElement {
        public static final String namespace = "http://jabber.org/protocol/commands";
        public SpecificErrorCondition condition;

        public SpecificError(SpecificErrorCondition condition) {
            this.condition = condition;
        }

        public String getElementName() {
            return this.condition.toString();
        }

        public String getNamespace() {
            return "http://jabber.org/protocol/commands";
        }

        public SpecificErrorCondition getCondition() {
            return this.condition;
        }

        public String toXML(XmlEnvironment enclosingNamespace) {
            StringBuilder buf = new StringBuilder();
            buf.append('<').append(this.getElementName());
            buf.append(" xmlns=\"").append(this.getNamespace()).append("\"/>");
            return buf.toString();
        }
    }
}

