/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.socks5;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.test.util.NetworkUtil;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamManager;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5BytestreamRequest;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Exception;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5PacketUtils;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5TestProxy;
import org.jivesoftware.smackx.bytestreams.socks5.Socks5Utils;
import org.jivesoftware.smackx.bytestreams.socks5.packet.Bytestream;
import org.jivesoftware.util.ConnectionUtils;
import org.jivesoftware.util.Protocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;
import org.jxmpp.jid.impl.JidCreate;

public class Socks5ByteStreamRequestTest {
    private static final EntityFullJid initiatorJID = JidTestUtil.DUMMY_AT_EXAMPLE_ORG_SLASH_DUMMYRESOURCE;
    private static final EntityFullJid targetJID = JidTestUtil.FULL_JID_1_RESOURCE_1;
    private static final DomainBareJid proxyJID = JidTestUtil.MUC_EXAMPLE_ORG;
    private static final String proxyAddress = "127.0.0.1";
    private static final String sessionID = "session_id";

    @Test
    public void shouldFailIfRequestHasNoStreamHosts() throws Exception {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)targetJID);
        Assertions.assertThrows(Socks5Exception.NoSocks5StreamHostsProvided.class, () -> {
            Bytestream bytestreamInitialization = Socks5PacketUtils.createBytestreamInitiation((Jid)initiatorJID, (Jid)targetJID, sessionID);
            Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
            Socks5BytestreamRequest byteStreamRequest = new Socks5BytestreamRequest(byteStreamManager, bytestreamInitialization);
            byteStreamRequest.accept();
        });
        Assertions.assertEquals((int)1, (int)protocol.getRequests().size());
        Stanza targetResponse = (Stanza)protocol.getRequests().remove(0);
        Assertions.assertTrue((boolean)IQ.class.isInstance(targetResponse));
        Assertions.assertEquals((Object)initiatorJID, (Object)targetResponse.getTo());
        Assertions.assertEquals((Object)IQ.Type.error, (Object)((IQ)targetResponse).getType());
        Assertions.assertEquals((Object)StanzaError.Condition.item_not_found, (Object)targetResponse.getError().getCondition());
    }

    @Test
    public void shouldFailIfRequestHasInvalidStreamHosts() throws Exception {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)targetJID);
        Assertions.assertThrows(Socks5Exception.CouldNotConnectToAnyProvidedSocks5Host.class, () -> {
            Bytestream bytestreamInitialization = Socks5PacketUtils.createBytestreamInitiation((Jid)initiatorJID, (Jid)targetJID, sessionID);
            bytestreamInitialization.addStreamHost((Jid)proxyJID, proxyAddress, 7778);
            Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
            Socks5BytestreamRequest byteStreamRequest = new Socks5BytestreamRequest(byteStreamManager, bytestreamInitialization);
            byteStreamRequest.accept();
        });
        Assertions.assertEquals((int)1, (int)protocol.getRequests().size());
        Stanza targetResponse = (Stanza)protocol.getRequests().remove(0);
        Assertions.assertTrue((boolean)IQ.class.isInstance(targetResponse));
        Assertions.assertEquals((Object)initiatorJID, (Object)targetResponse.getTo());
        Assertions.assertEquals((Object)IQ.Type.error, (Object)((IQ)targetResponse).getType());
        Assertions.assertEquals((Object)StanzaError.Condition.item_not_found, (Object)targetResponse.getError().getCondition());
    }

    @Test
    public void shouldBlacklistInvalidProxyAfter2Failures() throws Exception {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)targetJID);
        Bytestream bytestreamInitialization = Socks5PacketUtils.createBytestreamInitiation((Jid)initiatorJID, (Jid)targetJID, sessionID);
        bytestreamInitialization.addStreamHost(JidCreate.from((String)("invalid." + String.valueOf(proxyJID))), "127.0.0.2", 7778);
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
        for (int i = 0; i < 2; ++i) {
            Assertions.assertThrows(Socks5Exception.CouldNotConnectToAnyProvidedSocks5Host.class, () -> {
                Socks5BytestreamRequest byteStreamRequest = new Socks5BytestreamRequest(byteStreamManager, bytestreamInitialization);
                byteStreamRequest.setTotalConnectTimeout(600);
                byteStreamRequest.setMinimumConnectTimeout(300);
                byteStreamRequest.accept();
            });
            Assertions.assertEquals((int)1, (int)protocol.getRequests().size());
            Stanza targetResponse = (Stanza)protocol.getRequests().remove(0);
            Assertions.assertTrue((boolean)IQ.class.isInstance(targetResponse));
            Assertions.assertEquals((Object)initiatorJID, (Object)targetResponse.getTo());
            Assertions.assertEquals((Object)IQ.Type.error, (Object)((IQ)targetResponse).getType());
            Assertions.assertEquals((Object)StanzaError.Condition.item_not_found, (Object)targetResponse.getError().getCondition());
        }
        byte[] data = new byte[]{1, 2, 3};
        try (Socks5TestProxy socks5Proxy = new Socks5TestProxy();){
            Assertions.assertTrue((boolean)socks5Proxy.isRunning());
            bytestreamInitialization.addStreamHost((Jid)proxyJID, proxyAddress, socks5Proxy.getPort());
            Socks5BytestreamRequest byteStreamRequest = new Socks5BytestreamRequest(byteStreamManager, bytestreamInitialization);
            byteStreamRequest.setTotalConnectTimeout(600);
            byteStreamRequest.setMinimumConnectTimeout(300);
            InputStream inputStream = byteStreamRequest.accept().getInputStream();
            String digest = Socks5Utils.createDigest((String)sessionID, (Jid)initiatorJID, (Jid)targetJID);
            OutputStream outputStream = socks5Proxy.getSocket(digest).getOutputStream();
            outputStream.write(data);
            byte[] result = new byte[3];
            inputStream.read(result);
            Assertions.assertArrayEquals((byte[])data, (byte[])result);
            Assertions.assertEquals((int)1, (int)protocol.getRequests().size());
            Stanza targetResponse = (Stanza)protocol.getRequests().remove(0);
            Assertions.assertEquals(Bytestream.class, targetResponse.getClass());
            Assertions.assertEquals((Object)initiatorJID, (Object)targetResponse.getTo());
            Assertions.assertEquals((Object)IQ.Type.result, (Object)((Bytestream)targetResponse).getType());
            Assertions.assertEquals((Object)proxyJID, (Object)((Bytestream)targetResponse).getUsedHost().getJID());
        }
    }

    @Test
    public void shouldNotBlacklistInvalidProxy() throws Exception {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)targetJID);
        Bytestream bytestreamInitialization = Socks5PacketUtils.createBytestreamInitiation((Jid)initiatorJID, (Jid)targetJID, sessionID);
        bytestreamInitialization.addStreamHost(JidCreate.from((String)("invalid." + String.valueOf(proxyJID))), "127.0.0.2", 7778);
        Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
        for (int i = 0; i < 10; ++i) {
            Assertions.assertThrows(Socks5Exception.CouldNotConnectToAnyProvidedSocks5Host.class, () -> {
                Socks5BytestreamRequest byteStreamRequest = new Socks5BytestreamRequest(byteStreamManager, bytestreamInitialization);
                byteStreamRequest.setTotalConnectTimeout(600);
                byteStreamRequest.setMinimumConnectTimeout(300);
                byteStreamRequest.setConnectFailureThreshold(0);
                byteStreamRequest.accept();
            });
            Assertions.assertEquals((int)1, (int)protocol.getRequests().size());
            Stanza targetResponse = (Stanza)protocol.getRequests().remove(0);
            Assertions.assertTrue((boolean)IQ.class.isInstance(targetResponse));
            Assertions.assertEquals((Object)initiatorJID, (Object)targetResponse.getTo());
            Assertions.assertEquals((Object)IQ.Type.error, (Object)((IQ)targetResponse).getType());
            Assertions.assertEquals((Object)StanzaError.Condition.item_not_found, (Object)targetResponse.getError().getCondition());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotTimeoutIfFirstSocks5ProxyDoesNotRespond() throws Exception {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)targetJID);
        try (Socks5TestProxy socks5Proxy = new Socks5TestProxy();
             ServerSocket unresponsiveSocks5Socket = NetworkUtil.getSocketOnLoopback();){
            Bytestream bytestreamInitialization = Socks5PacketUtils.createBytestreamInitiation((Jid)initiatorJID, (Jid)targetJID, sessionID);
            bytestreamInitialization.addStreamHost((Jid)proxyJID, proxyAddress, unresponsiveSocks5Socket.getLocalPort());
            bytestreamInitialization.addStreamHost((Jid)proxyJID, proxyAddress, socks5Proxy.getPort());
            byte[] data = new byte[]{1, 2, 3};
            Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
            Socks5BytestreamRequest byteStreamRequest = new Socks5BytestreamRequest(byteStreamManager, bytestreamInitialization);
            byteStreamRequest.setTotalConnectTimeout(2000);
            byteStreamRequest.setMinimumConnectTimeout(1000);
            InputStream inputStream = byteStreamRequest.accept().getInputStream();
            Socket socket = unresponsiveSocks5Socket.accept();
            Assertions.assertNotNull((Object)socket);
            String digest = Socks5Utils.createDigest((String)sessionID, (Jid)initiatorJID, (Jid)targetJID);
            OutputStream outputStream = socks5Proxy.getSocket(digest).getOutputStream();
            outputStream.write(data);
            byte[] result = new byte[3];
            inputStream.read(result);
            Assertions.assertArrayEquals((byte[])data, (byte[])result);
            Assertions.assertEquals((int)1, (int)protocol.getRequests().size());
            Stanza targetResponse = (Stanza)protocol.getRequests().remove(0);
            Assertions.assertEquals(Bytestream.class, targetResponse.getClass());
            Assertions.assertEquals((Object)initiatorJID, (Object)targetResponse.getTo());
            Assertions.assertEquals((Object)IQ.Type.result, (Object)((Bytestream)targetResponse).getType());
            Assertions.assertEquals((Object)proxyJID, (Object)((Bytestream)targetResponse).getUsedHost().getJID());
        }
    }

    @Test
    public void shouldAcceptSocks5BytestreamRequestAndReceiveData() throws Exception {
        Protocol protocol = new Protocol();
        XMPPConnection connection = ConnectionUtils.createMockedConnection((Protocol)protocol, (EntityFullJid)targetJID);
        try (Socks5TestProxy socks5Proxy = new Socks5TestProxy();){
            Bytestream bytestreamInitialization = Socks5PacketUtils.createBytestreamInitiation((Jid)initiatorJID, (Jid)targetJID, sessionID);
            bytestreamInitialization.addStreamHost((Jid)proxyJID, proxyAddress, socks5Proxy.getPort());
            byte[] data = new byte[]{1, 2, 3};
            Socks5BytestreamManager byteStreamManager = Socks5BytestreamManager.getBytestreamManager((XMPPConnection)connection);
            Socks5BytestreamRequest byteStreamRequest = new Socks5BytestreamRequest(byteStreamManager, bytestreamInitialization);
            InputStream inputStream = byteStreamRequest.accept().getInputStream();
            String digest = Socks5Utils.createDigest((String)sessionID, (Jid)initiatorJID, (Jid)targetJID);
            OutputStream outputStream = socks5Proxy.getSocket(digest).getOutputStream();
            outputStream.write(data);
            byte[] result = new byte[3];
            inputStream.read(result);
            Assertions.assertArrayEquals((byte[])data, (byte[])result);
            Assertions.assertEquals((int)1, (int)protocol.getRequests().size());
            Stanza targetResponse = (Stanza)protocol.getRequests().remove(0);
            Assertions.assertEquals(Bytestream.class, targetResponse.getClass());
            Assertions.assertEquals((Object)initiatorJID, (Object)targetResponse.getTo());
            Assertions.assertEquals((Object)IQ.Type.result, (Object)((Bytestream)targetResponse).getType());
            Assertions.assertEquals((Object)proxyJID, (Object)((Bytestream)targetResponse).getUsedHost().getJID());
        }
    }
}

