/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.filetransfer;

import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.filetransfer.FileTransferNegotiator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;

public class FileTransferNegotiatorTest
extends SmackTestSuite {
    private DummyConnection connection;

    @BeforeEach
    public void setUp() throws Exception {
        this.connection = new DummyConnection();
        this.connection.connect();
        this.connection.login();
        ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.disconnect();
        }
    }

    @Test
    public void verifyForm() throws Exception {
        FileTransferNegotiator fileNeg = FileTransferNegotiator.getInstanceFor((XMPPConnection)this.connection);
        try {
            fileNeg.negotiateOutgoingTransfer((Jid)JidTestUtil.DUMMY_AT_EXAMPLE_ORG, "streamid", "file", 1024L, null, 10);
        }
        catch (SmackException.NoResponseException noResponseException) {
            // empty catch block
        }
        Stanza packet = (Stanza)this.connection.getSentPacket();
        String xml = packet.toXML().toString();
        Assertions.assertTrue((xml.indexOf("var='stream-method' type='list-single'") != -1 ? 1 : 0) != 0);
    }
}

