/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.forward.provider;

import java.io.IOException;
import java.text.ParseException;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.delay.packet.DelayInformation;
import org.jivesoftware.smackx.delay.provider.DelayInformationProvider;
import org.jivesoftware.smackx.forward.packet.Forwarded;

public class ForwardedProvider
extends ExtensionElementProvider<Forwarded<?>> {
    public static final ForwardedProvider INSTANCE = new ForwardedProvider();
    private static final Logger LOGGER = Logger.getLogger(ForwardedProvider.class.getName());

    /*
     * Enabled aggressive block sorting
     */
    public Forwarded<?> parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException, ParseException {
        DelayInformation di = null;
        Message packet = null;
        block12: while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name = parser.getName();
                    String namespace = parser.getNamespace();
                    switch (name) {
                        case "delay": {
                            if ("urn:xmpp:delay".equals(namespace)) {
                                di = DelayInformationProvider.INSTANCE.parse(parser, parser.getDepth(), null);
                                break block0;
                            }
                            LOGGER.warning("Namespace '" + namespace + "' does not match expected namespace 'urn:xmpp:delay'");
                            break block0;
                        }
                        case "message": {
                            packet = PacketParserUtils.parseMessage((XmlPullParser)parser);
                            break block0;
                        }
                    }
                    LOGGER.warning("Unsupported forwarded packet type: " + name);
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() == initialDepth) break block12;
                }
            }
        }
        if (packet == null) {
            throw new IOException("forwarded extension must contain a packet");
        }
        return new Forwarded<Object>(packet, di);
    }

    public static Forwarded<Message> parseForwardedMessage(XmlPullParser parser, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException, ParseException {
        return ForwardedProvider.parseForwardedMessage(parser, parser.getDepth(), xmlEnvironment);
    }

    public static Forwarded<Message> parseForwardedMessage(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException, ParseException {
        Forwarded<Message> forwarded = INSTANCE.parse(parser, initialDepth, xmlEnvironment);
        if (!forwarded.isForwarded(Message.class)) {
            throw new SmackParsingException("Expecting a forwarded message, but got " + String.valueOf(forwarded));
        }
        return forwarded;
    }
}

