/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.time.packet;

import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.AbstractIqBuilder;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.IqView;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.time.packet.TimeBuilder;
import org.jivesoftware.smackx.time.packet.TimeView;
import org.jxmpp.util.XmppDateTime;

public class Time
extends IQ
implements TimeView {
    public static final String NAMESPACE = "urn:xmpp:time";
    public static final String ELEMENT = "time";
    private static final Logger LOGGER = Logger.getLogger(Time.class.getName());
    private final String utc;
    private final String tzo;

    public Time(TimeBuilder timeBuilder) {
        super((AbstractIqBuilder)timeBuilder, ELEMENT, NAMESPACE);
        this.utc = timeBuilder.getUtc();
        this.tzo = timeBuilder.getTzo();
        IQ.Type type = this.getType();
        switch (type) {
            case get: {
                if (this.utc != null) {
                    throw new IllegalArgumentException("Time requests must not have utc set");
                }
                if (this.tzo == null) break;
                throw new IllegalArgumentException("Time requests must not have tzo set");
            }
            case result: {
                StringUtils.requireNotNullNorEmpty((CharSequence)this.utc, (String)"Must have set a utc value");
                StringUtils.requireNotNullNorEmpty((CharSequence)this.tzo, (String)"Must have set a tzo value");
                break;
            }
            case error: {
                break;
            }
            case set: {
                throw new IllegalArgumentException("Invalid IQ type");
            }
        }
    }

    public Date getTime() {
        if (this.utc == null) {
            return null;
        }
        Date date = null;
        try {
            date = XmppDateTime.parseDate((String)this.utc);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error getting local time", e);
        }
        return date;
    }

    @Override
    public String getUtc() {
        return this.utc;
    }

    @Override
    public String getTzo() {
        return this.tzo;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        if (this.utc != null) {
            buf.rightAngleBracket();
            buf.element("utc", this.utc);
            buf.element("tzo", this.tzo);
        } else {
            buf.setEmptyElement();
        }
        return buf;
    }

    public static TimeBuilder builder(XMPPConnection connection) {
        return new TimeBuilder(connection);
    }

    public static TimeBuilder builder(IqData iqData) {
        return new TimeBuilder(iqData);
    }

    public static TimeBuilder builder(String stanzaId) {
        return new TimeBuilder(stanzaId);
    }

    public static TimeBuilder builder(Time timeRequest, Calendar calendar) {
        IqData iqData = IqData.createResponseData((IqView)timeRequest);
        return Time.builder(iqData).setTime(calendar);
    }

    public static TimeBuilder builder(Time timeRequest) {
        return Time.builder(timeRequest, Calendar.getInstance());
    }
}

