/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqprivate;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.iqprivate.packet.DefaultPrivateData;
import org.jivesoftware.smackx.iqprivate.packet.PrivateData;
import org.jivesoftware.smackx.iqprivate.packet.PrivateDataIQ;
import org.jivesoftware.smackx.iqprivate.provider.PrivateDataProvider;

public final class PrivateDataManager
extends Manager {
    private static final Map<XMPPConnection, PrivateDataManager> instances = new WeakHashMap<XMPPConnection, PrivateDataManager>();
    private static final Map<QName, PrivateDataProvider> privateDataProviders = new HashMap<QName, PrivateDataProvider>();
    private static final PrivateData DUMMY_PRIVATE_DATA = new PrivateData(){

        @Override
        public String getElementName() {
            return "smackDummyPrivateData";
        }

        @Override
        public String getNamespace() {
            return "https://igniterealtime.org/projects/smack";
        }

        @Override
        public CharSequence toXML() {
            return "<" + this.getElementName() + " xmlns='" + this.getNamespace() + "'/>";
        }
    };

    public static synchronized PrivateDataManager getInstanceFor(XMPPConnection connection) {
        PrivateDataManager privateDataManager = instances.get(connection);
        if (privateDataManager == null) {
            privateDataManager = new PrivateDataManager(connection);
        }
        return privateDataManager;
    }

    public static PrivateDataProvider getPrivateDataProvider(String elementName, String namespace) {
        QName key = new QName(namespace, elementName);
        return privateDataProviders.get(key);
    }

    public static void addPrivateDataProvider(String elementName, String namespace, PrivateDataProvider provider) {
        QName key = new QName(namespace, elementName);
        privateDataProviders.put(key, provider);
    }

    public static void removePrivateDataProvider(String elementName, String namespace) {
        QName key = new QName(namespace, elementName);
        privateDataProviders.remove(key);
    }

    private PrivateDataManager(XMPPConnection connection) {
        super(connection);
        instances.put(connection, this);
    }

    public PrivateData getPrivateData(String elementName, String namespace) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PrivateDataIQ privateDataGet = new PrivateDataIQ(elementName, namespace);
        PrivateDataIQ response = (PrivateDataIQ)this.connection().sendIqRequestAndWaitForResponse((IQ)privateDataGet);
        return response.getPrivateData();
    }

    public void setPrivateData(PrivateData privateData) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PrivateDataIQ privateDataSet = new PrivateDataIQ(privateData);
        this.connection().sendIqRequestAndWaitForResponse((IQ)privateDataSet);
    }

    public boolean isSupported() throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException {
        try {
            this.setPrivateData(DUMMY_PRIVATE_DATA);
            return true;
        }
        catch (XMPPException.XMPPErrorException e) {
            if (e.getStanzaError().getCondition() == StanzaError.Condition.service_unavailable) {
                return false;
            }
            throw e;
        }
    }

    public static class PrivateDataIQProvider
    extends IqProvider<PrivateDataIQ> {
        public PrivateDataIQ parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
            PrivateData privateData = null;
            boolean done = false;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT) {
                    String namespace;
                    String elementName = parser.getName();
                    PrivateDataProvider provider = PrivateDataManager.getPrivateDataProvider(elementName, namespace = parser.getNamespace());
                    if (provider != null) {
                        privateData = provider.parsePrivateData(parser);
                        continue;
                    }
                    DefaultPrivateData data = new DefaultPrivateData(elementName, namespace);
                    boolean finished = false;
                    while (!finished) {
                        XmlPullParser.Event event = parser.next();
                        if (event == XmlPullParser.Event.START_ELEMENT) {
                            String name = parser.getName();
                            event = parser.next();
                            if (event == XmlPullParser.Event.TEXT_CHARACTERS) {
                                String value = parser.getText();
                                data.setValue(name, value);
                                continue;
                            }
                            if (event != XmlPullParser.Event.END_ELEMENT) continue;
                            data.setValue(name, "");
                            continue;
                        }
                        if (event != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals(elementName)) continue;
                        finished = true;
                    }
                    privateData = data;
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("query")) continue;
                done = true;
            }
            return new PrivateDataIQ(privateData);
        }
    }
}

