/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.element;

import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.jingle.element.JingleContentDescription;
import org.jivesoftware.smackx.jingle.element.JingleContentTransport;

public final class JingleContent
implements XmlElement {
    public static final String ELEMENT = "content";
    public static final String NAMESPACE = "urn:xmpp:jingle:1";
    public static final String CREATOR_ATTRIBUTE_NAME = "creator";
    private final Creator creator;
    public static final String DISPOSITION_ATTRIBUTE_NAME = "disposition";
    private final String disposition;
    public static final String NAME_ATTRIBUTE_NAME = "name";
    private final String name;
    public static final String SENDERS_ATTRIBUTE_NAME = "senders";
    private final Senders senders;
    private final JingleContentDescription description;
    private final JingleContentTransport transport;

    private JingleContent(Creator creator, String disposition, String name, Senders senders, JingleContentDescription description, JingleContentTransport transport) {
        this.creator = (Creator)((Object)Objects.requireNonNull((Object)((Object)creator), (String)"Jingle content creator must not be null"));
        this.disposition = disposition;
        this.name = (String)StringUtils.requireNotNullNorEmpty((CharSequence)name, (String)"Jingle content name must not be null nor empty");
        this.senders = senders;
        this.description = description;
        this.transport = transport;
    }

    public Creator getCreator() {
        return this.creator;
    }

    public String getDisposition() {
        return this.disposition;
    }

    public String getName() {
        return this.name;
    }

    public Senders getSenders() {
        return this.senders;
    }

    public JingleContentDescription getDescription() {
        return this.description;
    }

    @Deprecated
    public JingleContentTransport getJingleTransport() {
        return this.getTransport();
    }

    public JingleContentTransport getTransport() {
        return this.transport;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML(XmlEnvironment enclosingXmlEnvironment) {
        XmlStringBuilder xml = new XmlStringBuilder((XmlElement)this, enclosingXmlEnvironment);
        xml.attribute(CREATOR_ATTRIBUTE_NAME, (Enum)this.creator);
        xml.optAttribute(DISPOSITION_ATTRIBUTE_NAME, this.disposition);
        xml.attribute(NAME_ATTRIBUTE_NAME, this.name);
        xml.optAttribute(SENDERS_ATTRIBUTE_NAME, (Enum)this.senders);
        if (this.description == null && this.transport == null) {
            return xml.closeEmptyElement();
        }
        xml.rightAngleBracket();
        xml.optAppend((Element)this.description);
        xml.optElement((Element)this.transport);
        xml.closeElement((NamedElement)this);
        return xml;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public static enum Creator {
        initiator,
        responder;

    }

    public static enum Senders {
        both,
        initiator,
        none,
        responder;

    }

    public static final class Builder {
        private Creator creator;
        private String disposition;
        private String name;
        private Senders senders;
        private JingleContentDescription description;
        private JingleContentTransport transport;

        private Builder() {
        }

        public Builder setCreator(Creator creator) {
            this.creator = creator;
            return this;
        }

        public Builder setDisposition(String disposition) {
            this.disposition = disposition;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setSenders(Senders senders) {
            this.senders = senders;
            return this;
        }

        public Builder setDescription(JingleContentDescription description) {
            if (this.description != null) {
                throw new IllegalStateException("Jingle content description already set");
            }
            this.description = description;
            return this;
        }

        public Builder setTransport(JingleContentTransport transport) {
            this.transport = transport;
            return this;
        }

        public JingleContent build() {
            return new JingleContent(this.creator, this.disposition, this.name, this.senders, this.description, this.transport);
        }
    }
}

