/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jiveproperties.packet;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;

public class JivePropertiesExtension
implements ExtensionElement {
    public static final String NAMESPACE = "http://www.jivesoftware.com/xmlns/xmpp/properties";
    public static final String ELEMENT = "properties";
    public static final QName QNAME = new QName("http://www.jivesoftware.com/xmlns/xmpp/properties", "properties");
    private static final Logger LOGGER = Logger.getLogger(JivePropertiesExtension.class.getName());
    private final Map<String, Object> properties;

    public JivePropertiesExtension() {
        this.properties = new HashMap<String, Object>();
    }

    public JivePropertiesExtension(Map<String, Object> properties) {
        this.properties = properties;
    }

    public synchronized Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public synchronized void setProperty(String name, Object value) {
        if (!(value instanceof Serializable)) {
            throw new IllegalArgumentException("Value must be serializable");
        }
        this.properties.put(name, value);
    }

    public synchronized void deleteProperty(String name) {
        if (this.properties == null) {
            return;
        }
        this.properties.remove(name);
    }

    public synchronized Collection<String> getPropertyNames() {
        if (this.properties == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<String>(this.properties.keySet()));
    }

    public synchronized Map<String, Object> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(new HashMap<String, Object>(this.properties));
    }

    public String getElementName() {
        return ELEMENT;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public CharSequence toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder((XmlElement)this);
        xml.rightAngleBracket();
        for (String name : this.getPropertyNames()) {
            Object valueStr;
            String type;
            Object value = this.getProperty(name);
            xml.openElement("property");
            xml.element("name", name);
            xml.halfOpenElement("value");
            if (value instanceof Integer) {
                type = "integer";
                valueStr = Integer.toString((Integer)value);
            } else if (value instanceof Long) {
                type = "long";
                valueStr = Long.toString((Long)value);
            } else if (value instanceof Float) {
                type = "float";
                valueStr = Float.toString(((Float)value).floatValue());
            } else if (value instanceof Double) {
                type = "double";
                valueStr = Double.toString((Double)value);
            } else if (value instanceof Boolean) {
                type = "boolean";
                valueStr = Boolean.toString((Boolean)value);
            } else if (value instanceof String) {
                type = "string";
                valueStr = (String)value;
            } else {
                try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                     ObjectOutputStream out = new ObjectOutputStream(byteStream);){
                    out.writeObject(value);
                    type = "java-object";
                    valueStr = Base64.encodeToString((byte[])byteStream.toByteArray());
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Error encoding java object", e);
                    type = "java-object";
                    valueStr = "Serializing error: " + e.getMessage();
                }
            }
            xml.attribute("type", type);
            xml.rightAngleBracket();
            xml.escape((String)valueStr);
            xml.closeElement("value");
            xml.closeElement("property");
        }
        xml.closeElement((NamedElement)this);
        return xml;
    }

    public static JivePropertiesExtension from(Message message) {
        return (JivePropertiesExtension)message.getExtension(JivePropertiesExtension.class);
    }
}

