/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc.packet;

import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.muc.MUCAffiliation;
import org.jivesoftware.smackx.muc.MUCRole;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Resourcepart;

public class MUCItem
implements NamedElement {
    public static final String ELEMENT = "item";
    private final MUCAffiliation affiliation;
    private final MUCRole role;
    private final Jid actor;
    private final Resourcepart actorNick;
    private final String reason;
    private final Jid jid;
    private final Resourcepart nick;

    public MUCItem(MUCAffiliation affiliation) {
        this(affiliation, null, null, null, null, null, null);
    }

    public MUCItem(MUCRole role) {
        this(null, role, null, null, null, null, null);
    }

    public MUCItem(MUCRole role, Resourcepart nick) {
        this(null, role, null, null, null, nick, null);
    }

    public MUCItem(MUCAffiliation affiliation, Jid jid, String reason) {
        this(affiliation, null, null, reason, jid, null, null);
    }

    public MUCItem(MUCAffiliation affiliation, Jid jid) {
        this(affiliation, null, null, null, jid, null, null);
    }

    public MUCItem(MUCRole role, Resourcepart nick, String reason) {
        this(null, role, null, reason, null, nick, null);
    }

    public MUCItem(MUCAffiliation affiliation, MUCRole role, Jid actor, String reason, Jid jid, Resourcepart nick, Resourcepart actorNick) {
        this.affiliation = affiliation;
        this.role = role;
        this.actor = actor;
        this.reason = reason;
        this.jid = jid;
        this.nick = nick;
        this.actorNick = actorNick;
    }

    public Jid getActor() {
        return this.actor;
    }

    public Resourcepart getActorNick() {
        return this.actorNick;
    }

    public String getReason() {
        return this.reason;
    }

    public MUCAffiliation getAffiliation() {
        return this.affiliation;
    }

    public Jid getJid() {
        return this.jid;
    }

    public Resourcepart getNick() {
        return this.nick;
    }

    public MUCRole getRole() {
        return this.role;
    }

    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder((NamedElement)this);
        xml.optAttribute("affiliation", (Enum)this.getAffiliation());
        xml.optAttribute("jid", (CharSequence)this.getJid());
        xml.optAttribute("nick", (CharSequence)this.getNick());
        xml.optAttribute("role", (Enum)this.getRole());
        xml.rightAngleBracket();
        xml.optElement("reason", this.getReason());
        if (this.getActor() != null || this.getActorNick() != null) {
            xml.halfOpenElement("actor");
            xml.optAttribute("jid", (CharSequence)this.getActor());
            xml.optAttribute("nick", (CharSequence)this.getActorNick());
            xml.closeEmptyElement();
        }
        xml.closeElement(ELEMENT);
        return xml;
    }

    public String getElementName() {
        return ELEMENT;
    }
}

