/**
 *
 * Copyright 2003-2007 Jive Software.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jivesoftware.smackx.muc.provider;

import java.io.IOException;

import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

import org.jivesoftware.smackx.muc.packet.MUCOwner;

import org.jxmpp.JxmppContext;

/**
 * The MUCOwnerProvider parses MUCOwner packets. (@see MUCOwner)
 *
 * @author Gaston Dombiak
 */
public class MUCOwnerProvider extends IqProvider<MUCOwner> {

    @Override
    public MUCOwner parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment,
                    JxmppContext jxmppContext) throws XmlPullParserException, IOException, SmackParsingException {
        MUCOwner mucOwner = new MUCOwner();
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (parser.getName().equals("item")) {
                    var item = MUCParserUtils.parseItem(parser, jxmppContext);
                    mucOwner.addItem(item);
                }
                else if (parser.getName().equals("destroy")) {
                    var destory = MUCParserUtils.parseDestroy(parser, jxmppContext);
                    mucOwner.setDestroy(destory);
                }
                // Otherwise, it must be a packet extension.
                else {
                    PacketParserUtils.addExtensionElement(mucOwner, parser, xmlEnvironment, jxmppContext);
                }
            }
            else if (eventType == XmlPullParser.Event.END_ELEMENT) {
                if (parser.getName().equals("query")) {
                    done = true;
                }
            }
        }

        return mucOwner;
    }
}
