/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.amp.provider;

import java.io.IOException;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.amp.AMPDeliverCondition;
import org.jivesoftware.smackx.amp.AMPExpireAtCondition;
import org.jivesoftware.smackx.amp.AMPMatchResourceCondition;
import org.jivesoftware.smackx.amp.packet.AMPExtension;
import org.jxmpp.JxmppContext;

public class AMPExtensionProvider
extends ExtensionElementProvider<AMPExtension> {
    private static final Logger LOGGER = Logger.getLogger(AMPExtensionProvider.class.getName());

    public AMPExtension parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        String from = parser.getAttributeValue(null, "from");
        String to = parser.getAttributeValue(null, "to");
        String statusString = parser.getAttributeValue(null, "status");
        AMPExtension.Status status = null;
        if (statusString != null) {
            try {
                status = AMPExtension.Status.valueOf(statusString);
            }
            catch (IllegalArgumentException ex) {
                LOGGER.severe("Found invalid amp status " + statusString);
            }
        }
        AMPExtension ampExtension = new AMPExtension(from, to, status);
        String perHopValue = parser.getAttributeValue(null, "per-hop");
        if (perHopValue != null) {
            boolean perHop = Boolean.parseBoolean(perHopValue);
            ampExtension.setPerHop(perHop);
        }
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (!parser.getName().equals("rule")) continue;
                String actionString = parser.getAttributeValue(null, "action");
                String conditionName = parser.getAttributeValue(null, "condition");
                String conditionValue = parser.getAttributeValue(null, "value");
                AMPExtension.Condition condition = AMPExtensionProvider.createCondition(conditionName, conditionValue);
                AMPExtension.Action action = null;
                if (actionString != null) {
                    try {
                        action = AMPExtension.Action.valueOf(actionString);
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.severe("Found invalid rule action value " + actionString);
                    }
                }
                if (action == null || condition == null) {
                    LOGGER.severe("Rule is skipped because either it's action or it's condition is invalid");
                    continue;
                }
                AMPExtension.Rule rule = new AMPExtension.Rule(action, condition);
                ampExtension.addRule(rule);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("amp")) continue;
            done = true;
        }
        return ampExtension;
    }

    private static AMPExtension.Condition createCondition(String name, String value) {
        if (name == null || value == null) {
            LOGGER.severe("Can't create rule condition from null name and/or value");
            return null;
        }
        if ("deliver".equals(name)) {
            try {
                return new AMPDeliverCondition(AMPDeliverCondition.Value.valueOf(value));
            }
            catch (IllegalArgumentException ex) {
                LOGGER.severe("Found invalid rule delivery condition value " + value);
                return null;
            }
        }
        if ("expire-at".equals(name)) {
            return new AMPExpireAtCondition(value);
        }
        if ("match-resource".equals(name)) {
            try {
                return new AMPMatchResourceCondition(AMPMatchResourceCondition.Value.valueOf(value));
            }
            catch (IllegalArgumentException ex) {
                LOGGER.severe("Found invalid rule match-resource condition value " + value);
                return null;
            }
        }
        LOGGER.severe("Found unknown rule condition name " + name);
        return null;
    }
}

