/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bookmarks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.bookmarks.BookmarkedConference;
import org.jivesoftware.smackx.bookmarks.BookmarkedURL;
import org.jivesoftware.smackx.iqprivate.packet.PrivateData;
import org.jivesoftware.smackx.iqprivate.provider.PrivateDataProvider;
import org.jxmpp.JxmppContext;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.parts.Resourcepart;

public class Bookmarks
implements PrivateData {
    public static final String NAMESPACE = "storage:bookmarks";
    public static final String ELEMENT = "storage";
    private final List<BookmarkedURL> bookmarkedURLS = new ArrayList<BookmarkedURL>();
    private final List<BookmarkedConference> bookmarkedConferences = new ArrayList<BookmarkedConference>();

    public void addBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.add(bookmarkedURL);
    }

    public void removeBookmarkedURL(BookmarkedURL bookmarkedURL) {
        this.bookmarkedURLS.remove(bookmarkedURL);
    }

    public void clearBookmarkedURLS() {
        this.bookmarkedURLS.clear();
    }

    public void addBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.add(bookmarkedConference);
    }

    public void removeBookmarkedConference(BookmarkedConference bookmarkedConference) {
        this.bookmarkedConferences.remove(bookmarkedConference);
    }

    public void clearBookmarkedConferences() {
        this.bookmarkedConferences.clear();
    }

    public List<BookmarkedURL> getBookmarkedURLS() {
        return this.bookmarkedURLS;
    }

    public List<BookmarkedConference> getBookmarkedConferences() {
        return this.bookmarkedConferences;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    public XmlStringBuilder toXML() {
        XmlStringBuilder buf = new XmlStringBuilder();
        buf.halfOpenElement(ELEMENT).xmlnsAttribute(NAMESPACE).rightAngleBracket();
        for (BookmarkedURL urlStorage : this.getBookmarkedURLS()) {
            if (urlStorage.isShared()) continue;
            buf.halfOpenElement("url").attribute("name", urlStorage.getName()).attribute("url", urlStorage.getURL());
            buf.condAttribute(urlStorage.isRss(), "rss", "true");
            buf.closeEmptyElement();
        }
        for (BookmarkedConference conference : this.getBookmarkedConferences()) {
            if (conference.isShared()) continue;
            buf.halfOpenElement("conference");
            buf.attribute("name", conference.getName());
            buf.attribute("autojoin", Boolean.toString(conference.isAutoJoin()));
            buf.attribute("jid", (CharSequence)conference.getJid());
            buf.rightAngleBracket();
            buf.optElement("nick", (CharSequence)conference.getNickname());
            buf.optElement("password", conference.getPassword());
            buf.closeElement("conference");
        }
        buf.closeElement(ELEMENT);
        return buf;
    }

    private static BookmarkedURL getURLStorage(XmlPullParser parser) throws IOException, XmlPullParserException {
        String name = parser.getAttributeValue("", "name");
        String url = parser.getAttributeValue("", "url");
        String rssString = parser.getAttributeValue("", "rss");
        boolean rss = rssString != null && "true".equals(rssString);
        BookmarkedURL urlStore = new BookmarkedURL(url, name, rss);
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT && "shared_bookmark".equals(parser.getName())) {
                urlStore.setShared(true);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !"url".equals(parser.getName())) continue;
            done = true;
        }
        return urlStore;
    }

    private static BookmarkedConference getConferenceStorage(XmlPullParser parser, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        String name = parser.getAttributeValue("", "name");
        boolean autojoin = ParserUtils.getBooleanAttribute((XmlPullParser)parser, (String)"autojoin", (boolean)false);
        EntityBareJid jid = ParserUtils.getBareJidAttribute((XmlPullParser)parser, (JxmppContext)jxmppContext);
        BookmarkedConference conf = new BookmarkedConference(jid);
        conf.setName(name);
        conf.setAutoJoin(autojoin);
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT && "nick".equals(parser.getName())) {
                String nickString = parser.nextText();
                conf.setNickname(Resourcepart.from((String)nickString));
                continue;
            }
            if (eventType == XmlPullParser.Event.START_ELEMENT && "password".equals(parser.getName())) {
                conf.setPassword(parser.nextText());
                continue;
            }
            if (eventType == XmlPullParser.Event.START_ELEMENT && "shared_bookmark".equals(parser.getName())) {
                conf.setShared(true);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !"conference".equals(parser.getName())) continue;
            done = true;
        }
        return conf;
    }

    public static class Provider
    implements PrivateDataProvider {
        @Override
        public PrivateData parsePrivateData(XmlPullParser parser, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
            Bookmarks storage = new Bookmarks();
            boolean done = false;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT && "url".equals(parser.getName())) {
                    BookmarkedURL urlStorage = Bookmarks.getURLStorage(parser);
                    if (urlStorage == null) continue;
                    storage.addBookmarkedURL(urlStorage);
                    continue;
                }
                if (eventType == XmlPullParser.Event.START_ELEMENT && "conference".equals(parser.getName())) {
                    BookmarkedConference conference = Bookmarks.getConferenceStorage(parser, jxmppContext);
                    storage.addBookmarkedConference(conference);
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !Bookmarks.ELEMENT.equals(parser.getName())) continue;
                done = true;
            }
            return storage;
        }
    }
}

