/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jiveproperties.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.DoOnce;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.jiveproperties.JivePropertiesManager;
import org.jivesoftware.smackx.jiveproperties.packet.JivePropertiesExtension;
import org.jxmpp.JxmppContext;

public class JivePropertiesExtensionProvider
extends ExtensionElementProvider<JivePropertiesExtension> {
    private static final DoOnce LOG_OBJECT_NOT_ENABLED = new DoOnce();
    private static final Logger LOGGER = Logger.getLogger(JivePropertiesExtensionProvider.class.getName());

    public JivePropertiesExtension parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        block2: while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser.next()) == XmlPullParser.Event.START_ELEMENT && parser.getName().equals("property")) {
                boolean done = false;
                String name = null;
                String type = null;
                String valueText = null;
                Object value = null;
                while (true) {
                    if (done) continue block2;
                    eventType = parser.next();
                    if (eventType == XmlPullParser.Event.START_ELEMENT) {
                        String elementName = parser.getName();
                        if (elementName.equals("name")) {
                            name = parser.nextText();
                            continue;
                        }
                        if (!elementName.equals("value")) continue;
                        type = parser.getAttributeValue("", "type");
                        valueText = parser.nextText();
                        continue;
                    }
                    if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("property")) continue;
                    if ("integer".equals(type)) {
                        value = Integer.valueOf(valueText);
                    } else if ("long".equals(type)) {
                        value = Long.valueOf(valueText);
                    } else if ("float".equals(type)) {
                        value = Float.valueOf(valueText);
                    } else if ("double".equals(type)) {
                        value = Double.valueOf(valueText);
                    } else if ("boolean".equals(type)) {
                        value = Boolean.valueOf(valueText);
                    } else if ("string".equals(type)) {
                        value = valueText;
                    } else if ("java-object".equals(type)) {
                        if (JivePropertiesManager.isJavaObjectEnabled()) {
                            try {
                                byte[] bytes = Base64.decode((String)valueText);
                                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
                                value = in.readObject();
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.SEVERE, "Error parsing java object", e);
                            }
                        } else {
                            LOG_OBJECT_NOT_ENABLED.once(() -> LOGGER.severe("JavaObject is not enabled. Enable with JivePropertiesManager.setJavaObjectEnabled(true)"));
                        }
                    }
                    if (name != null && value != null) {
                        properties.put(name, value);
                    }
                    done = true;
                }
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser.getName().equals("properties")) break;
        }
        return new JivePropertiesExtension(properties);
    }
}

