/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.time.packet;

import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.AbstractIqBuilder;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.IqView;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.time.packet.TimeBuilder;
import org.jivesoftware.smackx.time.packet.TimeView;

public class Time
extends IQ
implements TimeView {
    public static final String NAMESPACE = "urn:xmpp:time";
    public static final String ELEMENT = "time";
    private final ZonedDateTime zonedDateTime;

    public Time(TimeBuilder timeBuilder) {
        super((AbstractIqBuilder)timeBuilder, ELEMENT, NAMESPACE);
        this.zonedDateTime = timeBuilder.getZonedDateTime();
        IQ.Type type = this.getType();
        switch (type) {
            case get: {
                if (this.zonedDateTime == null) break;
                throw new IllegalArgumentException("Time requests must not have time set");
            }
            case result: {
                Objects.requireNonNull((Object)this.zonedDateTime, (String)"Must have set a time value");
                break;
            }
            case error: {
                break;
            }
            case set: {
                throw new IllegalArgumentException("Invalid IQ type");
            }
        }
    }

    @Override
    public ZonedDateTime getZonedDateTime() {
        return this.zonedDateTime;
    }

    @Deprecated
    public Date getTime() {
        if (this.zonedDateTime == null) {
            return null;
        }
        return Date.from(this.zonedDateTime.toInstant());
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        if (this.zonedDateTime != null) {
            buf.rightAngleBracket();
            buf.element("utc", this.getUtc());
            buf.element("tzo", this.getTzo());
        } else {
            buf.setEmptyElement();
        }
        return buf;
    }

    public static TimeBuilder builder(XMPPConnection connection) {
        return new TimeBuilder(connection);
    }

    public static TimeBuilder builder(IqData iqData) {
        return new TimeBuilder(iqData);
    }

    public static TimeBuilder builder(String stanzaId) {
        return new TimeBuilder(stanzaId);
    }

    public static TimeBuilder builder(Time timeRequest, Calendar calendar) {
        IqData iqData = IqData.createResponseData((IqView)timeRequest);
        return Time.builder(iqData).setTime(calendar);
    }

    public static TimeBuilder builder(Time timeRequest) {
        return Time.builder(timeRequest, Calendar.getInstance());
    }
}

