/*
 *
 * Copyright 2018 Paul Schaub.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jivesoftware.smackx.mood;

/**
 * Moods specified by XEP-0107: User Mood.
 *
 * @see <a href="https://xmpp.org/extensions/xep-0107.html#moods">
 *     XEP-0107 §3: Mood Values</a>
 */
public enum Mood {
    afraid,
    amazed,
    amorous,
    angry,
    annoyed,
    anxious,
    aroused,
    ashamed,
    bored,
    brave,
    calm,
    cautious,
    cold,
    confident,
    confused,
    contemplative,
    contented,
    cranky,
    crazy,
    creative,
    curious,
    dejected,
    depressed,
    disappointed,
    disgusted,
    dismayed,
    distracted,
    embarrassed,
    envious,
    excited,
    flirtatious,
    frustrated,
    grateful,
    grieving,
    grumpy,
    guilty,
    happy,
    hopeful,
    hot,
    humbled,
    humiliated,
    hungry,
    hurt,
    impressed,
    in_awe,
    in_love,
    indignant,
    interested,
    intoxicated,
    invincible,
    jealous,
    lonely,
    lost,
    lucky,
    mean,
    moody,
    nervous,
    neutral,
    offended,
    outraged,
    playful,
    proud,
    relaxed,
    relieved,
    remorseful,
    restless,
    sad,
    sarcastic,
    satisfied,
    serious,
    shocked,
    shy,
    sick,
    sleepy,
    spontaneous,
    stressed,
    strong,
    surprised,
    thankful,
    thirsty,
    tired,
    undefined,
    weak,
    worried
}
