/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.amp.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.amp.AMPDeliverCondition;
import org.jivesoftware.smackx.amp.AMPExpireAtCondition;
import org.jivesoftware.smackx.amp.AMPMatchResourceCondition;
import org.jivesoftware.smackx.amp.packet.AMPExtension;
import org.jxmpp.JxmppContext;

public class AMPExtensionProvider
extends ExtensionElementProvider<AMPExtension> {
    public AMPExtension parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException, SmackParsingException {
        String from = parser.getAttributeValue(null, "from");
        String to = parser.getAttributeValue(null, "to");
        String statusString = parser.getAttributeValue(null, "status");
        AMPExtension.Status status = null;
        if (statusString != null) {
            try {
                status = AMPExtension.Status.valueOf(statusString);
            }
            catch (IllegalArgumentException ex) {
                throw new SmackParsingException("Invalid AMP status: " + statusString, (Exception)ex);
            }
        }
        AMPExtension ampExtension = new AMPExtension(from, to, status);
        String perHopValue = parser.getAttributeValue(null, "per-hop");
        if (perHopValue != null) {
            boolean perHop = Boolean.parseBoolean(perHopValue);
            ampExtension.setPerHop(perHop);
        }
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (!parser.getName().equals("rule")) continue;
                String actionString = parser.getAttributeValue(null, "action");
                String conditionName = parser.getAttributeValue(null, "condition");
                String conditionValue = parser.getAttributeValue(null, "value");
                AMPExtension.Condition condition = AMPExtensionProvider.createCondition(conditionName, conditionValue);
                AMPExtension.Action action = null;
                if (actionString != null) {
                    try {
                        action = AMPExtension.Action.valueOf(actionString);
                    }
                    catch (IllegalArgumentException ex) {
                        throw new SmackParsingException("Found invalid rule action value " + actionString, (Exception)ex);
                    }
                }
                AMPExtension.Rule rule = new AMPExtension.Rule(action, condition);
                ampExtension.addRule(rule);
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("amp")) continue;
            done = true;
        }
        return ampExtension;
    }

    private static AMPExtension.Condition createCondition(String name, String value) throws SmackParsingException {
        if (StringUtils.isNullOrEmpty((CharSequence)name)) {
            throw new SmackParsingException("Can't have a condition without a name");
        }
        if (StringUtils.isNullOrEmpty((CharSequence)value)) {
            throw new SmackParsingException("Can't have a condition " + name + " without value");
        }
        if ("deliver".equals(name)) {
            try {
                return new AMPDeliverCondition(AMPDeliverCondition.Value.valueOf(value));
            }
            catch (IllegalArgumentException ex) {
                throw new SmackParsingException("Found invalid rule delivery condition value " + value, (Exception)ex);
            }
        }
        if ("expire-at".equals(name)) {
            return new AMPExpireAtCondition(value);
        }
        if ("match-resource".equals(name)) {
            try {
                return new AMPMatchResourceCondition(AMPMatchResourceCondition.Value.valueOf(value));
            }
            catch (IllegalArgumentException ex) {
                throw new SmackParsingException("Found invalid rule match-resource condition value " + value, (Exception)ex);
            }
        }
        throw new SmackParsingException("Found unknown rule condition name " + name);
    }
}

