/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.disco.packet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.AbstractIqBuilder;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoView;
import org.jxmpp.util.XmppStringUtils;

public class DiscoverInfo
extends IQ
implements DiscoverInfoView {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "http://jabber.org/protocol/disco#info";
    private final List<Feature> features = new ArrayList<Feature>();
    private final Set<Feature> featuresSet = new HashSet<Feature>();
    private final List<Identity> identities = new ArrayList<Identity>();
    private final Set<String> identitiesSet = new HashSet<String>();
    private String node;
    private boolean containsDuplicateFeatures;

    DiscoverInfo(DiscoverInfoBuilder builder, boolean validate) {
        super((AbstractIqBuilder)builder, ELEMENT, NAMESPACE);
        this.features.addAll(builder.getFeatures());
        this.identities.addAll(builder.getIdentities());
        this.node = builder.getNode();
        for (Feature feature : this.features) {
            boolean featureIsNew = this.featuresSet.add(feature);
            if (featureIsNew) continue;
            this.containsDuplicateFeatures = true;
        }
        for (Identity identity : this.identities) {
            this.identitiesSet.add(identity.getKey());
        }
        if (!validate) {
            return;
        }
        if (this.containsDuplicateFeatures) {
            throw new IllegalArgumentException("The disco#info request contains duplicate features.");
        }
    }

    public DiscoverInfo(DiscoverInfo d) {
        super((IQ)d);
        this.node = d.getNode();
        this.features.addAll(d.features);
        this.featuresSet.addAll(d.featuresSet);
        this.identities.addAll(d.identities);
        this.identitiesSet.addAll(d.identitiesSet);
    }

    @Override
    public List<Feature> getFeatures() {
        return Collections.unmodifiableList(this.features);
    }

    @Override
    public List<Identity> getIdentities() {
        return Collections.unmodifiableList(this.identities);
    }

    public boolean hasIdentity(String category, String type) {
        String key = XmppStringUtils.generateKey((String)category, (String)type);
        return this.identitiesSet.contains(key);
    }

    public List<Identity> getIdentities(String category, String type) {
        ArrayList<Identity> res = new ArrayList<Identity>(this.identities.size());
        for (Identity identity : this.identities) {
            if (!identity.getCategory().equals(category) || !identity.getType().equals(type)) continue;
            res.add(identity);
        }
        return res;
    }

    @Override
    public String getNode() {
        return this.node;
    }

    public boolean containsFeature(CharSequence feature) {
        return this.features.contains(new Feature(feature));
    }

    public boolean containsFeatures(String ... features) {
        List<String> featuresList = Arrays.asList(features);
        return this.containsFeatures(featuresList);
    }

    public boolean containsFeatures(Collection<? extends CharSequence> features) {
        return this.features.stream().map(f -> f.getVar()).collect(Collectors.toList()).containsAll(features.stream().map(f -> f.toString()).collect(Collectors.toList()));
    }

    public static boolean nullSafeContainsFeature(DiscoverInfo discoverInfo, CharSequence feature) {
        if (discoverInfo == null) {
            return false;
        }
        return discoverInfo.containsFeature(feature);
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.optAttribute("node", this.getNode());
        xml.rightAngleBracket();
        for (Identity identity : this.identities) {
            xml.append(identity.toXML());
        }
        for (Feature feature : this.features) {
            xml.append(feature.toXML());
        }
        return xml;
    }

    public boolean containsDuplicateIdentities() {
        ArrayList<Identity> checkedIdentities = new ArrayList<Identity>(this.identities.size());
        for (Identity i : this.identities) {
            for (Identity i2 : checkedIdentities) {
                if (!i.equals(i2)) continue;
                return true;
            }
            checkedIdentities.add(i);
        }
        return false;
    }

    public boolean containsDuplicateFeatures() {
        return this.containsDuplicateFeatures;
    }

    public DiscoverInfoBuilder asBuilder(String stanzaId) {
        return new DiscoverInfoBuilder(this, stanzaId);
    }

    public static DiscoverInfoBuilder builder(XMPPConnection connection) {
        return new DiscoverInfoBuilder(connection);
    }

    public static DiscoverInfoBuilder builder(IqData iqData) {
        return new DiscoverInfoBuilder(iqData);
    }

    public static DiscoverInfoBuilder builder(String stanzaId) {
        return new DiscoverInfoBuilder(stanzaId);
    }

    public static final class Feature {
        private final String variable;

        public Feature(Feature feature) {
            this.variable = feature.variable;
        }

        public Feature(CharSequence variable) {
            this(variable.toString());
        }

        public Feature(String variable) {
            this.variable = (String)StringUtils.requireNotNullNorEmpty((CharSequence)variable, (String)"variable cannot be null");
        }

        public String getVar() {
            return this.variable;
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement("feature");
            xml.attribute("var", this.variable);
            xml.closeEmptyElement();
            return xml;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Feature) {
                Feature otherFeature = (Feature)obj;
                return this.variable.equals(otherFeature.variable);
            }
            if (obj instanceof CharSequence) {
                String otherFeature = obj.toString();
                return this.variable.equals(otherFeature);
            }
            return false;
        }

        public int hashCode() {
            return this.variable.hashCode();
        }

        public String toString() {
            return this.toXML().toString();
        }
    }

    public static final class Identity
    implements Comparable<Identity> {
        private final String category;
        private final String type;
        private final String key;
        private final String name;
        private final String lang;
        private final HashCode.Cache hashCodeCache = new HashCode.Cache();

        public Identity(String category, String type) {
            this(category, type, null, null);
        }

        public Identity(String category, String name, String type) {
            this(category, type, name, null);
        }

        public Identity(String category, String type, String name, String lang) {
            this.category = (String)StringUtils.requireNotNullNorEmpty((CharSequence)category, (String)"category cannot be null");
            this.type = (String)StringUtils.requireNotNullNorEmpty((CharSequence)type, (String)"type cannot be null");
            this.key = XmppStringUtils.generateKey((String)category, (String)type);
            this.name = name;
            this.lang = lang;
        }

        public String getCategory() {
            return this.category;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getLanguage() {
            return this.lang;
        }

        private String getKey() {
            return this.key;
        }

        public boolean isOfCategoryAndType(String category, String type) {
            return this.category.equals(category) && this.type.equals(type);
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement("identity");
            xml.xmllangAttribute(this.lang);
            xml.attribute("category", this.category);
            xml.optAttribute("name", this.name);
            xml.optAttribute("type", this.type);
            xml.closeEmptyElement();
            return xml;
        }

        public boolean equals(Object obj) {
            return EqualsUtil.equals((Object)this, (Object)obj, (e, o) -> e.append((Object)this.key, (Object)o.key).append((Object)this.lang, (Object)o.lang).append((Object)this.name, (Object)o.name));
        }

        public int hashCode() {
            return this.hashCodeCache.getHashCode(c -> c.append((Object)this.key).append((Object)this.lang).append((Object)this.name));
        }

        @Override
        public int compareTo(Identity other) {
            String thisType;
            String otherLang = other.lang == null ? "" : other.lang;
            String thisLang = this.lang == null ? "" : this.lang;
            String otherType = other.type == null ? "" : other.type;
            String string = thisType = this.type == null ? "" : this.type;
            if (this.category.equals(other.category)) {
                if (thisType.equals(otherType)) {
                    if (thisLang.equals(otherLang)) {
                        return 0;
                    }
                    return thisLang.compareTo(otherLang);
                }
                return thisType.compareTo(otherType);
            }
            return this.category.compareTo(other.category);
        }

        public String toString() {
            return this.toXML().toString();
        }
    }
}

