/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.formtypes;

import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlUtil;
import org.jivesoftware.smack.xml.SmackXmlParser;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.TextSingleFormField;
import org.jivesoftware.smackx.xdata.XDataManager;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class FormFieldRegistry {
    private static final Logger LOGGER = Logger.getLogger(FormFieldRegistry.class.getName());
    private static final Map<String, Map<String, FormField.Type>> REGISTRY = new HashMap<String, Map<String, FormField.Type>>();
    private static final Map<String, FormField.Type> CLARK_NOTATION_FIELD_REGISTRY = new ConcurrentHashMap<String, FormField.Type>();
    private static final Map<String, FormField.Type> LOOKASIDE_FIELD_REGISTRY = new ConcurrentHashMap<String, FormField.Type>();
    private static int loadedFieldEntries;

    static int getLoadedFieldEntires() {
        return loadedFieldEntries;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void loadFormFieldRegistryEntry(InputStream inputStream, String source) throws XmlPullParserException, IOException {
        XmlPullParser parser = SmackXmlParser.newXmlParser((InputStream)inputStream);
        if (parser.nextTag() != XmlPullParser.TagEvent.START_ELEMENT) {
            throw new IllegalStateException();
        }
        String elementName = parser.getName();
        if (!elementName.equals("form_type")) {
            throw new IllegalStateException(source + " does not start with 'form_type' element but with " + elementName);
        }
        String formType = null;
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "name": {
                            formType = parser.nextText();
                            if (formType.isEmpty()) {
                                throw new IllegalStateException();
                            }
                            break block0;
                        }
                        case "field": {
                            String fieldName = parser.getAttributeValue("var");
                            String typeString = parser.getAttributeValue("type");
                            FormField.Type type = FormField.Type.fromString(typeString);
                            if (formType == null) {
                                throw new IllegalStateException();
                            }
                            FormFieldRegistry.register(formType, fieldName, type);
                            ++loadedFieldEntries;
                            LOGGER.finer("Registered " + fieldName + " for form " + formType + " with type " + String.valueOf((Object)type) + " [" + source + "]");
                            break;
                        }
                    }
                    break;
                }
                case END_DOCUMENT: {
                    return;
                }
            }
        }
    }

    private static void loadFormFieldRegistryEntries() throws IOException, IllegalStateException, XmlPullParserException, URISyntaxException {
        URL url = XDataManager.class.getProtectionDomain().getCodeSource().getLocation();
        if (url == null) {
            throw new IllegalStateException();
        }
        if (url.getProtocol().equals("file") && !url.getPath().endsWith(".jar")) {
            Path path = Paths.get(url.toURI());
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new IllegalStateException("Code source location " + String.valueOf(url) + " is not a directory");
            }
            String prefix = Paths.get(path.toString(), "org.igniterealtime.smack", "xdata", "form-registry").toString();
            try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
                List files = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(f -> f.toString().startsWith(prefix)).collect(Collectors.toList());
                for (Path file : files) {
                    InputStream inputStream = Files.newInputStream(file, new OpenOption[0]);
                    try {
                        FormFieldRegistry.loadFormFieldRegistryEntry(inputStream, file.toString());
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
            }
            return;
        }
        if (!url.toString().endsWith(".jar")) {
            throw new IllegalStateException("Code source location " + String.valueOf(url) + " is not a jar");
        }
        try (JarFile jar = new JarFile(url.getFile());){
            List files = jar.stream().filter(e -> !e.isDirectory()).filter(e -> e.getName().startsWith("org.igniterealtime.smack/xdata/form-registry/")).collect(Collectors.toList());
            for (JarEntry file : files) {
                InputStream inputStream = jar.getInputStream(file);
                try {
                    FormFieldRegistry.loadFormFieldRegistryEntry(inputStream, file.toString());
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
    }

    public static void register(DataForm dataForm) {
        if (dataForm.getType() != DataForm.Type.form) {
            throw new IllegalArgumentException();
        }
        String formType = null;
        TextSingleFormField hiddenFormTypeField = dataForm.getHiddenFormTypeField();
        if (hiddenFormTypeField != null) {
            formType = hiddenFormTypeField.getValue();
        }
        for (FormField formField : dataForm.getFields()) {
            FormField.Type type;
            if (formField == hiddenFormTypeField || (type = formField.getType()) == FormField.Type.fixed) continue;
            String fieldName = formField.getFieldName();
            FormFieldRegistry.register(formType, fieldName, type);
        }
    }

    public static void register(String formType, FormField.Type fieldType, String ... fieldNames) {
        for (String fieldName : fieldNames) {
            FormFieldRegistry.register(formType, fieldName, fieldType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String formType, String fieldName, FormField.Type fieldType) {
        FormField.Type previousType;
        StringUtils.requireNotNullNorEmpty((CharSequence)fieldName, (String)"fieldName must be provided");
        Objects.requireNonNull((Object)((Object)fieldType));
        if (formType == null) {
            if (XmlUtil.isClarkNotation((String)fieldName)) {
                CLARK_NOTATION_FIELD_REGISTRY.put(fieldName, fieldType);
            }
            return;
        }
        Map<String, Map<String, FormField.Type>> map = REGISTRY;
        synchronized (map) {
            Map<String, FormField.Type> fieldNameToType = REGISTRY.get(formType);
            if (fieldNameToType == null) {
                fieldNameToType = new HashMap<String, FormField.Type>();
                REGISTRY.put(formType, fieldNameToType);
            } else {
                previousType = fieldNameToType.get(fieldName);
                if (previousType != null && previousType != fieldType) {
                    String message = "The field '" + fieldName + "' from form type '" + formType + "' was already registered with field type '" + String.valueOf((Object)previousType) + "' while it is now seen with type '" + String.valueOf((Object)fieldType) + "'. Form field types have to be unambigiously. XMPP uses a registry for form field tpes, scoped by the form type. You may find the correct value at https://xmpp.org/registrar/formtypes.html";
                    throw new IllegalArgumentException(message);
                }
            }
            previousType = fieldNameToType.put(fieldName, fieldType);
        }
        if (previousType != null && fieldType != previousType) {
            LOGGER.warning("Form field registry inconsitency detected: Registered field '" + fieldName + "' of type " + String.valueOf((Object)fieldType) + " but previous type was " + String.valueOf((Object)previousType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormField.Type lookup(String formType, String fieldName) {
        if (formType == null) {
            if (XmlUtil.isClarkNotation((String)fieldName)) {
                return CLARK_NOTATION_FIELD_REGISTRY.get(fieldName);
            }
            return LOOKASIDE_FIELD_REGISTRY.get(fieldName);
        }
        Map<String, Map<String, FormField.Type>> map = REGISTRY;
        synchronized (map) {
            FormField.Type type;
            Map<String, FormField.Type> fieldNameToTypeMap = REGISTRY.get(formType);
            if (fieldNameToTypeMap != null && (type = fieldNameToTypeMap.get(fieldName)) != null) {
                return type;
            }
        }
        return null;
    }

    public static synchronized FormField.Type lookup(String fieldName) {
        return FormFieldRegistry.lookup(null, fieldName);
    }

    public static void addLookasideFieldRegistryEntry(String fieldName, FormField.Type formFieldType) {
        LOOKASIDE_FIELD_REGISTRY.put(fieldName, formFieldType);
    }

    static {
        try {
            FormFieldRegistry.loadFormFieldRegistryEntries();
        }
        catch (IOException | IllegalStateException | URISyntaxException | XmlPullParserException e) {
            LOGGER.log(Level.SEVERE, "Failed to load form field registry entries", e);
        }
    }
}

