/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.util.Date;
import java.util.function.Consumer;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.packet.MUCInitialPresence;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;

public final class MucEnterConfiguration {
    private final Resourcepart nickname;
    private final String password;
    private final int maxChars;
    private final int maxStanzas;
    private final int seconds;
    private final Date since;
    private final long timeout;
    private final Presence joinPresence;

    MucEnterConfiguration(Builder builder) {
        this.nickname = builder.nickname;
        this.password = builder.password;
        this.maxChars = builder.maxChars;
        this.maxStanzas = builder.maxStanzas;
        this.seconds = builder.seconds;
        this.since = builder.since;
        this.timeout = builder.timeout;
        PresenceBuilder joinPresenceBuilder = builder.joinPresenceBuilder.ofType(Presence.Type.available);
        joinPresenceBuilder.addExtension((XmlElement)new MUCInitialPresence(this.password, this.maxChars, this.maxStanzas, this.seconds, this.since));
        this.joinPresence = joinPresenceBuilder.build();
    }

    Presence getJoinPresence(MultiUserChat multiUserChat) {
        EntityFullJid jid = JidCreate.entityFullFrom((EntityBareJid)multiUserChat.getRoom(), (Resourcepart)this.nickname);
        this.joinPresence.setTo((Jid)jid);
        return this.joinPresence;
    }

    long getTimeout() {
        return this.timeout;
    }

    public static final class Builder {
        private final Resourcepart nickname;
        private String password;
        private int maxChars = -1;
        private int maxStanzas = -1;
        private int seconds = -1;
        private Date since;
        private long timeout;
        private final PresenceBuilder joinPresenceBuilder;

        Builder(Resourcepart nickname, XMPPConnection connection) {
            this.nickname = (Resourcepart)Objects.requireNonNull((Object)nickname, (String)"Nickname must not be null");
            this.timeout = connection.getReplyTimeout();
            this.timeoutAfter(this.timeout);
            this.joinPresenceBuilder = connection.getStanzaFactory().buildPresenceStanza();
        }

        public Builder withPresence(Consumer<? super PresenceBuilder> presenceBuilderConsumer) {
            presenceBuilderConsumer.accept((PresenceBuilder)this.joinPresenceBuilder);
            if (this.joinPresenceBuilder.getType() != Presence.Type.available) {
                throw new IllegalArgumentException("Presence must be of type 'available'");
            }
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder timeoutAfter(long timeout) {
            if (timeout <= 0L) {
                throw new IllegalArgumentException("timeout must be positive");
            }
            this.timeout = timeout;
            return this;
        }

        public Builder requestNoHistory() {
            this.maxChars = 0;
            this.maxStanzas = -1;
            this.seconds = -1;
            this.since = null;
            return this;
        }

        public Builder requestMaxCharsHistory(int maxChars) {
            this.maxChars = maxChars;
            return this;
        }

        public Builder requestMaxStanzasHistory(int maxStanzas) {
            this.maxStanzas = maxStanzas;
            return this;
        }

        public Builder requestHistorySince(int seconds) {
            this.seconds = seconds;
            return this;
        }

        public Builder requestHistorySince(Date since) {
            this.since = since;
            return this;
        }

        public MucEnterConfiguration build() {
            return new MucEnterConfiguration(this);
        }
    }
}

