/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.chat;

import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.chat.ChatManagerListener;
import org.jivesoftware.smack.chat.ChatMessageListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.test.util.WaitForPacketListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChatConnectionTest {
    private DummyConnection dc;
    private ChatManager cm;
    private TestChatManagerListener listener;
    private WaitForPacketListener waitListener;

    @Before
    public void setUp() throws Exception {
        ChatManager.setDefaultIsNormalIncluded((boolean)true);
        ChatManager.setDefaultMatchMode((ChatManager.MatchMode)ChatManager.MatchMode.BARE_JID);
        this.dc = DummyConnection.newConnectedDummyConnection();
        this.cm = ChatManager.getInstanceFor((XMPPConnection)this.dc);
        this.listener = new TestChatManagerListener();
        this.cm.addChatListener((ChatManagerListener)this.listener);
        this.waitListener = new WaitForPacketListener();
        this.dc.addSyncPacketListener((PacketListener)this.waitListener, null);
    }

    @After
    public void tearDown() throws Exception {
        if (this.dc != null) {
            this.dc.disconnect();
        }
    }

    @Test
    public void validateDefaultSetNormalIncludedFalse() {
        ChatManager.setDefaultIsNormalIncluded((boolean)false);
        Assert.assertFalse((boolean)ChatManager.getInstanceFor((XMPPConnection)new DummyConnection()).isNormalIncluded());
    }

    @Test
    public void validateDefaultSetNormalIncludedTrue() {
        ChatManager.setDefaultIsNormalIncluded((boolean)true);
        Assert.assertTrue((boolean)ChatManager.getInstanceFor((XMPPConnection)new DummyConnection()).isNormalIncluded());
    }

    @Test
    public void validateDefaultSetMatchModeNone() {
        ChatManager.setDefaultMatchMode((ChatManager.MatchMode)ChatManager.MatchMode.NONE);
        Assert.assertEquals((Object)ChatManager.MatchMode.NONE, (Object)ChatManager.getInstanceFor((XMPPConnection)new DummyConnection()).getMatchMode());
    }

    @Test
    public void validateDefaultSetMatchModeBareJid() {
        ChatManager.setDefaultMatchMode((ChatManager.MatchMode)ChatManager.MatchMode.BARE_JID);
        Assert.assertEquals((Object)ChatManager.MatchMode.BARE_JID, (Object)ChatManager.getInstanceFor((XMPPConnection)new DummyConnection()).getMatchMode());
    }

    @Test
    public void validateMessageTypeWithDefaults1() {
        Message incomingChat = this.createChatPacket("134", true);
        incomingChat.setType(Message.Type.chat);
        this.processServerMessage((Packet)incomingChat);
        Assert.assertNotNull((Object)this.listener.getNewChat());
    }

    @Test
    public void validateMessageTypeWithDefaults2() {
        Message incomingChat = this.createChatPacket("134", true);
        incomingChat.setType(Message.Type.normal);
        this.processServerMessage((Packet)incomingChat);
        Assert.assertNotNull((Object)this.listener.getNewChat());
    }

    @Test
    public void validateMessageTypeWithDefaults3() {
        Message incomingChat = this.createChatPacket("134", true);
        incomingChat.setType(Message.Type.groupchat);
        this.processServerMessage((Packet)incomingChat);
        Assert.assertNull((Object)this.listener.getNewChat());
    }

    @Test
    public void validateMessageTypeWithDefaults4() {
        Message incomingChat = this.createChatPacket("134", true);
        incomingChat.setType(Message.Type.headline);
        Assert.assertNull((Object)this.listener.getNewChat());
    }

    @Test
    public void validateMessageTypeWithNoNormal1() {
        this.cm.setNormalIncluded(false);
        Message incomingChat = this.createChatPacket("134", true);
        incomingChat.setType(Message.Type.chat);
        this.processServerMessage((Packet)incomingChat);
        Assert.assertNotNull((Object)this.listener.getNewChat());
    }

    @Test
    public void validateMessageTypeWithNoNormal2() {
        this.cm.setNormalIncluded(false);
        Message incomingChat = this.createChatPacket("134", true);
        incomingChat.setType(Message.Type.normal);
        this.processServerMessage((Packet)incomingChat);
        Assert.assertNull((Object)this.listener.getNewChat());
    }

    @Test
    public void chatMatchedOnJIDWhenNoThreadBareMode() {
        TestMessageListener msgListener = new TestMessageListener();
        TestChatManagerListener listener = new TestChatManagerListener(msgListener);
        this.cm.addChatListener((ChatManagerListener)listener);
        Message incomingChat = this.createChatPacket(null, true);
        this.processServerMessage((Packet)incomingChat);
        Chat newChat = listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        incomingChat = this.createChatPacket(null, true);
        this.processServerMessage((Packet)incomingChat);
        Assert.assertEquals((long)2L, (long)msgListener.getNumMessages());
        incomingChat = this.createChatPacket(null, false);
        this.processServerMessage((Packet)incomingChat);
        Assert.assertEquals((long)3L, (long)msgListener.getNumMessages());
    }

    @Test
    public void chatMatchedOnJIDWhenNoThreadJidMode() {
        TestMessageListener msgListener = new TestMessageListener();
        TestChatManagerListener listener = new TestChatManagerListener(msgListener);
        this.cm.setMatchMode(ChatManager.MatchMode.SUPPLIED_JID);
        this.cm.addChatListener((ChatManagerListener)listener);
        Message incomingChat = this.createChatPacket(null, true);
        this.processServerMessage((Packet)incomingChat);
        Chat newChat = listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        this.cm.removeChatListener((ChatManagerListener)listener);
        incomingChat = this.createChatPacket(null, true);
        this.processServerMessage((Packet)incomingChat);
        Assert.assertEquals((long)2L, (long)msgListener.getNumMessages());
        TestChatManagerListener listener2 = new TestChatManagerListener();
        this.cm.addChatListener((ChatManagerListener)listener2);
        incomingChat = this.createChatPacket(null, false);
        this.processServerMessage((Packet)incomingChat);
        Assert.assertEquals((long)2L, (long)msgListener.getNumMessages());
        Assert.assertNotNull((Object)listener2.getNewChat());
    }

    @Test
    public void chatMatchedOnJIDWhenNoThreadNoneMode() {
        TestMessageListener msgListener = new TestMessageListener();
        TestChatManagerListener listener = new TestChatManagerListener(msgListener);
        this.cm.setMatchMode(ChatManager.MatchMode.NONE);
        this.cm.addChatListener((ChatManagerListener)listener);
        Message incomingChat = this.createChatPacket(null, true);
        this.processServerMessage((Packet)incomingChat);
        Chat newChat = listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertEquals((long)1L, (long)msgListener.getNumMessages());
        this.cm.removeChatListener((ChatManagerListener)listener);
        TestChatManagerListener listener2 = new TestChatManagerListener();
        this.cm.addChatListener((ChatManagerListener)listener2);
        incomingChat = this.createChatPacket(null, true);
        this.processServerMessage((Packet)incomingChat);
        Assert.assertEquals((long)1L, (long)msgListener.getNumMessages());
        Assert.assertNotNull((Object)newChat);
        this.cm.removeChatListener((ChatManagerListener)listener2);
        TestChatManagerListener listener3 = new TestChatManagerListener();
        this.cm.addChatListener((ChatManagerListener)listener3);
        incomingChat = this.createChatPacket(null, false);
        this.processServerMessage((Packet)incomingChat);
        Assert.assertEquals((long)1L, (long)msgListener.getNumMessages());
        Assert.assertNotNull((Object)listener3.getNewChat());
    }

    @Test
    public void chatFoundWhenNoThreadFullJid() {
        Chat outgoing = this.cm.createChat("you@testserver", null);
        Message incomingChat = this.createChatPacket(null, true);
        this.processServerMessage((Packet)incomingChat);
        Chat newChat = this.listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertTrue((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatFoundWhenNoThreadBaseJid() {
        Chat outgoing = this.cm.createChat("you@testserver", null);
        Message incomingChat = this.createChatPacket(null, false);
        this.processServerMessage((Packet)incomingChat);
        Chat newChat = this.listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertTrue((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatFoundWithSameThreadFullJid() {
        Chat outgoing = this.cm.createChat("you@testserver", null);
        Message incomingChat = this.createChatPacket(outgoing.getThreadID(), true);
        this.processServerMessage((Packet)incomingChat);
        Chat newChat = this.listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertTrue((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatFoundWithSameThreadBaseJid() {
        Chat outgoing = this.cm.createChat("you@testserver", null);
        Message incomingChat = this.createChatPacket(outgoing.getThreadID(), false);
        this.processServerMessage((Packet)incomingChat);
        Chat newChat = this.listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertTrue((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatNotFoundWithDiffThreadBaseJid() {
        Chat outgoing = this.cm.createChat("you@testserver", null);
        Message incomingChat = this.createChatPacket(outgoing.getThreadID() + "ff", false);
        this.processServerMessage((Packet)incomingChat);
        Chat newChat = this.listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertFalse((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatNotFoundWithDiffThreadFullJid() {
        Chat outgoing = this.cm.createChat("you@testserver", null);
        Message incomingChat = this.createChatPacket(outgoing.getThreadID() + "ff", true);
        this.processServerMessage((Packet)incomingChat);
        Chat newChat = this.listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertFalse((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatNotMatchedWithTypeNormal() {
        this.cm.setNormalIncluded(false);
        Message incomingChat = this.createChatPacket(null, false);
        incomingChat.setType(Message.Type.normal);
        this.processServerMessage((Packet)incomingChat);
        Assert.assertNull((Object)this.listener.getNewChat());
    }

    private Message createChatPacket(String threadId, boolean isFullJid) {
        Message chatMsg = new Message("me@testserver", Message.Type.chat);
        chatMsg.setBody("the body message - " + System.currentTimeMillis());
        chatMsg.setFrom("you@testserver" + (isFullJid ? "/resource" : ""));
        chatMsg.setThread(threadId);
        return chatMsg;
    }

    private void processServerMessage(Packet incomingChat) {
        TestChatServer chatServer = new TestChatServer(incomingChat, this.dc);
        chatServer.start();
        try {
            chatServer.join();
        }
        catch (InterruptedException e) {
            Assert.fail();
        }
        this.waitListener.waitAndReset();
    }

    private class TestMessageListener
    implements ChatMessageListener {
        private Chat msgChat;
        private int counter = 0;

        private TestMessageListener() {
        }

        public void processMessage(Chat chat, Message message) {
            this.msgChat = chat;
            ++this.counter;
        }

        public Chat getChat() {
            return this.msgChat;
        }

        public int getNumMessages() {
            return this.counter;
        }
    }

    private class TestChatServer
    extends Thread {
        private Packet chatPacket;
        private DummyConnection con;

        TestChatServer(Packet chatMsg, DummyConnection conect) {
            this.chatPacket = chatMsg;
            this.con = conect;
        }

        @Override
        public void run() {
            this.con.processPacket(this.chatPacket);
        }
    }

    class TestChatManagerListener
    extends WaitForPacketListener
    implements ChatManagerListener {
        private Chat newChat;
        private ChatMessageListener listener;

        public TestChatManagerListener(TestMessageListener msgListener) {
            this.listener = msgListener;
        }

        public TestChatManagerListener() {
        }

        public void chatCreated(Chat chat, boolean createdLocally) {
            this.newChat = chat;
            if (this.listener != null) {
                this.newChat.addMessageListener(this.listener);
            }
            this.reportInvoked();
        }

        public Chat getNewChat() {
            return this.newChat;
        }
    }
}

