/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.chat;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManagerListener;
import org.jivesoftware.smack.chat.ChatMessageListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FlexiblePacketTypeFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.ThreadFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jxmpp.util.XmppStringUtils;

public class ChatManager
extends Manager {
    private static final Map<XMPPConnection, ChatManager> INSTANCES = new WeakHashMap<XMPPConnection, ChatManager>();
    private static boolean defaultIsNormalInclude = true;
    private static MatchMode defaultMatchMode = MatchMode.BARE_JID;
    private final PacketFilter packetFilter = new OrFilter(new PacketFilter[]{MessageTypeFilter.CHAT, new FlexiblePacketTypeFilter<Message>(){

        protected boolean acceptSpecific(Message message) {
            return ChatManager.this.normalIncluded ? message.getType() == Message.Type.normal : false;
        }
    }});
    private boolean normalIncluded = defaultIsNormalInclude;
    private MatchMode matchMode = defaultMatchMode;
    private Map<String, Chat> threadChats = new ConcurrentHashMap<String, Chat>();
    private Map<String, Chat> jidChats = new ConcurrentHashMap<String, Chat>();
    private Map<String, Chat> baseJidChats = new ConcurrentHashMap<String, Chat>();
    private Set<ChatManagerListener> chatManagerListeners = new CopyOnWriteArraySet<ChatManagerListener>();
    private Map<MessageListener, PacketFilter> interceptors = new WeakHashMap<MessageListener, PacketFilter>();

    public static synchronized ChatManager getInstanceFor(XMPPConnection connection) {
        ChatManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new ChatManager(connection);
        }
        return manager;
    }

    private ChatManager(XMPPConnection connection) {
        super(connection);
        connection.addSyncPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                Chat chat = message.getThread() == null ? ChatManager.this.getUserChat(message.getFrom()) : ChatManager.this.getThreadChat(message.getThread());
                if (chat == null) {
                    chat = ChatManager.this.createChat(message);
                }
                if (chat == null) {
                    return;
                }
                ChatManager.this.deliverMessage(chat, message);
            }
        }, this.packetFilter);
        INSTANCES.put(connection, this);
    }

    public boolean isNormalIncluded() {
        return this.normalIncluded;
    }

    public void setNormalIncluded(boolean normalIncluded) {
        this.normalIncluded = normalIncluded;
    }

    public MatchMode getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(MatchMode matchMode) {
        this.matchMode = matchMode;
    }

    public Chat createChat(String userJID) {
        return this.createChat(userJID, null);
    }

    public Chat createChat(String userJID, ChatMessageListener listener) {
        return this.createChat(userJID, null, listener);
    }

    public Chat createChat(String userJID, String thread, ChatMessageListener listener) {
        Chat chat;
        if (thread == null) {
            thread = ChatManager.nextID();
        }
        if ((chat = this.threadChats.get(thread)) != null) {
            throw new IllegalArgumentException("ThreadID is already used");
        }
        chat = this.createChat(userJID, thread, true);
        chat.addMessageListener(listener);
        return chat;
    }

    private Chat createChat(String userJID, String threadID, boolean createdLocally) {
        Chat chat = new Chat(this, userJID, threadID);
        this.threadChats.put(threadID, chat);
        this.jidChats.put(userJID, chat);
        this.baseJidChats.put(XmppStringUtils.parseBareJid((String)userJID), chat);
        for (ChatManagerListener listener : this.chatManagerListeners) {
            listener.chatCreated(chat, createdLocally);
        }
        return chat;
    }

    void closeChat(Chat chat) {
        this.threadChats.remove(chat.getThreadID());
        String userJID = chat.getParticipant();
        this.jidChats.remove(userJID);
        this.baseJidChats.remove(XmppStringUtils.parseBareJid((String)userJID));
    }

    private Chat createChat(Message message) {
        String userJID = message.getFrom();
        if (userJID == null) {
            return null;
        }
        String threadID = message.getThread();
        if (threadID == null) {
            threadID = ChatManager.nextID();
        }
        return this.createChat(userJID, threadID, false);
    }

    private Chat getUserChat(String userJID) {
        if (this.matchMode == MatchMode.NONE) {
            return null;
        }
        if (userJID == null) {
            return null;
        }
        Chat match = this.jidChats.get(userJID);
        if (match == null && this.matchMode == MatchMode.BARE_JID) {
            match = this.baseJidChats.get(XmppStringUtils.parseBareJid((String)userJID));
        }
        return match;
    }

    public Chat getThreadChat(String thread) {
        return this.threadChats.get(thread);
    }

    public void addChatListener(ChatManagerListener listener) {
        this.chatManagerListeners.add(listener);
    }

    public void removeChatListener(ChatManagerListener listener) {
        this.chatManagerListeners.remove(listener);
    }

    public Set<ChatManagerListener> getChatListeners() {
        return Collections.unmodifiableSet(this.chatManagerListeners);
    }

    private void deliverMessage(Chat chat, Message message) {
        chat.deliver(message);
    }

    void sendMessage(Chat chat, Message message) throws SmackException.NotConnectedException {
        for (Map.Entry<MessageListener, PacketFilter> interceptor : this.interceptors.entrySet()) {
            PacketFilter filter = interceptor.getValue();
            if (filter == null || !filter.accept((Packet)message)) continue;
            interceptor.getKey().processMessage(message);
        }
        if (message.getFrom() == null) {
            message.setFrom(this.connection().getUser());
        }
        this.connection().sendPacket((Packet)message);
    }

    PacketCollector createPacketCollector(Chat chat) {
        return this.connection().createPacketCollector((PacketFilter)new AndFilter(new PacketFilter[]{new ThreadFilter(chat.getThreadID()), FromMatchesFilter.create((String)chat.getParticipant())}));
    }

    public void addOutgoingMessageInterceptor(MessageListener messageInterceptor) {
        this.addOutgoingMessageInterceptor(messageInterceptor, null);
    }

    public void addOutgoingMessageInterceptor(MessageListener messageInterceptor, PacketFilter filter) {
        if (messageInterceptor == null) {
            return;
        }
        this.interceptors.put(messageInterceptor, filter);
    }

    private static String nextID() {
        return UUID.randomUUID().toString();
    }

    public static void setDefaultMatchMode(MatchMode mode) {
        defaultMatchMode = mode;
    }

    public static void setDefaultIsNormalIncluded(boolean allowNormal) {
        defaultIsNormalInclude = allowNormal;
    }

    public static enum MatchMode {
        NONE,
        SUPPLIED_JID,
        BARE_JID;

    }
}

