/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster.rosterstore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.roster.rosterstore.DirectoryRosterStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class DirectoryRosterStoreTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testStoreUninitialized() throws IOException {
        File storeDir = this.tmpFolder.newFolder();
        Assert.assertNull((Object)DirectoryRosterStore.open((File)storeDir));
    }

    @Test
    public void testStoreInitializedEmpty() throws IOException {
        File storeDir = this.tmpFolder.newFolder();
        DirectoryRosterStore store = DirectoryRosterStore.init((File)storeDir);
        Assert.assertNotNull((String)"Initialization returns store", (Object)store);
        Assert.assertEquals((String)"Freshly initialized store must have empty version", (Object)"", (Object)store.getRosterVersion());
        Assert.assertEquals((String)"Freshly initialized store must have no entries", (long)0L, (long)store.getEntries().size());
    }

    @Test
    public void testStoreAddRemove() throws IOException {
        File storeDir = this.tmpFolder.newFolder();
        DirectoryRosterStore store = DirectoryRosterStore.init((File)storeDir);
        Assert.assertEquals((String)"Initial roster version", (Object)"", (Object)store.getRosterVersion());
        String userName = "user@example.com";
        RosterPacket.Item item1 = new RosterPacket.Item(userName, null);
        String version1 = "1";
        store.addEntry(item1, "1");
        Assert.assertEquals((String)"Adding entry sets version correctly", (Object)"1", (Object)store.getRosterVersion());
        RosterPacket.Item storedItem = store.getEntry(userName);
        Assert.assertNotNull((String)"Added entry not found found", (Object)storedItem);
        Assert.assertEquals((String)"User of added entry", (Object)item1.getUser(), (Object)storedItem.getUser());
        Assert.assertEquals((String)"Name of added entry", (Object)item1.getName(), (Object)storedItem.getName());
        Assert.assertEquals((String)"Groups", (Object)item1.getGroupNames(), (Object)storedItem.getGroupNames());
        Assert.assertEquals((String)"ItemType of added entry", (Object)item1.getItemType(), (Object)storedItem.getItemType());
        Assert.assertEquals((String)"ItemStatus of added entry", (Object)item1.getItemStatus(), (Object)storedItem.getItemStatus());
        String version2 = "2";
        RosterPacket.Item item2 = new RosterPacket.Item(userName, "Ursula Example");
        item2.addGroupName("users");
        item2.addGroupName("examples");
        item2.setItemStatus(RosterPacket.ItemStatus.subscribe);
        item2.setItemType(RosterPacket.ItemType.none);
        store.addEntry(item2, "2");
        Assert.assertEquals((String)"Updating entry sets version correctly", (Object)"2", (Object)store.getRosterVersion());
        storedItem = store.getEntry(userName);
        Assert.assertNotNull((String)"Added entry not found", (Object)storedItem);
        Assert.assertEquals((String)"User of added entry", (Object)item2.getUser(), (Object)storedItem.getUser());
        Assert.assertEquals((String)"Name of added entry", (Object)item2.getName(), (Object)storedItem.getName());
        Assert.assertEquals((String)"Groups", (Object)item2.getGroupNames(), (Object)storedItem.getGroupNames());
        Assert.assertEquals((String)"ItemType of added entry", (Object)item2.getItemType(), (Object)storedItem.getItemType());
        Assert.assertEquals((String)"ItemStatus of added entry", (Object)item2.getItemStatus(), (Object)storedItem.getItemStatus());
        List entries = store.getEntries();
        Assert.assertEquals((String)"Number of entries", (long)1L, (long)entries.size());
        RosterPacket.Item item3 = new RosterPacket.Item("foobar@example.com", "Foo Bar");
        item3.addGroupName("The Foo Fighters");
        item3.addGroupName("Bar Friends");
        item3.setItemStatus(RosterPacket.ItemStatus.unsubscribe);
        item3.setItemType(RosterPacket.ItemType.both);
        RosterPacket.Item item4 = new RosterPacket.Item("baz@example.com", "Baba Baz");
        item4.addGroupName("The Foo Fighters");
        item4.addGroupName("Bar Friends");
        item4.setItemStatus(RosterPacket.ItemStatus.subscribe);
        item4.setItemType(RosterPacket.ItemType.both);
        ArrayList<RosterPacket.Item> items34 = new ArrayList<RosterPacket.Item>();
        items34.add(item3);
        items34.add(item4);
        String version3 = "3";
        store.resetEntries(items34, version3);
        storedItem = store.getEntry("foobar@example.com");
        Assert.assertNotNull((String)"Added entry not found", (Object)storedItem);
        Assert.assertEquals((String)"User of added entry", (Object)item3.getUser(), (Object)storedItem.getUser());
        Assert.assertEquals((String)"Name of added entry", (Object)item3.getName(), (Object)storedItem.getName());
        Assert.assertEquals((String)"Groups", (Object)item3.getGroupNames(), (Object)storedItem.getGroupNames());
        Assert.assertEquals((String)"ItemType of added entry", (Object)item3.getItemType(), (Object)storedItem.getItemType());
        Assert.assertEquals((String)"ItemStatus of added entry", (Object)item3.getItemStatus(), (Object)storedItem.getItemStatus());
        storedItem = store.getEntry("baz@example.com");
        Assert.assertNotNull((String)"Added entry not found", (Object)storedItem);
        Assert.assertEquals((String)"User of added entry", (Object)item4.getUser(), (Object)storedItem.getUser());
        Assert.assertEquals((String)"Name of added entry", (Object)item4.getName(), (Object)storedItem.getName());
        Assert.assertEquals((String)"Groups", (Object)item4.getGroupNames(), (Object)storedItem.getGroupNames());
        Assert.assertEquals((String)"ItemType of added entry", (Object)item4.getItemType(), (Object)storedItem.getItemType());
        Assert.assertEquals((String)"ItemStatus of added entry", (Object)item4.getItemStatus(), (Object)storedItem.getItemStatus());
        entries = store.getEntries();
        Assert.assertEquals((String)"Number of entries", (long)2L, (long)entries.size());
        String version4 = "4";
        store.removeEntry("baz@example.com", version4);
        Assert.assertEquals((String)"Removing entry sets version correctly", (Object)version4, (Object)store.getRosterVersion());
        Assert.assertNull((String)"Removed entry is gone", (Object)store.getEntry(userName));
        entries = store.getEntries();
        Assert.assertEquals((String)"Number of entries", (long)1L, (long)entries.size());
    }

    @Test
    public void testAddEvilChars() throws IOException {
        File storeDir = this.tmpFolder.newFolder();
        DirectoryRosterStore store = DirectoryRosterStore.init((File)storeDir);
        String user = "../_#;\"'\\&@example.com";
        String name = "\n../_#\u0000\t;\"'&@\\";
        String group1 = "\t;\"'&@\\\n../_#\u0000";
        String group2 = "#\u0000\t;\"'&@\\\n../_";
        RosterPacket.Item item = new RosterPacket.Item(user, name);
        item.setItemStatus(RosterPacket.ItemStatus.unsubscribe);
        item.setItemType(RosterPacket.ItemType.to);
        item.addGroupName(group1);
        item.addGroupName(group2);
        store.addEntry(item, "a-version");
        RosterPacket.Item storedItem = store.getEntry(user);
        Assert.assertNotNull((String)"Added entry not found", (Object)storedItem);
        Assert.assertEquals((String)"User of added entry", (Object)item.getUser(), (Object)storedItem.getUser());
        Assert.assertEquals((String)"Name of added entry", (Object)item.getName(), (Object)storedItem.getName());
        Assert.assertEquals((String)"Groups", (Object)item.getGroupNames(), (Object)storedItem.getGroupNames());
        Assert.assertEquals((String)"ItemType of added entry", (Object)item.getItemType(), (Object)storedItem.getItemType());
        Assert.assertEquals((String)"ItemStatus of added entry", (Object)item.getItemStatus(), (Object)storedItem.getItemStatus());
    }
}

