/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.RosterGroup;
import org.jivesoftware.smack.roster.RosterListener;
import org.jivesoftware.smack.roster.RosterTest;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.roster.rosterstore.DirectoryRosterStore;
import org.jivesoftware.smack.roster.rosterstore.RosterStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class RosterVersioningTest {
    private DummyConnection connection;
    private Roster roster;
    private RosterTest.TestRosterListener rosterListener;
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        DirectoryRosterStore store = DirectoryRosterStore.init((File)this.tmpFolder.newFolder("store"));
        this.populateStore((RosterStore)store);
        ConnectionConfiguration.Builder builder = DummyConnection.getDummyConfigurationBuilder();
        this.connection = new DummyConnection(builder.build());
        this.connection.connect();
        this.connection.login();
        this.rosterListener = new RosterTest.TestRosterListener();
        this.roster = Roster.getInstanceFor((XMPPConnection)this.connection);
        this.roster.setRosterStore((RosterStore)store);
        this.roster.addRosterListener((RosterListener)this.rosterListener);
        this.roster.reload();
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            if (this.rosterListener != null && this.roster != null) {
                this.roster.removeRosterListener((RosterListener)this.rosterListener);
                this.rosterListener = null;
            }
            this.connection.disconnect();
            this.connection = null;
        }
    }

    @Test(timeout=5000L)
    public void testEqualVersionStored() throws InterruptedException, IOException, XMPPException, SmackException {
        this.answerWithEmptyRosterResult();
        this.roster.waitUntilLoaded();
        Set entries = this.roster.getEntries();
        Assert.assertSame((String)"Size of the roster", (Object)3, (Object)entries.size());
        HashSet<RosterPacket.Item> items = new HashSet<RosterPacket.Item>();
        for (Object entry : entries) {
            items.add(RosterEntry.toRosterItem((RosterEntry)entry));
        }
        DirectoryRosterStore store = DirectoryRosterStore.init((File)this.tmpFolder.newFolder());
        this.populateStore((RosterStore)store);
        Assert.assertEquals((String)"Elements of the roster", new HashSet(store.getEntries()), items);
        for (RosterEntry entry : entries) {
            Assert.assertTrue(("joe stevens".equals(entry.getName()) || "geoff hurley".equals(entry.getName()) || "higgins mcmann".equals(entry.getName()) ? 1 : 0) != 0);
        }
        Collection groups = this.roster.getGroups();
        Assert.assertSame((Object)3, (Object)groups.size());
        for (RosterGroup group : groups) {
            Assert.assertTrue(("all".equals(group.getName()) || "friends".equals(group.getName()) || "partners".equals(group.getName()) ? 1 : 0) != 0);
        }
    }

    @Test(timeout=5000L)
    public void testOtherVersionStored() throws InterruptedException, XMPPException, SmackException {
        RosterPacket.Item vaglafItem = this.vaglafItem();
        Stanza sentPacket = (Stanza)this.connection.getSentPacket();
        if (sentPacket instanceof RosterPacket) {
            RosterPacket sentRP = (RosterPacket)sentPacket;
            RosterPacket answer = new RosterPacket();
            answer.setStanzaId(sentRP.getStanzaId());
            answer.setType(IQ.Type.result);
            answer.setTo(sentRP.getFrom());
            answer.setVersion("newVersion");
            answer.addRosterItem(vaglafItem);
            this.rosterListener.reset();
            this.connection.processPacket((Stanza)answer);
            this.rosterListener.waitUntilInvocationOrTimeout();
        } else {
            Assert.assertTrue((String)"Expected to get a RosterPacket ", (boolean)false);
        }
        Roster roster = Roster.getInstanceFor((XMPPConnection)this.connection);
        Assert.assertEquals((String)"Size of roster", (long)1L, (long)roster.getEntries().size());
        RosterEntry entry = roster.getEntry(vaglafItem.getUser());
        Assert.assertNotNull((String)"Roster contains vaglaf entry", (Object)entry);
        Assert.assertEquals((String)"vaglaf entry in roster equals the sent entry", (Object)vaglafItem, (Object)RosterEntry.toRosterItem((RosterEntry)entry));
        RosterStore store = roster.getRosterStore();
        Assert.assertEquals((String)"Size of store", (long)1L, (long)store.getEntries().size());
        RosterPacket.Item item = store.getEntry(vaglafItem.getUser());
        Assert.assertNotNull((Object)"Store contains vaglaf entry");
        Assert.assertEquals((String)"vaglaf entry in store equals the sent entry", (Object)vaglafItem, (Object)item);
    }

    @Test(timeout=5000L)
    public void testRosterVersioningWithCachedRosterAndPushes() throws Throwable {
        this.answerWithEmptyRosterResult();
        this.rosterListener.waitAndReset();
        RosterStore store = this.roster.getRosterStore();
        RosterPacket rosterPush = new RosterPacket();
        rosterPush.setTo("rostertest@example.com/home");
        rosterPush.setType(IQ.Type.set);
        rosterPush.setVersion("v97");
        RosterPacket.Item pushedItem = this.vaglafItem();
        rosterPush.addRosterItem(pushedItem);
        this.rosterListener.reset();
        this.connection.processPacket((Stanza)rosterPush);
        this.rosterListener.waitAndReset();
        Assert.assertEquals((String)"Expect store version after push", (Object)"v97", (Object)store.getRosterVersion());
        RosterPacket.Item storedItem = store.getEntry("vaglaf@example.com");
        Assert.assertNotNull((String)"Expect vaglaf to be added", (Object)storedItem);
        Assert.assertEquals((String)"Expect vaglaf to be equal to pushed item", (Object)pushedItem, (Object)storedItem);
        HashSet<RosterPacket.Item> rosterItems = new HashSet<RosterPacket.Item>();
        for (RosterEntry entry : this.roster.getEntries()) {
            rosterItems.add(RosterEntry.toRosterItem((RosterEntry)entry));
        }
        Assert.assertEquals(rosterItems, new HashSet(store.getEntries()));
        rosterPush = new RosterPacket();
        rosterPush.setTo("rostertest@example.com/home");
        rosterPush.setType(IQ.Type.set);
        rosterPush.setVersion("v98");
        RosterPacket.Item item = new RosterPacket.Item("vaglaf@example.com", "vaglaf the only");
        item.setItemType(RosterPacket.ItemType.remove);
        rosterPush.addRosterItem(item);
        this.rosterListener.reset();
        this.connection.processPacket((Stanza)rosterPush);
        this.rosterListener.waitAndReset();
        Assert.assertNull((String)"Store doses not contain vaglaf", (Object)store.getEntry("vaglaf@example.com"));
        Assert.assertEquals((String)"Expect store version after push", (Object)"v98", (Object)store.getRosterVersion());
    }

    private RosterPacket.Item vaglafItem() {
        RosterPacket.Item item = new RosterPacket.Item("vaglaf@example.com", "vaglaf the only");
        item.setItemType(RosterPacket.ItemType.both);
        item.addGroupName("all");
        item.addGroupName("friends");
        item.addGroupName("partners");
        return item;
    }

    private void populateStore(RosterStore store) throws IOException {
        store.addEntry(new RosterPacket.Item("geoff@example.com", "geoff hurley"), "");
        RosterPacket.Item item = new RosterPacket.Item("joe@example.com", "joe stevens");
        item.addGroupName("friends");
        item.addGroupName("partners");
        store.addEntry(item, "");
        item = new RosterPacket.Item("higgins@example.com", "higgins mcmann");
        item.addGroupName("all");
        item.addGroupName("friends");
        store.addEntry(item, "v96");
    }

    private void answerWithEmptyRosterResult() throws InterruptedException {
        Stanza sentPacket = (Stanza)this.connection.getSentPacket();
        if (sentPacket instanceof RosterPacket) {
            IQ emptyIQ = IQ.createResultIQ((IQ)((RosterPacket)sentPacket));
            this.connection.processPacket((Stanza)emptyIQ);
        } else {
            Assert.assertTrue((String)"Expected to get a RosterPacket ", (boolean)false);
        }
    }
}

