/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterGroup;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jxmpp.jid.BareJid;

public final class RosterEntry
extends Manager {
    private final BareJid jid;
    private String name;
    private RosterPacket.ItemType type;
    private RosterPacket.ItemStatus status;
    private final boolean approved;
    private final Roster roster;

    RosterEntry(BareJid user, String name, RosterPacket.ItemType type, RosterPacket.ItemStatus status, boolean approved, Roster roster, XMPPConnection connection) {
        super(connection);
        this.jid = user;
        this.name = name;
        this.type = type;
        this.status = status;
        this.approved = approved;
        this.roster = roster;
    }

    @Deprecated
    public String getUser() {
        return this.jid.toString();
    }

    public BareJid getJid() {
        return this.jid;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String name) throws SmackException.NotConnectedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException {
        if (name != null && name.equals(this.name)) {
            return;
        }
        RosterPacket packet = new RosterPacket();
        packet.setType(IQ.Type.set);
        packet.addRosterItem(RosterEntry.toRosterItem(this, name));
        this.connection().createPacketCollectorAndSend((IQ)packet).nextResultOrThrow();
        this.name = name;
    }

    void updateState(String name, RosterPacket.ItemType type, RosterPacket.ItemStatus status) {
        this.name = name;
        this.type = type;
        this.status = status;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public List<RosterGroup> getGroups() {
        ArrayList<RosterGroup> results = new ArrayList<RosterGroup>();
        for (RosterGroup group : this.roster.getGroups()) {
            if (!group.contains(this)) continue;
            results.add(group);
        }
        return results;
    }

    public RosterPacket.ItemType getType() {
        return this.type;
    }

    public RosterPacket.ItemStatus getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.name != null) {
            buf.append(this.name).append(": ");
        }
        buf.append((CharSequence)this.jid);
        List<RosterGroup> groups = this.getGroups();
        if (!groups.isEmpty()) {
            buf.append(" [");
            Iterator iter = groups.iterator();
            RosterGroup group = (RosterGroup)((Object)iter.next());
            buf.append(group.getName());
            while (iter.hasNext()) {
                buf.append(", ");
                group = (RosterGroup)((Object)iter.next());
                buf.append(group.getName());
            }
            buf.append(']');
        }
        return buf.toString();
    }

    public int hashCode() {
        return this.jid == null ? 0 : this.jid.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof RosterEntry) {
            return this.jid.equals(((RosterEntry)((Object)object)).getUser());
        }
        return false;
    }

    public boolean equalsDeep(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RosterEntry other = (RosterEntry)((Object)obj);
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals((Object)other.type)) {
            return false;
        }
        if (this.jid == null ? other.jid != null : !this.jid.equals((CharSequence)other.jid)) {
            return false;
        }
        return this.approved == other.approved;
    }

    static RosterPacket.Item toRosterItem(RosterEntry entry) {
        return RosterEntry.toRosterItem(entry, entry.getName());
    }

    private static RosterPacket.Item toRosterItem(RosterEntry entry, String name) {
        RosterPacket.Item item = new RosterPacket.Item(entry.getJid(), name);
        item.setItemType(entry.getType());
        item.setItemStatus(entry.getStatus());
        item.setApproved(entry.isApproved());
        for (RosterGroup group : entry.getGroups()) {
            item.addGroupName(group.getName());
        }
        return item;
    }
}

