/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jxmpp.jid.Jid;

public class RosterGroup
extends Manager {
    private final String name;
    private final Set<RosterEntry> entries;

    RosterGroup(String name, XMPPConnection connection) {
        super(connection);
        this.name = name;
        this.entries = new LinkedHashSet<RosterEntry>();
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) throws SmackException.NotConnectedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            for (RosterEntry entry : this.entries) {
                RosterPacket packet = new RosterPacket();
                packet.setType(IQ.Type.set);
                RosterPacket.Item item = RosterEntry.toRosterItem(entry);
                item.removeGroupName(this.name);
                item.addGroupName(name);
                packet.addRosterItem(item);
                this.connection().createPacketCollectorAndSend((IQ)packet).nextResultOrThrow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntryCount() {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            return this.entries.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RosterEntry> getEntries() {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            return new ArrayList<RosterEntry>(this.entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RosterEntry getEntry(Jid user) {
        if (user == null) {
            return null;
        }
        user = user.asBareJid();
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            for (RosterEntry entry : this.entries) {
                if (!entry.getJid().equals((CharSequence)user)) continue;
                return entry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(RosterEntry entry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            return this.entries.contains((Object)entry);
        }
    }

    public boolean contains(Jid user) {
        return this.getEntry(user) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(RosterEntry entry) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            if (!this.entries.contains((Object)entry)) {
                RosterPacket packet = new RosterPacket();
                packet.setType(IQ.Type.set);
                RosterPacket.Item item = RosterEntry.toRosterItem(entry);
                item.addGroupName(this.getName());
                packet.addRosterItem(item);
                this.connection().createPacketCollectorAndSend((IQ)packet).nextResultOrThrow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(RosterEntry entry) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            if (this.entries.contains((Object)entry)) {
                RosterPacket packet = new RosterPacket();
                packet.setType(IQ.Type.set);
                RosterPacket.Item item = RosterEntry.toRosterItem(entry);
                item.removeGroupName(this.getName());
                packet.addRosterItem(item);
                this.connection().createPacketCollectorAndSend((IQ)packet).nextResultOrThrow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEntryLocal(RosterEntry entry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            this.entries.remove((Object)entry);
            this.entries.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntryLocal(RosterEntry entry) {
        Set<RosterEntry> set = this.entries;
        synchronized (set) {
            if (this.entries.contains((Object)entry)) {
                this.entries.remove((Object)entry);
            }
        }
    }
}

