/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jxmpp.jid.BareJid;

public class RosterPacket
extends IQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "jabber:iq:roster";
    private final List<Item> rosterItems = new ArrayList<Item>();
    private String rosterVersion;

    public RosterPacket() {
        super(ELEMENT, NAMESPACE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRosterItem(Item item) {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            this.rosterItems.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRosterItemCount() {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            return this.rosterItems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Item> getRosterItems() {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            return new ArrayList<Item>(this.rosterItems);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.optAttribute("ver", this.rosterVersion);
        buf.rightAngleBracket();
        List<Item> list = this.rosterItems;
        synchronized (list) {
            for (Item entry : this.rosterItems) {
                buf.append(entry.toXML());
            }
        }
        return buf;
    }

    public String getVersion() {
        return this.rosterVersion;
    }

    public void setVersion(String version) {
        this.rosterVersion = version;
    }

    public static enum ItemType {
        none,
        to,
        from,
        both,
        remove;

    }

    public static enum ItemStatus {
        subscribe,
        unsubscribe;

        public static final ItemStatus SUBSCRIPTION_PENDING;
        public static final ItemStatus UNSUBSCRIPTION_PENDING;

        public static ItemStatus fromString(String s) {
            if (s == null) {
                return null;
            }
            try {
                return ItemStatus.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        static {
            SUBSCRIPTION_PENDING = subscribe;
            UNSUBSCRIPTION_PENDING = unsubscribe;
        }
    }

    public static class Item {
        public static final String GROUP = "group";
        private final BareJid jid;
        private String name;
        private ItemType itemType;
        private ItemStatus itemStatus;
        private boolean approved;
        private final Set<String> groupNames;

        public Item(BareJid jid, String name) {
            this.jid = (BareJid)Objects.requireNonNull((Object)jid);
            this.name = name;
            this.itemType = null;
            this.itemStatus = null;
            this.groupNames = new CopyOnWriteArraySet<String>();
        }

        @Deprecated
        public String getUser() {
            return this.jid.toString();
        }

        public BareJid getJid() {
            return this.jid;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ItemType getItemType() {
            return this.itemType;
        }

        public void setItemType(ItemType itemType) {
            this.itemType = itemType;
        }

        public ItemStatus getItemStatus() {
            return this.itemStatus;
        }

        public void setItemStatus(ItemStatus itemStatus) {
            this.itemStatus = itemStatus;
        }

        public boolean isApproved() {
            return this.approved;
        }

        public void setApproved(boolean approved) {
            this.approved = approved;
        }

        public Set<String> getGroupNames() {
            return Collections.unmodifiableSet(this.groupNames);
        }

        public void addGroupName(String groupName) {
            this.groupNames.add(groupName);
        }

        public void removeGroupName(String groupName) {
            this.groupNames.remove(groupName);
        }

        public XmlStringBuilder toXML() {
            XmlStringBuilder xml = new XmlStringBuilder();
            xml.halfOpenElement("item").attribute("jid", (CharSequence)this.jid);
            xml.optAttribute("name", this.name);
            xml.optAttribute("subscription", (Enum)this.itemType);
            xml.optAttribute("ask", (Enum)this.itemStatus);
            xml.optBooleanAttribute("approved", this.approved);
            xml.rightAngleBracket();
            for (String groupName : this.groupNames) {
                xml.openElement(GROUP).escape(groupName).closeElement(GROUP);
            }
            xml.closeElement("item");
            return xml;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.groupNames == null ? 0 : this.groupNames.hashCode());
            result = 31 * result + (this.itemStatus == null ? 0 : this.itemStatus.hashCode());
            result = 31 * result + (this.itemType == null ? 0 : this.itemType.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.jid == null ? 0 : this.jid.hashCode());
            result = 31 * result + (!this.approved ? 0 : 1);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Item other = (Item)obj;
            if (this.groupNames == null ? other.groupNames != null : !this.groupNames.equals(other.groupNames)) {
                return false;
            }
            if (this.itemStatus != other.itemStatus) {
                return false;
            }
            if (this.itemType != other.itemType) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.jid == null ? other.jid != null : !this.jid.equals((CharSequence)other.jid)) {
                return false;
            }
            return this.approved == other.approved;
        }
    }
}

