/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.im.InitSmackIm;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.RosterListener;
import org.jivesoftware.smack.roster.RosterTest;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.roster.packet.SubscriptionPreApproval;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

public class SubscriptionPreApprovalTest
extends InitSmackIm {
    private DummyConnection connection;
    private Roster roster;
    private RosterTest.TestRosterListener rosterListener;

    @Before
    public void setUp() throws Exception {
        this.connection = new DummyConnection();
        this.connection.connect();
        this.connection.login();
        this.rosterListener = new RosterTest.TestRosterListener();
        this.roster = Roster.getInstanceFor((XMPPConnection)this.connection);
        this.roster.addRosterListener((RosterListener)this.rosterListener);
        this.connection.setPacketReplyTimeout(300000L);
    }

    @After
    public void tearDown() throws Exception {
        this.connection.disconnect();
        this.connection = null;
    }

    @Test(expected=SmackException.FeatureNotSupportedException.class)
    public void testPreApprovalNotSupported() throws Throwable {
        Jid contactJID = JidCreate.from((String)"preapproval@example.com");
        this.roster.preApprove(contactJID.asBareJid());
    }

    @Test
    public void testPreApproveAndCreate() throws Throwable {
        final BareJid contactJID = JidCreate.bareFrom((String)"preapproval@example.com");
        String contactName = "PreApproval";
        String[] contactGroup = new String[]{};
        this.connection.enableStreamFeature((ExtensionElement)SubscriptionPreApproval.INSTANCE);
        PreApproveAndCreateEntryResponder serverSimulator = new PreApproveAndCreateEntryResponder(){

            @Override
            void verifyRosterUpdateRequest(RosterPacket updateRequest) {
                RosterPacket.Item item = (RosterPacket.Item)updateRequest.getRosterItems().iterator().next();
                Assert.assertSame((String)"The provided JID doesn't match the requested!", (Object)contactJID, (Object)item.getJid());
                Assert.assertSame((String)"The provided name doesn't match the requested!", (Object)"PreApproval", (Object)item.getName());
                Assert.assertSame((String)"The provided group number doesn't match the requested!", (Object)0, (Object)item.getGroupNames().size());
            }

            @Override
            void verifyPreApprovalRequest(Presence preApproval) {
                Assert.assertSame((String)"The provided name doesn't match the requested!", (Object)contactJID, (Object)preApproval.getTo());
                Assert.assertSame((String)"The provided presence type is incorrect!", (Object)Presence.Type.subscribed, (Object)preApproval.getType());
            }
        };
        serverSimulator.start();
        this.roster.preApproveAndCreateEntry(contactJID, "PreApproval", contactGroup);
        serverSimulator.join();
        Throwable exception = serverSimulator.getException();
        if (exception != null) {
            throw exception;
        }
        this.rosterListener.waitUntilInvocationOrTimeout();
        RosterEntry addedEntry = this.roster.getEntry(contactJID);
        Assert.assertNotNull((String)"The new contact wasn't added to the roster!", (Object)addedEntry);
        Assert.assertTrue((String)"The roster listener wasn't invoked for the new contact!", (boolean)this.rosterListener.getAddedAddresses().contains(contactJID));
        Assert.assertSame((String)"Setup wrong name for the new contact!", (Object)"PreApproval", (Object)addedEntry.getName());
        Assert.assertSame((String)"Setup wrong default subscription status!", (Object)RosterPacket.ItemType.none, (Object)addedEntry.getType());
        Assert.assertSame((String)"The new contact should be member of exactly one group!", (Object)0, (Object)addedEntry.getGroups().size());
    }

    private abstract class PreApproveAndCreateEntryResponder
    extends Thread {
        private Throwable exception = null;

        private PreApproveAndCreateEntryResponder() {
        }

        abstract void verifyRosterUpdateRequest(RosterPacket var1);

        abstract void verifyPreApprovalRequest(Presence var1);

        @Override
        public void run() {
            try {
                while (true) {
                    Stanza packet;
                    if ((packet = (Stanza)SubscriptionPreApprovalTest.this.connection.getSentPacket()) instanceof RosterPacket && ((IQ)packet).getType() == IQ.Type.set) {
                        RosterPacket rosterRequest = (RosterPacket)packet;
                        RosterPacket rosterPush = new RosterPacket();
                        RosterPacket.Item item = (RosterPacket.Item)rosterRequest.getRosterItems().iterator().next();
                        if (item.getItemType() != RosterPacket.ItemType.remove) {
                            item.setItemType(RosterPacket.ItemType.none);
                        }
                        rosterPush.setType(IQ.Type.set);
                        rosterPush.setTo((Jid)SubscriptionPreApprovalTest.this.connection.getUser());
                        rosterPush.addRosterItem(item);
                        SubscriptionPreApprovalTest.this.connection.processStanza((Stanza)rosterPush);
                        IQ response = IQ.createResultIQ((IQ)rosterRequest);
                        SubscriptionPreApprovalTest.this.connection.processStanza((Stanza)response);
                        Assert.assertSame((String)"A roster set MUST contain one and only one <item/> element.", (Object)1, (Object)rosterRequest.getRosterItemCount());
                        this.verifyRosterUpdateRequest(rosterRequest);
                        break;
                    }
                    if (!(packet instanceof Presence) || ((Presence)packet).getType() != Presence.Type.subscribed) continue;
                    Presence approval = (Presence)packet;
                    this.verifyPreApprovalRequest(approval);
                }
            }
            catch (Throwable e) {
                this.exception = e;
                Assert.fail((String)e.getMessage());
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

