/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterGroup;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jxmpp.jid.BareJid;

public final class RosterEntry
extends Manager {
    private final RosterPacket.Item item;
    private final Roster roster;

    RosterEntry(RosterPacket.Item item, Roster roster, XMPPConnection connection) {
        super(connection);
        this.item = item;
        this.roster = roster;
    }

    @Deprecated
    public String getUser() {
        return this.getJid().toString();
    }

    public BareJid getJid() {
        return this.item.getJid();
    }

    public String getName() {
        return this.item.getName();
    }

    public synchronized void setName(String name) throws SmackException.NotConnectedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException {
        if (name != null && name.equals(this.getName())) {
            return;
        }
        RosterPacket packet = new RosterPacket();
        packet.setType(IQ.Type.set);
        packet.addRosterItem(RosterEntry.toRosterItem(this, name));
        this.connection().createPacketCollectorAndSend((IQ)packet).nextResultOrThrow();
        this.item.setName(name);
    }

    void updateState(String name, RosterPacket.ItemType type, boolean subscriptionPending) {
        this.item.setName(name);
        this.item.setItemType(type);
        this.item.setSubscriptionPending(subscriptionPending);
    }

    public boolean isApproved() {
        return this.item.isApproved();
    }

    public List<RosterGroup> getGroups() {
        ArrayList<RosterGroup> results = new ArrayList<RosterGroup>();
        for (RosterGroup group : this.roster.getGroups()) {
            if (!group.contains(this)) continue;
            results.add(group);
        }
        return results;
    }

    public RosterPacket.ItemType getType() {
        return this.item.getItemType();
    }

    public boolean isSubscriptionPending() {
        return this.item.isSubscriptionPending();
    }

    public boolean canSeeMyPresence() {
        switch (this.getType()) {
            case from: 
            case both: {
                return true;
            }
        }
        return false;
    }

    public boolean canSeeHisPresence() {
        switch (this.getType()) {
            case both: 
            case to: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.getName() != null) {
            buf.append(this.getName()).append(": ");
        }
        buf.append((CharSequence)this.getJid());
        List<RosterGroup> groups = this.getGroups();
        if (!groups.isEmpty()) {
            buf.append(" [");
            Iterator iter = groups.iterator();
            RosterGroup group = (RosterGroup)((Object)iter.next());
            buf.append(group.getName());
            while (iter.hasNext()) {
                buf.append(", ");
                group = (RosterGroup)((Object)iter.next());
                buf.append(group.getName());
            }
            buf.append(']');
        }
        return buf.toString();
    }

    public int hashCode() {
        return this.getJid().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof RosterEntry) {
            return this.getJid().equals((CharSequence)((RosterEntry)((Object)object)).getJid());
        }
        return false;
    }

    public boolean equalsDeep(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RosterEntry other = (RosterEntry)((Object)obj);
        return other.item.equals(this.item);
    }

    static RosterPacket.Item toRosterItem(RosterEntry entry) {
        return RosterEntry.toRosterItem(entry, entry.getName());
    }

    private static RosterPacket.Item toRosterItem(RosterEntry entry, String name) {
        RosterPacket.Item item = new RosterPacket.Item(entry.getJid(), name);
        item.setItemType(entry.getType());
        item.setSubscriptionPending(entry.isSubscriptionPending());
        item.setApproved(entry.isApproved());
        for (RosterGroup group : entry.getGroups()) {
            item.addGroupName(group.getName());
        }
        return item;
    }
}

