/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jivesoftware.smack.roster.AbstractRosterListener;
import org.jivesoftware.smack.roster.Roster;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;

public class RosterUtil {
    public static void waitUntilOtherEntityIsSubscribed(Roster roster, BareJid otherEntity, long timeoutMillis) throws InterruptedException, TimeoutException {
        Date deadline = new Date(System.currentTimeMillis() + timeoutMillis);
        RosterUtil.waitUntilOtherEntityIsSubscribed(roster, otherEntity, deadline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitUntilOtherEntityIsSubscribed(Roster roster, BareJid otherEntity, Date deadline) throws InterruptedException, TimeoutException {
        final ReentrantLock lock = new ReentrantLock();
        final Condition maybeSubscribed = lock.newCondition();
        AbstractRosterListener rosterListener = new AbstractRosterListener(){

            private void signal() {
                lock.lock();
                try {
                    maybeSubscribed.signal();
                }
                finally {
                    lock.unlock();
                }
            }

            @Override
            public void entriesAdded(Collection<Jid> addresses) {
                this.signal();
            }

            @Override
            public void entriesUpdated(Collection<Jid> addresses) {
                this.signal();
            }
        };
        roster.addRosterListener(rosterListener);
        boolean stillWaiting = true;
        lock.lock();
        try {
            while (!roster.isSubscribedToMyPresence((Jid)otherEntity)) {
                if (!stillWaiting) {
                    throw new TimeoutException();
                }
                stillWaiting = maybeSubscribed.awaitUntil(deadline);
            }
        }
        finally {
            lock.unlock();
            roster.removeRosterListener(rosterListener);
        }
    }
}

