/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.AbstractConnectionListener;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PresenceTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.filter.ToMatchesFilter;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.roster.PresenceEventListener;
import org.jivesoftware.smack.roster.RosterEntries;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.RosterGroup;
import org.jivesoftware.smack.roster.RosterListener;
import org.jivesoftware.smack.roster.RosterLoadedListener;
import org.jivesoftware.smack.roster.RosterUtil;
import org.jivesoftware.smack.roster.SubscribeListener;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.roster.rosterstore.RosterStore;
import org.jivesoftware.smack.util.ExceptionCallback;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.SuccessCallback;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.util.cache.LruCache;

public final class Roster
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(Roster.class.getName());
    private static final Map<XMPPConnection, Roster> INSTANCES;
    private static final StanzaFilter PRESENCE_PACKET_FILTER;
    private static final StanzaFilter OUTGOING_USER_UNAVAILABLE_PRESENCE;
    private static boolean rosterLoadedAtLoginDefault;
    private static SubscriptionMode defaultSubscriptionMode;
    public static final int INITIAL_DEFAULT_NON_ROSTER_PRESENCE_MAP_SIZE = 1024;
    private static int defaultNonRosterPresenceMapMaxSize;
    private RosterStore rosterStore;
    private final Map<String, RosterGroup> groups = new ConcurrentHashMap<String, RosterGroup>();
    private final Map<BareJid, RosterEntry> entries = new ConcurrentHashMap<BareJid, RosterEntry>();
    private final Set<RosterEntry> unfiledEntries = new CopyOnWriteArraySet<RosterEntry>();
    private final Set<RosterListener> rosterListeners = new LinkedHashSet<RosterListener>();
    private final Set<PresenceEventListener> presenceEventListeners = new CopyOnWriteArraySet<PresenceEventListener>();
    private final Map<BareJid, Map<Resourcepart, Presence>> presenceMap = new ConcurrentHashMap<BareJid, Map<Resourcepart, Presence>>();
    private final LruCache<BareJid, Map<Resourcepart, Presence>> nonRosterPresenceMap = new LruCache(defaultNonRosterPresenceMapMaxSize);
    private final Set<RosterLoadedListener> rosterLoadedListeners = new LinkedHashSet<RosterLoadedListener>();
    private final Object rosterListenersAndEntriesLock = new Object();
    private RosterState rosterState = RosterState.uninitialized;
    private final PresencePacketListener presencePacketListener = new PresencePacketListener();
    private boolean rosterLoadedAtLogin = rosterLoadedAtLoginDefault;
    private SubscriptionMode subscriptionMode = Roster.getDefaultSubscriptionMode();
    private final Set<SubscribeListener> subscribeListeners = new CopyOnWriteArraySet<SubscribeListener>();
    private SubscriptionMode previousSubscriptionMode;
    private final AsyncButOrdered<BareJid> asyncButOrdered = new AsyncButOrdered();

    public static synchronized Roster getInstanceFor(XMPPConnection connection) {
        Roster roster = INSTANCES.get(connection);
        if (roster == null) {
            roster = new Roster(connection);
            INSTANCES.put(connection, roster);
        }
        return roster;
    }

    public static SubscriptionMode getDefaultSubscriptionMode() {
        return defaultSubscriptionMode;
    }

    public static void setDefaultSubscriptionMode(SubscriptionMode subscriptionMode) {
        defaultSubscriptionMode = subscriptionMode;
    }

    private Roster(final XMPPConnection connection) {
        super(connection);
        connection.registerIQRequestHandler((IQRequestHandler)new RosterPushListener());
        connection.addSyncStanzaListener((StanzaListener)this.presencePacketListener, PRESENCE_PACKET_FILTER);
        connection.addAsyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza stanza) throws SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
                Presence response;
                Presence presence = (Presence)stanza;
                Jid from = presence.getFrom();
                SubscribeListener.SubscribeAnswer subscribeAnswer = null;
                switch (Roster.this.subscriptionMode) {
                    case manual: {
                        SubscribeListener subscribeListener;
                        Iterator iterator = Roster.this.subscribeListeners.iterator();
                        while (iterator.hasNext() && (subscribeAnswer = (subscribeListener = (SubscribeListener)iterator.next()).processSubscribe(from, presence)) == null) {
                        }
                        if (subscribeAnswer != null) break;
                        return;
                    }
                    case accept_all: {
                        subscribeAnswer = SubscribeListener.SubscribeAnswer.Approve;
                        break;
                    }
                    case reject_all: {
                        subscribeAnswer = SubscribeListener.SubscribeAnswer.Deny;
                    }
                }
                if (subscribeAnswer == null) {
                    return;
                }
                switch (subscribeAnswer) {
                    case ApproveAndAlsoRequestIfRequired: {
                        BareJid bareFrom = from.asBareJid();
                        RosterUtil.askForSubscriptionIfRequired(Roster.this, bareFrom);
                    }
                    case Approve: {
                        response = new Presence(Presence.Type.subscribed);
                        break;
                    }
                    case Deny: {
                        response = new Presence(Presence.Type.unsubscribed);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                response.setTo(presence.getFrom());
                connection.sendStanza((Stanza)response);
            }
        }, (StanzaFilter)PresenceTypeFilter.SUBSCRIBE);
        connection.addConnectionListener((ConnectionListener)new AbstractConnectionListener(){

            public void authenticated(XMPPConnection connection, boolean resumed) {
                if (!Roster.this.isRosterLoadedAtLogin()) {
                    return;
                }
                if (resumed) {
                    return;
                }
                Roster.this.setOfflinePresencesAndResetLoaded();
                try {
                    Roster.this.reload();
                }
                catch (InterruptedException | SmackException e) {
                    LOGGER.log(Level.SEVERE, "Could not reload Roster", e);
                    return;
                }
            }

            public void connectionClosed() {
                Roster.this.setOfflinePresencesAndResetLoaded();
            }
        });
        connection.addStanzaSendingListener(new StanzaListener(){

            public void processStanza(Stanza stanzav) throws SmackException.NotConnectedException, InterruptedException {
                Roster.this.setOfflinePresences();
            }
        }, OUTGOING_USER_UNAVAILABLE_PRESENCE);
        if (connection.isAuthenticated()) {
            try {
                this.reloadAndWait();
            }
            catch (InterruptedException | SmackException e) {
                LOGGER.log(Level.SEVERE, "Could not reload Roster", e);
            }
        }
    }

    private Map<Resourcepart, Presence> getPresencesInternal(BareJid entity) {
        Map entityPresences = this.presenceMap.get(entity);
        if (entityPresences == null) {
            entityPresences = (Map)this.nonRosterPresenceMap.lookup((Object)entity);
        }
        return entityPresences;
    }

    private synchronized Map<Resourcepart, Presence> getOrCreatePresencesInternal(BareJid entity) {
        LruCache entityPresences = this.getPresencesInternal(entity);
        if (entityPresences == null) {
            if (this.contains(entity)) {
                entityPresences = new ConcurrentHashMap<Resourcepart, Presence>();
                this.presenceMap.put(entity, (Map<Resourcepart, Presence>)entityPresences);
            } else {
                LruCache nonRosterEntityPresences = new LruCache(32);
                this.nonRosterPresenceMap.put((Object)entity, (Object)nonRosterEntityPresences);
                entityPresences = nonRosterEntityPresences;
            }
        }
        return entityPresences;
    }

    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public void setSubscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    public void reload() throws SmackException.NotLoggedInException, SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.getAuthenticatedConnectionOrThrow();
        RosterPacket packet = new RosterPacket();
        if (this.rosterStore != null && this.isRosterVersioningSupported()) {
            packet.setVersion(this.rosterStore.getRosterVersion());
        }
        this.rosterState = RosterState.loading;
        SmackFuture future = connection.sendIqRequestAsync((IQ)packet);
        future.onSuccess((SuccessCallback)new RosterResultListener()).onError((ExceptionCallback)new ExceptionCallback<Exception>(){

            public void processException(Exception exception) {
                Roster.this.rosterState = RosterState.uninitialized;
                Level logLevel = exception instanceof SmackException.NotConnectedException ? Level.FINE : Level.SEVERE;
                LOGGER.log(logLevel, "Exception reloading roster", exception);
                for (RosterLoadedListener listener : Roster.this.rosterLoadedListeners) {
                    listener.onRosterLoadingFailed(exception);
                }
            }
        });
    }

    public void reloadAndWait() throws SmackException.NotLoggedInException, SmackException.NotConnectedException, InterruptedException {
        this.reload();
        this.waitUntilLoaded();
    }

    public boolean setRosterStore(RosterStore rosterStore) {
        this.rosterStore = rosterStore;
        try {
            this.reload();
        }
        catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException e) {
            LOGGER.log(Level.FINER, "Could not reload roster", e);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitUntilLoaded() throws InterruptedException {
        long now;
        long start = System.currentTimeMillis();
        for (long waitTime = this.connection().getReplyTimeout(); !this.isLoaded() && waitTime > 0L; waitTime -= now - start) {
            Roster roster = this;
            synchronized (roster) {
                if (!this.isLoaded()) {
                    ((Object)((Object)this)).wait(waitTime);
                }
            }
            now = System.currentTimeMillis();
            start = now;
        }
        return this.isLoaded();
    }

    public boolean isLoaded() {
        return this.rosterState == RosterState.loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRosterListener(RosterListener rosterListener) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            return this.rosterListeners.add(rosterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRosterListener(RosterListener rosterListener) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            return this.rosterListeners.remove(rosterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRosterLoadedListener(RosterLoadedListener rosterLoadedListener) {
        RosterLoadedListener rosterLoadedListener2 = rosterLoadedListener;
        synchronized (rosterLoadedListener2) {
            return this.rosterLoadedListeners.add(rosterLoadedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRosterLoadedListener(RosterLoadedListener rosterLoadedListener) {
        RosterLoadedListener rosterLoadedListener2 = rosterLoadedListener;
        synchronized (rosterLoadedListener2) {
            return this.rosterLoadedListeners.remove(rosterLoadedListener);
        }
    }

    public boolean addPresenceEventListener(PresenceEventListener presenceEventListener) {
        return this.presenceEventListeners.add(presenceEventListener);
    }

    public boolean removePresenceEventListener(PresenceEventListener presenceEventListener) {
        return this.presenceEventListeners.remove(presenceEventListener);
    }

    public RosterGroup createGroup(String name) {
        XMPPConnection connection = this.connection();
        if (this.groups.containsKey(name)) {
            return this.groups.get(name);
        }
        RosterGroup group = new RosterGroup(name, connection);
        this.groups.put(name, group);
        return group;
    }

    public void createEntry(BareJid user, String name, String[] groups) throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.getAuthenticatedConnectionOrThrow();
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.set);
        RosterPacket.Item item = new RosterPacket.Item(user, name);
        if (groups != null) {
            for (String group : groups) {
                if (group == null || group.trim().length() <= 0) continue;
                item.addGroupName(group);
            }
        }
        rosterPacket.addRosterItem(item);
        connection.createStanzaCollectorAndSend((IQ)rosterPacket).nextResultOrThrow();
        this.sendSubscriptionRequest(user);
    }

    public void preApproveAndCreateEntry(BareJid user, String name, String[] groups) throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.FeatureNotSupportedException {
        this.preApprove(user);
        this.createEntry(user, name, groups);
    }

    public void preApprove(BareJid user) throws SmackException.NotLoggedInException, SmackException.NotConnectedException, InterruptedException, SmackException.FeatureNotSupportedException {
        XMPPConnection connection = this.connection();
        if (!this.isSubscriptionPreApprovalSupported()) {
            throw new SmackException.FeatureNotSupportedException("Pre-approving");
        }
        Presence presencePacket = new Presence(Presence.Type.subscribed);
        presencePacket.setTo((Jid)user);
        connection.sendStanza((Stanza)presencePacket);
    }

    public boolean isSubscriptionPreApprovalSupported() throws SmackException.NotLoggedInException {
        XMPPConnection connection = this.getAuthenticatedConnectionOrThrow();
        return connection.hasFeature("sub", "urn:xmpp:features:pre-approval");
    }

    public void sendSubscriptionRequest(BareJid jid) throws SmackException.NotLoggedInException, SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.getAuthenticatedConnectionOrThrow();
        Presence presencePacket = new Presence(Presence.Type.subscribe);
        presencePacket.setTo((Jid)jid);
        connection.sendStanza((Stanza)presencePacket);
    }

    public boolean addSubscribeListener(SubscribeListener subscribeListener) {
        Objects.requireNonNull((Object)subscribeListener, (String)"SubscribeListener argument must not be null");
        if (this.subscriptionMode != SubscriptionMode.manual) {
            this.previousSubscriptionMode = this.subscriptionMode;
            this.subscriptionMode = SubscriptionMode.manual;
        }
        return this.subscribeListeners.add(subscribeListener);
    }

    public boolean removeSubscribeListener(SubscribeListener subscribeListener) {
        boolean removed = this.subscribeListeners.remove(subscribeListener);
        if (removed && this.subscribeListeners.isEmpty()) {
            this.setSubscriptionMode(this.previousSubscriptionMode);
        }
        return removed;
    }

    public void removeEntry(RosterEntry entry) throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        XMPPConnection connection = this.getAuthenticatedConnectionOrThrow();
        if (!this.entries.containsKey(entry.getJid())) {
            return;
        }
        RosterPacket packet = new RosterPacket();
        packet.setType(IQ.Type.set);
        RosterPacket.Item item = RosterEntry.toRosterItem(entry);
        item.setItemType(RosterPacket.ItemType.remove);
        packet.addRosterItem(item);
        connection.createStanzaCollectorAndSend((IQ)packet).nextResultOrThrow();
    }

    public int getEntryCount() {
        return this.getEntries().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getEntriesAndAddListener(RosterListener rosterListener, RosterEntries rosterEntries) {
        Objects.requireNonNull((Object)rosterListener, (String)"listener must not be null");
        Objects.requireNonNull((Object)rosterEntries, (String)"rosterEntries must not be null");
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            rosterEntries.rosterEntries(this.entries.values());
            this.addRosterListener(rosterListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<RosterEntry> getEntries() {
        HashSet<RosterEntry> allEntries;
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            allEntries = new HashSet<RosterEntry>(this.entries.size());
            for (RosterEntry entry : this.entries.values()) {
                allEntries.add(entry);
            }
        }
        return allEntries;
    }

    public int getUnfiledEntryCount() {
        return this.unfiledEntries.size();
    }

    public Set<RosterEntry> getUnfiledEntries() {
        return Collections.unmodifiableSet(this.unfiledEntries);
    }

    public RosterEntry getEntry(BareJid jid) {
        if (jid == null) {
            return null;
        }
        return this.entries.get(jid);
    }

    public boolean contains(BareJid jid) {
        return this.getEntry(jid) != null;
    }

    public RosterGroup getGroup(String name) {
        return this.groups.get(name);
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public Collection<RosterGroup> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public Presence getPresence(BareJid jid) {
        Map<Resourcepart, Presence> userPresences = this.getPresencesInternal(jid);
        if (userPresences == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom((Jid)jid);
            return presence;
        }
        Presence presence = null;
        Presence unavailable = null;
        for (Resourcepart resource : userPresences.keySet()) {
            Presence.Mode presenceMode;
            Presence p = userPresences.get(resource);
            if (!p.isAvailable()) {
                unavailable = p;
                continue;
            }
            if (presence == null || p.getPriority() > presence.getPriority()) {
                presence = p;
                continue;
            }
            if (p.getPriority() != presence.getPriority()) continue;
            Presence.Mode pMode = p.getMode();
            if (pMode == null) {
                pMode = Presence.Mode.available;
            }
            if ((presenceMode = presence.getMode()) == null) {
                presenceMode = Presence.Mode.available;
            }
            if (pMode.compareTo((Enum)presenceMode) >= 0) continue;
            presence = p;
        }
        if (presence == null) {
            if (unavailable != null) {
                return unavailable.clone();
            }
            presence = new Presence(Presence.Type.unavailable);
            presence.setFrom((Jid)jid);
            return presence;
        }
        return presence.clone();
    }

    public Presence getPresenceResource(FullJid userWithResource) {
        BareJid key = userWithResource.asBareJid();
        Resourcepart resource = userWithResource.getResourcepart();
        Map<Resourcepart, Presence> userPresences = this.getPresencesInternal(key);
        if (userPresences == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom((Jid)userWithResource);
            return presence;
        }
        Presence presence = userPresences.get(resource);
        if (presence == null) {
            presence = new Presence(Presence.Type.unavailable);
            presence.setFrom((Jid)userWithResource);
            return presence;
        }
        return presence.clone();
    }

    public List<Presence> getAllPresences(BareJid bareJid) {
        ArrayList<Presence> res;
        Map<Resourcepart, Presence> userPresences = this.getPresencesInternal(bareJid);
        if (userPresences == null) {
            Presence unavailable = new Presence(Presence.Type.unavailable);
            unavailable.setFrom((Jid)bareJid);
            res = new ArrayList<Presence>(Arrays.asList(unavailable));
        } else {
            res = new ArrayList<Presence>(userPresences.values().size());
            for (Presence presence : userPresences.values()) {
                res.add(presence.clone());
            }
        }
        return res;
    }

    public List<Presence> getAvailablePresences(BareJid bareJid) {
        List<Presence> allPresences = this.getAllPresences(bareJid);
        ArrayList<Presence> res = new ArrayList<Presence>(allPresences.size());
        for (Presence presence : allPresences) {
            if (!presence.isAvailable()) continue;
            res.add(presence);
        }
        return res;
    }

    public List<Presence> getPresences(BareJid jid) {
        List<Presence> res;
        Map<Resourcepart, Presence> userPresences = this.getPresencesInternal(jid);
        if (userPresences == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom((Jid)jid);
            res = Arrays.asList(presence);
        } else {
            ArrayList<Presence> answer = new ArrayList<Presence>();
            Presence unavailable = null;
            for (Presence presence : userPresences.values()) {
                if (presence.isAvailable()) {
                    answer.add(presence.clone());
                    continue;
                }
                unavailable = presence;
            }
            if (!answer.isEmpty()) {
                res = answer;
            } else if (unavailable != null) {
                res = Arrays.asList(unavailable.clone());
            } else {
                Presence presence = new Presence(Presence.Type.unavailable);
                presence.setFrom((Jid)jid);
                res = Arrays.asList(presence);
            }
        }
        return res;
    }

    public boolean isSubscribedToMyPresence(Jid jid) {
        if (jid == null) {
            return false;
        }
        BareJid bareJid = jid.asBareJid();
        if (this.connection().getXMPPServiceDomain().equals((CharSequence)bareJid)) {
            return true;
        }
        RosterEntry entry = this.getEntry(bareJid);
        if (entry == null) {
            return false;
        }
        return entry.canSeeMyPresence();
    }

    public boolean iAmSubscribedTo(Jid jid) {
        if (jid == null) {
            return false;
        }
        BareJid bareJid = jid.asBareJid();
        RosterEntry entry = this.getEntry(bareJid);
        if (entry == null) {
            return false;
        }
        return entry.canSeeHisPresence();
    }

    public static void setRosterLoadedAtLoginDefault(boolean rosterLoadedAtLoginDefault) {
        Roster.rosterLoadedAtLoginDefault = rosterLoadedAtLoginDefault;
    }

    public void setRosterLoadedAtLogin(boolean rosterLoadedAtLogin) {
        this.rosterLoadedAtLogin = rosterLoadedAtLogin;
    }

    public boolean isRosterLoadedAtLogin() {
        return this.rosterLoadedAtLogin;
    }

    RosterStore getRosterStore() {
        return this.rosterStore;
    }

    private void setOfflinePresences() {
        block3: for (Jid jid : this.presenceMap.keySet()) {
            Map<Resourcepart, Presence> resources = this.presenceMap.get(jid);
            if (resources == null) continue;
            for (Resourcepart resource : resources.keySet()) {
                Presence packetUnavailable = new Presence(Presence.Type.unavailable);
                EntityBareJid bareUserJid = jid.asEntityBareJidIfPossible();
                if (bareUserJid == null) {
                    LOGGER.warning("Can not transform user JID to bare JID: '" + jid + "'");
                    continue;
                }
                packetUnavailable.setFrom((Jid)JidCreate.fullFrom((EntityBareJid)bareUserJid, (Resourcepart)resource));
                try {
                    this.presencePacketListener.processStanza((Stanza)packetUnavailable);
                }
                catch (SmackException.NotConnectedException e) {
                    throw new IllegalStateException("presencePacketListener should never throw a NotConnectedException when processStanza is called with a presence of type unavailable", e);
                }
                catch (InterruptedException e) {
                    break block3;
                }
            }
        }
    }

    private void setOfflinePresencesAndResetLoaded() {
        this.setOfflinePresences();
        this.rosterState = RosterState.uninitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRosterChangedEvent(Collection<Jid> addedEntries, Collection<Jid> updatedEntries, Collection<Jid> deletedEntries) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            for (RosterListener listener : this.rosterListeners) {
                if (!addedEntries.isEmpty()) {
                    listener.entriesAdded(addedEntries);
                }
                if (!updatedEntries.isEmpty()) {
                    listener.entriesUpdated(updatedEntries);
                }
                if (deletedEntries.isEmpty()) continue;
                listener.entriesDeleted(deletedEntries);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRosterPresenceEvent(Presence presence) {
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            for (RosterListener listener : this.rosterListeners) {
                listener.presenceChanged(presence);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUpdateEntry(Collection<Jid> addedEntries, Collection<Jid> updatedEntries, Collection<Jid> unchangedEntries, RosterPacket.Item item, RosterEntry entry) {
        RosterEntry oldEntry;
        Object object = this.rosterListenersAndEntriesLock;
        synchronized (object) {
            oldEntry = this.entries.put(item.getJid(), entry);
        }
        if (oldEntry == null) {
            BareJid jid = item.getJid();
            addedEntries.add((Jid)jid);
            Roster.move(jid, this.nonRosterPresenceMap, this.presenceMap);
        } else {
            RosterPacket.Item oldItem = RosterEntry.toRosterItem(oldEntry);
            if (!oldEntry.equalsDeep((Object)entry) || !item.getGroupNames().equals(oldItem.getGroupNames())) {
                updatedEntries.add((Jid)item.getJid());
                oldEntry.updateItem(item);
            } else {
                unchangedEntries.add((Jid)item.getJid());
            }
        }
        if (item.getGroupNames().isEmpty()) {
            this.unfiledEntries.add(entry);
        } else {
            this.unfiledEntries.remove((Object)entry);
        }
        ArrayList<String> newGroupNames = new ArrayList<String>();
        for (String groupName : item.getGroupNames()) {
            newGroupNames.add(groupName);
            RosterGroup group = this.getGroup(groupName);
            if (group == null) {
                group = this.createGroup(groupName);
                this.groups.put(groupName, group);
            }
            group.addEntryLocal(entry);
        }
        ArrayList<String> oldGroupNames = new ArrayList<String>();
        for (RosterGroup group : this.getGroups()) {
            oldGroupNames.add(group.getName());
        }
        oldGroupNames.removeAll(newGroupNames);
        for (String groupName : oldGroupNames) {
            RosterGroup group = this.getGroup(groupName);
            group.removeEntryLocal(entry);
            if (group.getEntryCount() != 0) continue;
            this.groups.remove(groupName);
        }
    }

    private void deleteEntry(Collection<Jid> deletedEntries, RosterEntry entry) {
        BareJid user = entry.getJid();
        this.entries.remove(user);
        this.unfiledEntries.remove((Object)entry);
        Roster.move(user, this.presenceMap, this.nonRosterPresenceMap);
        deletedEntries.add((Jid)user);
        for (Map.Entry<String, RosterGroup> e : this.groups.entrySet()) {
            RosterGroup group = e.getValue();
            group.removeEntryLocal(entry);
            if (group.getEntryCount() != 0) continue;
            this.groups.remove(e.getKey());
        }
    }

    private void removeEmptyGroups() {
        for (RosterGroup group : this.getGroups()) {
            if (group.getEntryCount() != 0) continue;
            this.groups.remove(group.getName());
        }
    }

    private static void move(BareJid entity, Map<BareJid, Map<Resourcepart, Presence>> from, Map<BareJid, Map<Resourcepart, Presence>> to) {
        Map<Resourcepart, Presence> presences = from.remove(entity);
        if (presences != null && !presences.isEmpty()) {
            to.put(entity, presences);
        }
    }

    private static boolean hasValidSubscriptionType(RosterPacket.Item item) {
        switch (item.getItemType()) {
            case none: 
            case from: 
            case to: 
            case both: {
                return true;
            }
        }
        return false;
    }

    public boolean isRosterVersioningSupported() {
        return this.connection().hasFeature("ver", "urn:xmpp:features:rosterver");
    }

    public static void setDefaultNonRosterPresenceMapMaxSize(int maximumSize) {
        defaultNonRosterPresenceMapMaxSize = maximumSize;
    }

    public void setNonRosterPresenceMapMaxSize(int maximumSize) {
        this.nonRosterPresenceMap.setMaxCacheSize(maximumSize);
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                Roster.getInstanceFor(connection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, Roster>();
        PRESENCE_PACKET_FILTER = StanzaTypeFilter.PRESENCE;
        OUTGOING_USER_UNAVAILABLE_PRESENCE = new AndFilter(new StanzaFilter[]{PresenceTypeFilter.UNAVAILABLE, ToMatchesFilter.MATCH_NO_TO_SET});
        rosterLoadedAtLoginDefault = true;
        defaultSubscriptionMode = SubscriptionMode.reject_all;
        defaultNonRosterPresenceMapMaxSize = 1024;
    }

    private final class RosterPushListener
    extends AbstractIqRequestHandler {
        private RosterPushListener() {
            super("query", "jabber:iq:roster", IQ.Type.set, IQRequestHandler.Mode.sync);
        }

        public IQ handleIQRequest(IQ iqRequest) {
            List<RosterPacket.Item> items;
            XMPPConnection connection = Roster.this.connection();
            RosterPacket rosterPacket = (RosterPacket)iqRequest;
            EntityFullJid ourFullJid = connection.getUser();
            if (ourFullJid == null) {
                LOGGER.warning("Ignoring roster push " + iqRequest + " while " + connection + " has no bound resource. This may be a server bug.");
                return null;
            }
            EntityBareJid ourBareJid = ourFullJid.asEntityBareJid();
            Jid from = rosterPacket.getFrom();
            if (from != null) {
                if (from.equals((CharSequence)ourFullJid)) {
                    LOGGER.warning("Received roster push from full JID. This behavior is since RFC 6121 not longer standard compliant. Please ask your server vendor to fix this and comply to RFC 6121 \u00a7 2.1.6. IQ roster push stanza: " + iqRequest);
                } else if (!from.equals((CharSequence)ourBareJid)) {
                    LOGGER.warning("Ignoring roster push with a non matching 'from' ourJid='" + ourBareJid + "' from='" + from + "'");
                    return IQ.createErrorResponse((IQ)iqRequest, (StanzaError.Condition)StanzaError.Condition.service_unavailable);
                }
            }
            if ((items = rosterPacket.getRosterItems()).size() != 1) {
                LOGGER.warning("Ignoring roster push with not exactly one entry. size=" + items.size());
                return IQ.createErrorResponse((IQ)iqRequest, (StanzaError.Condition)StanzaError.Condition.bad_request);
            }
            ArrayList addedEntries = new ArrayList();
            ArrayList updatedEntries = new ArrayList();
            ArrayList deletedEntries = new ArrayList();
            ArrayList unchangedEntries = new ArrayList();
            RosterPacket.Item item = (RosterPacket.Item)items.iterator().next();
            RosterEntry entry = new RosterEntry(item, Roster.this, connection);
            String version = rosterPacket.getVersion();
            if (item.getItemType().equals((Object)RosterPacket.ItemType.remove)) {
                Roster.this.deleteEntry(deletedEntries, entry);
                if (Roster.this.rosterStore != null) {
                    Roster.this.rosterStore.removeEntry((Jid)entry.getJid(), version);
                }
            } else if (Roster.hasValidSubscriptionType(item)) {
                Roster.this.addUpdateEntry(addedEntries, updatedEntries, unchangedEntries, item, entry);
                if (Roster.this.rosterStore != null) {
                    Roster.this.rosterStore.addEntry(item, version);
                }
            }
            Roster.this.removeEmptyGroups();
            Roster.this.fireRosterChangedEvent(addedEntries, updatedEntries, deletedEntries);
            return IQ.createResultIQ((IQ)rosterPacket);
        }
    }

    private class RosterResultListener
    implements SuccessCallback<IQ> {
        private RosterResultListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(IQ packet) {
            Object storedItems;
            XMPPConnection connection = Roster.this.connection();
            LOGGER.log(Level.FINE, "RosterResultListener received {}", packet);
            ArrayList addedEntries = new ArrayList();
            ArrayList updatedEntries = new ArrayList();
            ArrayList deletedEntries = new ArrayList();
            ArrayList unchangedEntries = new ArrayList();
            if (packet instanceof RosterPacket) {
                RosterPacket rosterPacket = (RosterPacket)packet;
                ArrayList<RosterPacket.Item> validItems = new ArrayList<RosterPacket.Item>();
                for (RosterPacket.Item item : rosterPacket.getRosterItems()) {
                    if (!Roster.hasValidSubscriptionType(item)) continue;
                    validItems.add(item);
                }
                for (RosterPacket.Item item : validItems) {
                    RosterEntry rosterEntry = new RosterEntry(item, Roster.this, connection);
                    Roster.this.addUpdateEntry(addedEntries, updatedEntries, unchangedEntries, item, rosterEntry);
                }
                HashSet<BareJid> toDelete = new HashSet<BareJid>();
                for (RosterEntry rosterEntry : Roster.this.entries.values()) {
                    toDelete.add(rosterEntry.getJid());
                }
                toDelete.removeAll(addedEntries);
                toDelete.removeAll(updatedEntries);
                toDelete.removeAll(unchangedEntries);
                for (Jid jid : toDelete) {
                    Roster.this.deleteEntry(deletedEntries, (RosterEntry)((Object)Roster.this.entries.get(jid)));
                }
                if (Roster.this.rosterStore != null) {
                    String string = rosterPacket.getVersion();
                    Roster.this.rosterStore.resetEntries(validItems, string);
                }
                Roster.this.removeEmptyGroups();
            } else {
                storedItems = Roster.this.rosterStore.getEntries();
                if (storedItems == null) {
                    Roster.this.rosterStore.resetStore();
                    try {
                        Roster.this.reload();
                    }
                    catch (InterruptedException | SmackException.NotConnectedException | SmackException.NotLoggedInException e) {
                        LOGGER.log(Level.FINE, "Exception while trying to load the roster after the roster store was corrupted", e);
                    }
                    return;
                }
                for (RosterPacket.Item item : storedItems) {
                    RosterEntry rosterEntry = new RosterEntry(item, Roster.this, connection);
                    Roster.this.addUpdateEntry(addedEntries, updatedEntries, unchangedEntries, item, rosterEntry);
                }
            }
            Roster.this.rosterState = RosterState.loaded;
            storedItems = Roster.this;
            synchronized (storedItems) {
                ((Object)((Object)Roster.this)).notifyAll();
            }
            Roster.this.fireRosterChangedEvent(addedEntries, updatedEntries, deletedEntries);
            try {
                storedItems = Roster.this.rosterLoadedListeners;
                synchronized (storedItems) {
                    for (RosterLoadedListener rosterLoadedListener : Roster.this.rosterLoadedListeners) {
                        rosterLoadedListener.onRosterLoaded(Roster.this);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "RosterLoadedListener threw exception", e);
            }
        }
    }

    private class PresencePacketListener
    implements StanzaListener {
        private PresencePacketListener() {
        }

        public void processStanza(Stanza packet) throws SmackException.NotConnectedException, InterruptedException {
            Presence presence;
            Jid from;
            if (Roster.this.rosterState == RosterState.loading) {
                try {
                    Roster.this.waitUntilLoaded();
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.INFO, "Presence listener was interrupted", e);
                }
            }
            if (!Roster.this.isLoaded() && Roster.this.rosterLoadedAtLogin) {
                LOGGER.warning("Roster not loaded while processing " + packet);
            }
            final BareJid key = (from = (presence = (Presence)packet).getFrom()) != null ? from.asBareJid() : null;
            Roster.this.asyncButOrdered.performAsyncButOrdered((Object)key, new Runnable(){

                @Override
                public void run() {
                    Resourcepart fromResource = Resourcepart.EMPTY;
                    BareJid bareFrom = null;
                    FullJid fullFrom = null;
                    if (from != null) {
                        fromResource = from.getResourceOrNull();
                        if (fromResource == null) {
                            fromResource = Resourcepart.EMPTY;
                            bareFrom = from.asBareJid();
                        } else {
                            fullFrom = from.asFullJidIfPossible();
                            assert (fullFrom != null);
                        }
                    }
                    switch (presence.getType()) {
                        case available: {
                            Map userPresences = Roster.this.getOrCreatePresencesInternal(key);
                            userPresences.remove(Resourcepart.EMPTY);
                            userPresences.put(fromResource, presence);
                            if (Roster.this.contains(key)) {
                                Roster.this.fireRosterPresenceEvent(presence);
                            }
                            for (PresenceEventListener presenceEventListener : Roster.this.presenceEventListeners) {
                                presenceEventListener.presenceAvailable(fullFrom, presence);
                            }
                            break;
                        }
                        case unavailable: {
                            Map userPresences = Roster.this.getOrCreatePresencesInternal(key);
                            if (from.hasNoResource()) {
                                userPresences.put(Resourcepart.EMPTY, presence);
                            } else {
                                userPresences.put(fromResource, presence);
                            }
                            if (Roster.this.contains(key)) {
                                Roster.this.fireRosterPresenceEvent(presence);
                            }
                            if (fullFrom != null) {
                                for (PresenceEventListener presenceEventListener : Roster.this.presenceEventListeners) {
                                    presenceEventListener.presenceUnavailable(fullFrom, presence);
                                }
                                break;
                            }
                            LOGGER.fine("Unavailable presence from bare JID: " + presence);
                            break;
                        }
                        case error: {
                            if (from == null || !from.isEntityBareJid()) break;
                            Map userPresences = Roster.this.getOrCreatePresencesInternal(key);
                            userPresences.clear();
                            userPresences.put(Resourcepart.EMPTY, presence);
                            if (Roster.this.contains(key)) {
                                Roster.this.fireRosterPresenceEvent(presence);
                            }
                            for (PresenceEventListener presenceEventListener : Roster.this.presenceEventListeners) {
                                presenceEventListener.presenceError(from, presence);
                            }
                            break;
                        }
                        case subscribed: {
                            for (PresenceEventListener presenceEventListener : Roster.this.presenceEventListeners) {
                                presenceEventListener.presenceSubscribed(bareFrom, presence);
                            }
                            break;
                        }
                        case unsubscribed: {
                            for (PresenceEventListener presenceEventListener : Roster.this.presenceEventListeners) {
                                presenceEventListener.presenceUnsubscribed(bareFrom, presence);
                            }
                            break;
                        }
                    }
                }
            });
        }
    }

    public static enum SubscriptionMode {
        accept_all,
        reject_all,
        manual;

    }

    private static enum RosterState {
        uninitialized,
        loading,
        loaded;

    }
}

