/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.im.InitSmackIm;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.RosterGroup;
import org.jivesoftware.smack.roster.RosterListener;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.test.util.WaitForPacketListener;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.xmlpull.v1.XmlPullParser;

public class RosterTest
extends InitSmackIm {
    private DummyConnection connection;
    private Roster roster;
    private TestRosterListener rosterListener;

    @Before
    public void setUp() throws Exception {
        this.connection = new DummyConnection();
        this.connection.connect();
        this.connection.login();
        this.rosterListener = new TestRosterListener();
        this.roster = Roster.getInstanceFor((XMPPConnection)this.connection);
        this.roster.addRosterListener((RosterListener)this.rosterListener);
        this.connection.setReplyTimeout(300000L);
    }

    @After
    public void tearDown() throws Exception {
        if (this.connection != null) {
            if (this.rosterListener != null) {
                this.roster.removeRosterListener((RosterListener)this.rosterListener);
                this.rosterListener = null;
            }
            this.connection.disconnect();
            this.connection = null;
        }
    }

    @Test
    public void testSimpleRosterInitialization() throws Exception {
        Assert.assertNotNull((String)"Can't get the roster from the provided connection!", (Object)this.roster);
        Assert.assertFalse((String)"Roster shouldn't be already loaded!", (boolean)this.roster.isLoaded());
        this.initRoster();
        Assert.assertTrue((String)"Roster can't be loaded!", (boolean)this.roster.waitUntilLoaded());
        RosterTest.verifyRomeosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"romeo@example.net")));
        RosterTest.verifyMercutiosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"mercutio@example.com")));
        RosterTest.verifyBenvoliosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"benvolio@example.net")));
        Assert.assertSame((String)"Wrong number of roster entries.", (Object)3, (Object)this.roster.getEntries().size());
        Assert.assertTrue((String)"The roster listener wasn't invoked for Romeo.", (boolean)this.rosterListener.addedAddressesContains("romeo@example.net"));
        Assert.assertTrue((String)"The roster listener wasn't invoked for Mercutio.", (boolean)this.rosterListener.addedAddressesContains("mercutio@example.com"));
        Assert.assertTrue((String)"The roster listener wasn't invoked for Benvolio.", (boolean)this.rosterListener.addedAddressesContains("benvolio@example.net"));
        Assert.assertSame((String)"RosterListeners implies that a item was deleted!", (Object)0, (Object)this.rosterListener.getDeletedAddresses().size());
        Assert.assertSame((String)"RosterListeners implies that a item was updated!", (Object)0, (Object)this.rosterListener.getUpdatedAddresses().size());
    }

    @Test
    public void testAddRosterItem() throws Throwable {
        EntityBareJid contactJID = JidCreate.entityBareFrom((String)"nurse@example.com");
        String contactName = "Nurse";
        String[] contactGroup = new String[]{"Servants"};
        Assert.assertNotNull((String)"Can't get the roster from the provided connection!", (Object)this.roster);
        this.initRoster();
        this.rosterListener.reset();
        RosterUpdateResponder serverSimulator = new RosterUpdateResponder((BareJid)contactJID, contactGroup){
            final /* synthetic */ BareJid val$contactJID;
            final /* synthetic */ String[] val$contactGroup;
            {
                this.val$contactJID = bareJid;
                this.val$contactGroup = stringArray;
            }

            @Override
            void verifyUpdateRequest(RosterPacket updateRequest) {
                RosterPacket.Item item = (RosterPacket.Item)updateRequest.getRosterItems().iterator().next();
                Assert.assertEquals((String)"The provided JID doesn't match the requested!", (Object)this.val$contactJID, (Object)item.getJid());
                Assert.assertSame((String)"The provided name doesn't match the requested!", (Object)"Nurse", (Object)item.getName());
                Assert.assertSame((String)"The provided group number doesn't match the requested!", (Object)this.val$contactGroup.length, (Object)item.getGroupNames().size());
                Assert.assertSame((String)"The provided group doesn't match the requested!", (Object)this.val$contactGroup[0], item.getGroupNames().iterator().next());
            }
        };
        serverSimulator.start();
        this.roster.createEntry((BareJid)contactJID, "Nurse", contactGroup);
        serverSimulator.join();
        Throwable exception = serverSimulator.getException();
        if (exception != null) {
            throw exception;
        }
        this.rosterListener.waitUntilInvocationOrTimeout();
        RosterEntry addedEntry = this.roster.getEntry((BareJid)contactJID);
        Assert.assertNotNull((String)"The new contact wasn't added to the roster!", (Object)addedEntry);
        Assert.assertTrue((String)"The roster listener wasn't invoked for the new contact!", (boolean)this.rosterListener.getAddedAddresses().contains(contactJID));
        Assert.assertSame((String)"Setup wrong name for the new contact!", (Object)"Nurse", (Object)addedEntry.getName());
        Assert.assertSame((String)"Setup wrong default subscription status!", (Object)RosterPacket.ItemType.none, (Object)addedEntry.getType());
        Assert.assertSame((String)"The new contact should be member of exactly one group!", (Object)1, (Object)addedEntry.getGroups().size());
        Assert.assertSame((String)"Setup wrong group name for the added contact!", (Object)contactGroup[0], (Object)((RosterGroup)addedEntry.getGroups().iterator().next()).getName());
        RosterTest.verifyRomeosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"romeo@example.net")));
        RosterTest.verifyMercutiosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"mercutio@example.com")));
        RosterTest.verifyBenvoliosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"benvolio@example.net")));
        Assert.assertSame((String)"Wrong number of roster entries.", (Object)4, (Object)this.roster.getEntries().size());
    }

    @Test
    public void testUpdateRosterItem() throws Throwable {
        EntityBareJid contactJID = JidCreate.entityBareFrom((String)"romeo@example.net");
        String contactName = "Romeo";
        String[] contactGroups = new String[]{"Friends", "Lovers"};
        Assert.assertNotNull((String)"Can't get the roster from the provided connection!", (Object)this.roster);
        this.initRoster();
        this.rosterListener.reset();
        RosterUpdateResponder serverSimulator = new RosterUpdateResponder((BareJid)contactJID, contactGroups){
            final /* synthetic */ BareJid val$contactJID;
            final /* synthetic */ String[] val$contactGroups;
            {
                this.val$contactJID = bareJid;
                this.val$contactGroups = stringArray;
            }

            @Override
            void verifyUpdateRequest(RosterPacket updateRequest) {
                RosterPacket.Item item = (RosterPacket.Item)updateRequest.getRosterItems().iterator().next();
                Assert.assertEquals((String)"The provided JID doesn't match the requested!", (Object)this.val$contactJID, (Object)item.getJid());
                Assert.assertSame((String)"The provided name doesn't match the requested!", (Object)"Romeo", (Object)item.getName());
                Assert.assertTrue((String)("The updated contact doesn't belong to the requested groups (" + this.val$contactGroups[0] + ")!"), (boolean)item.getGroupNames().contains(this.val$contactGroups[0]));
                Assert.assertTrue((String)("The updated contact doesn't belong to the requested groups (" + this.val$contactGroups[1] + ")!"), (boolean)item.getGroupNames().contains(this.val$contactGroups[1]));
                Assert.assertSame((String)"The provided group number doesn't match the requested!", (Object)this.val$contactGroups.length, (Object)item.getGroupNames().size());
            }
        };
        serverSimulator.start();
        this.roster.createGroup(contactGroups[1]).addEntry(this.roster.getEntry((BareJid)contactJID));
        serverSimulator.join();
        Throwable exception = serverSimulator.getException();
        if (exception != null) {
            throw exception;
        }
        this.rosterListener.waitUntilInvocationOrTimeout();
        RosterEntry addedEntry = this.roster.getEntry((BareJid)contactJID);
        Assert.assertNotNull((String)"The contact was deleted from the roster!", (Object)addedEntry);
        Assert.assertTrue((String)"The roster listener wasn't invoked for the updated contact!", (boolean)this.rosterListener.getUpdatedAddresses().contains(contactJID));
        Assert.assertSame((String)"Setup wrong name for the changed contact!", (Object)"Romeo", (Object)addedEntry.getName());
        Assert.assertTrue((String)("The updated contact doesn't belong to the requested groups (" + contactGroups[0] + ")!"), (boolean)this.roster.getGroup(contactGroups[0]).contains(addedEntry));
        Assert.assertTrue((String)("The updated contact doesn't belong to the requested groups (" + contactGroups[1] + ")!"), (boolean)this.roster.getGroup(contactGroups[1]).contains(addedEntry));
        Assert.assertSame((String)"The updated contact should be member of two groups!", (Object)contactGroups.length, (Object)addedEntry.getGroups().size());
        RosterTest.verifyMercutiosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"mercutio@example.com")));
        RosterTest.verifyBenvoliosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"benvolio@example.net")));
        Assert.assertSame((String)("Wrong number of roster entries (" + this.roster.getEntries() + ")."), (Object)3, (Object)this.roster.getEntries().size());
    }

    @Test
    public void testDeleteRosterItem() throws Throwable {
        EntityBareJid contactJID = JidCreate.entityBareFrom((String)"romeo@example.net");
        Assert.assertNotNull((String)"Can't get the roster from the provided connection!", (Object)this.roster);
        this.initRoster();
        this.rosterListener.reset();
        RosterUpdateResponder serverSimulator = new RosterUpdateResponder((BareJid)contactJID){
            final /* synthetic */ BareJid val$contactJID;
            {
                this.val$contactJID = bareJid;
            }

            @Override
            void verifyUpdateRequest(RosterPacket updateRequest) {
                RosterPacket.Item item = (RosterPacket.Item)updateRequest.getRosterItems().iterator().next();
                Assert.assertEquals((String)"The provided JID doesn't match the requested!", (Object)this.val$contactJID, (Object)item.getJid());
            }
        };
        serverSimulator.start();
        this.roster.removeEntry(this.roster.getEntry((BareJid)contactJID));
        serverSimulator.join();
        Throwable exception = serverSimulator.getException();
        if (exception != null) {
            throw exception;
        }
        this.rosterListener.waitUntilInvocationOrTimeout();
        RosterEntry deletedEntry = this.roster.getEntry((BareJid)contactJID);
        Assert.assertNull((String)"The contact wasn't deleted from the roster!", (Object)deletedEntry);
        Assert.assertTrue((String)"The roster listener wasn't invoked for the deleted contact!", (boolean)this.rosterListener.getDeletedAddresses().contains(contactJID));
        RosterTest.verifyMercutiosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"mercutio@example.com")));
        RosterTest.verifyBenvoliosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"benvolio@example.net")));
        Assert.assertSame((String)("Wrong number of roster entries (" + this.roster.getEntries() + ")."), (Object)2, (Object)this.roster.getEntries().size());
    }

    @Test
    public void testSimpleRosterPush() throws Throwable {
        EntityBareJid contactJID = JidCreate.entityBareFrom((String)"nurse@example.com");
        Assert.assertNotNull((String)"Can't get the roster from the provided connection!", (Object)this.roster);
        StringBuilder sb = new StringBuilder();
        sb.append("<iq id=\"rostertest1\" type=\"set\" ").append("to=\"").append((CharSequence)this.connection.getUser()).append("\">").append("<query xmlns=\"jabber:iq:roster\">").append("<item jid=\"").append((CharSequence)contactJID).append("\"/>").append("</query>").append("</iq>");
        XmlPullParser parser = TestUtils.getIQParser((String)sb.toString());
        IQ rosterPush = PacketParserUtils.parseIQ((XmlPullParser)parser);
        this.initRoster();
        this.rosterListener.reset();
        this.connection.processStanza((Stanza)rosterPush);
        this.rosterListener.waitUntilInvocationOrTimeout();
        RosterEntry addedEntry = this.roster.getEntry((BareJid)contactJID);
        Assert.assertNotNull((String)"The new contact wasn't added to the roster!", (Object)addedEntry);
        Assert.assertTrue((String)"The roster listener wasn't invoked for the new contact!", (boolean)this.rosterListener.getAddedAddresses().contains(contactJID));
        Assert.assertSame((String)"Setup wrong default subscription status!", (Object)RosterPacket.ItemType.none, (Object)addedEntry.getType());
        Assert.assertSame((String)"The new contact shouldn't be member of any group!", (Object)0, (Object)addedEntry.getGroups().size());
        RosterTest.verifyRomeosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"romeo@example.net")));
        RosterTest.verifyMercutiosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"mercutio@example.com")));
        RosterTest.verifyBenvoliosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"benvolio@example.net")));
        Assert.assertSame((String)"Wrong number of roster entries.", (Object)4, (Object)this.roster.getEntries().size());
    }

    @Test
    public void testIgnoreInvalidFrom() throws XmppStringprepException {
        EntityBareJid spammerJid = JidCreate.entityBareFrom((String)"spam@example.com");
        RosterPacket packet = new RosterPacket();
        packet.setType(IQ.Type.set);
        packet.setTo((Jid)this.connection.getUser());
        packet.setFrom((Jid)JidCreate.entityBareFrom((String)"mallory@example.com"));
        packet.addRosterItem(new RosterPacket.Item((BareJid)spammerJid, "Cool products!"));
        String requestId = packet.getStanzaId();
        this.connection.processStanza((Stanza)packet);
        ErrorIQ errorIQ = (ErrorIQ)this.connection.getSentPacket();
        Assert.assertEquals((Object)requestId, (Object)errorIQ.getStanzaId());
        Assert.assertEquals((Object)StanzaError.Condition.service_unavailable, (Object)errorIQ.getError().getCondition());
        Assert.assertNull((String)"Contact was added to roster", (Object)Roster.getInstanceFor((XMPPConnection)this.connection).getEntry((BareJid)spammerJid));
    }

    @Test(timeout=5000L)
    public void testAddEmptyGroupEntry() throws Throwable {
        EntityBareJid contactJID = JidCreate.entityBareFrom((String)"nurse@example.com");
        String contactName = "Nurse";
        String[] contactGroup = new String[]{""};
        Assert.assertNotNull((String)"Can't get the roster from the provided connection!", (Object)this.roster);
        this.initRoster();
        this.rosterListener.reset();
        RosterUpdateResponder serverSimulator = new RosterUpdateResponder((BareJid)contactJID){
            final /* synthetic */ BareJid val$contactJID;
            {
                this.val$contactJID = bareJid;
            }

            @Override
            void verifyUpdateRequest(RosterPacket updateRequest) {
                RosterPacket.Item item = (RosterPacket.Item)updateRequest.getRosterItems().iterator().next();
                Assert.assertSame((String)"The provided JID doesn't match the requested!", (Object)this.val$contactJID, (Object)item.getJid());
                Assert.assertSame((String)"The provided name doesn't match the requested!", (Object)"Nurse", (Object)item.getName());
                Assert.assertSame((String)"Shouldn't provide an empty group element!", (Object)0, (Object)item.getGroupNames().size());
            }
        };
        serverSimulator.start();
        this.roster.createEntry((BareJid)contactJID, "Nurse", contactGroup);
        serverSimulator.join();
        Throwable exception = serverSimulator.getException();
        if (exception != null) {
            throw exception;
        }
        this.rosterListener.waitUntilInvocationOrTimeout();
        RosterEntry addedEntry = this.roster.getEntry((BareJid)contactJID);
        Assert.assertNotNull((String)"The new contact wasn't added to the roster!", (Object)addedEntry);
        Assert.assertTrue((String)"The roster listener wasn't invoked for the new contact!", (boolean)this.rosterListener.getAddedAddresses().contains(contactJID));
        Assert.assertSame((String)"Setup wrong name for the new contact!", (Object)"Nurse", (Object)addedEntry.getName());
        Assert.assertSame((String)"Setup wrong default subscription status!", (Object)RosterPacket.ItemType.none, (Object)addedEntry.getType());
        Assert.assertSame((String)"The new contact shouldn't be member of any group!", (Object)0, (Object)addedEntry.getGroups().size());
        RosterTest.verifyRomeosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"romeo@example.net")));
        RosterTest.verifyMercutiosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"mercutio@example.com")));
        RosterTest.verifyBenvoliosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"benvolio@example.net")));
        Assert.assertSame((String)"Wrong number of roster entries.", (Object)4, (Object)this.roster.getEntries().size());
    }

    @Test
    public void testEmptyGroupRosterPush() throws Throwable {
        EntityBareJid contactJID = JidCreate.entityBareFrom((String)"nurse@example.com");
        Assert.assertNotNull((String)"Can't get the roster from the provided connection!", (Object)this.roster);
        StringBuilder sb = new StringBuilder();
        sb.append("<iq id=\"rostertest2\" type=\"set\" ").append("to=\"").append((CharSequence)this.connection.getUser()).append("\">").append("<query xmlns=\"jabber:iq:roster\">").append("<item jid=\"").append((CharSequence)contactJID).append("\">").append("<group></group>").append("</item>").append("</query>").append("</iq>");
        XmlPullParser parser = TestUtils.getIQParser((String)sb.toString());
        IQ rosterPush = PacketParserUtils.parseIQ((XmlPullParser)parser);
        this.initRoster();
        this.rosterListener.reset();
        this.connection.processStanza((Stanza)rosterPush);
        this.rosterListener.waitUntilInvocationOrTimeout();
        RosterEntry addedEntry = this.roster.getEntry((BareJid)contactJID);
        Assert.assertNotNull((String)"The new contact wasn't added to the roster!", (Object)addedEntry);
        Assert.assertTrue((String)"The roster listener wasn't invoked for the new contact!", (boolean)this.rosterListener.getAddedAddresses().contains(contactJID));
        Assert.assertSame((String)"Setup wrong default subscription status!", (Object)RosterPacket.ItemType.none, (Object)addedEntry.getType());
        Assert.assertSame((String)"The new contact shouldn't be member of any group!", (Object)0, (Object)addedEntry.getGroups().size());
        RosterTest.verifyRomeosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"romeo@example.net")));
        RosterTest.verifyMercutiosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"mercutio@example.com")));
        RosterTest.verifyBenvoliosEntry(this.roster.getEntry((BareJid)JidCreate.entityBareFrom((String)"benvolio@example.net")));
        Assert.assertSame((String)"Wrong number of roster entries.", (Object)4, (Object)this.roster.getEntries().size());
    }

    public static void removeAllRosterEntries(DummyConnection connection, Roster roster) {
        for (RosterEntry entry : roster.getEntries()) {
            RosterPacket rosterPush = new RosterPacket();
            rosterPush.setType(IQ.Type.set);
            rosterPush.setTo((Jid)connection.getUser());
            RosterPacket.Item item = new RosterPacket.Item(entry.getJid(), entry.getName());
            item.setItemType(RosterPacket.ItemType.remove);
            rosterPush.addRosterItem(item);
            connection.processStanza((Stanza)rosterPush);
        }
    }

    private void initRoster() throws InterruptedException, SmackException, XmppStringprepException {
        Stanza sentPacket;
        this.roster.reload();
        while (!((sentPacket = (Stanza)this.connection.getSentPacket()) instanceof RosterPacket) || ((IQ)sentPacket).getType() != IQ.Type.get) {
        }
        RosterPacket rosterRequest = (RosterPacket)sentPacket;
        Assert.assertSame((String)"The <query/> element MUST NOT contain any <item/> child elements!", (Object)0, (Object)rosterRequest.getRosterItemCount());
        RosterPacket rosterResult = new RosterPacket();
        rosterResult.setTo((Jid)this.connection.getUser());
        rosterResult.setType(IQ.Type.result);
        rosterResult.setStanzaId(rosterRequest.getStanzaId());
        RosterPacket.Item romeo = new RosterPacket.Item((BareJid)JidCreate.entityBareFrom((String)"romeo@example.net"), "Romeo");
        romeo.addGroupName("Friends");
        romeo.setItemType(RosterPacket.ItemType.both);
        rosterResult.addRosterItem(romeo);
        RosterPacket.Item mercutio = new RosterPacket.Item((BareJid)JidCreate.entityBareFrom((String)"mercutio@example.com"), "Mercutio");
        mercutio.setItemType(RosterPacket.ItemType.from);
        rosterResult.addRosterItem(mercutio);
        RosterPacket.Item benvolio = new RosterPacket.Item((BareJid)JidCreate.entityBareFrom((String)"benvolio@example.net"), "Benvolio");
        benvolio.setItemType(RosterPacket.ItemType.both);
        rosterResult.addRosterItem(benvolio);
        this.connection.processStanza((Stanza)rosterResult);
        this.roster.waitUntilLoaded();
        this.rosterListener.waitUntilInvocationOrTimeout();
    }

    public static void verifyRomeosEntry(RosterEntry romeo) {
        Assert.assertNotNull((String)"Can't get Romeo's roster entry!", (Object)romeo);
        Assert.assertSame((String)"Setup wrong name for Romeo!", (Object)"Romeo", (Object)romeo.getName());
        Assert.assertSame((String)"Setup wrong subscription status for Romeo!", (Object)RosterPacket.ItemType.both, (Object)romeo.getType());
        Assert.assertSame((String)"Romeo should be member of exactly one group!", (Object)1, (Object)romeo.getGroups().size());
        Assert.assertSame((String)"Setup wrong group name for Romeo!", (Object)"Friends", (Object)((RosterGroup)romeo.getGroups().iterator().next()).getName());
    }

    public static void verifyMercutiosEntry(RosterEntry mercutio) {
        Assert.assertNotNull((String)"Can't get Mercutio's roster entry!", (Object)mercutio);
        Assert.assertSame((String)"Setup wrong name for Mercutio!", (Object)"Mercutio", (Object)mercutio.getName());
        Assert.assertSame((String)"Setup wrong subscription status for Mercutio!", (Object)RosterPacket.ItemType.from, (Object)mercutio.getType());
        Assert.assertTrue((String)"Mercutio shouldn't be a member of any group!", (boolean)mercutio.getGroups().isEmpty());
    }

    public static void verifyBenvoliosEntry(RosterEntry benvolio) {
        Assert.assertNotNull((String)"Can't get Benvolio's roster entry!", (Object)benvolio);
        Assert.assertSame((String)"Setup wrong name for Benvolio!", (Object)"Benvolio", (Object)benvolio.getName());
        Assert.assertSame((String)"Setup wrong subscription status for Benvolio!", (Object)RosterPacket.ItemType.both, (Object)benvolio.getType());
        Assert.assertTrue((String)"Benvolio shouldn't be a member of any group!", (boolean)benvolio.getGroups().isEmpty());
    }

    public static class TestRosterListener
    extends WaitForPacketListener
    implements RosterListener {
        private final List<Jid> addressesAdded = new CopyOnWriteArrayList<Jid>();
        private final List<Jid> addressesDeleted = new CopyOnWriteArrayList<Jid>();
        private final List<Jid> addressesUpdated = new CopyOnWriteArrayList<Jid>();

        public synchronized void entriesAdded(Collection<Jid> addresses) {
            this.addressesAdded.addAll(addresses);
            this.reportInvoked();
        }

        public synchronized void entriesDeleted(Collection<Jid> addresses) {
            this.addressesDeleted.addAll(addresses);
            this.reportInvoked();
        }

        public synchronized void entriesUpdated(Collection<Jid> addresses) {
            this.addressesUpdated.addAll(addresses);
            this.reportInvoked();
        }

        public void presenceChanged(Presence presence) {
            this.reportInvoked();
        }

        public Collection<Jid> getAddedAddresses() {
            return Collections.unmodifiableCollection(this.addressesAdded);
        }

        public Collection<Jid> getDeletedAddresses() {
            return Collections.unmodifiableCollection(this.addressesDeleted);
        }

        public Collection<Jid> getUpdatedAddresses() {
            return Collections.unmodifiableCollection(this.addressesUpdated);
        }

        public boolean addedAddressesContains(String jidString) {
            Jid jid;
            try {
                jid = JidCreate.from((String)jidString);
            }
            catch (XmppStringprepException e) {
                throw new IllegalArgumentException(e);
            }
            return this.addressesAdded.contains(jid);
        }

        public boolean deletedAddressesContains(String jidString) {
            Jid jid;
            try {
                jid = JidCreate.from((String)jidString);
            }
            catch (XmppStringprepException e) {
                throw new IllegalArgumentException(e);
            }
            return this.addressesDeleted.contains(jid);
        }

        public boolean updatedAddressesContains(String jidString) {
            Jid jid;
            try {
                jid = JidCreate.from((String)jidString);
            }
            catch (XmppStringprepException e) {
                throw new IllegalArgumentException(e);
            }
            return this.addressesUpdated.contains(jid);
        }

        public synchronized void reset() {
            super.reset();
            this.addressesAdded.clear();
            this.addressesDeleted.clear();
            this.addressesUpdated.clear();
        }
    }

    private abstract class RosterUpdateResponder
    extends Thread {
        private Throwable exception = null;

        private RosterUpdateResponder() {
        }

        abstract void verifyUpdateRequest(RosterPacket var1);

        @Override
        public void run() {
            try {
                Stanza packet;
                while (!((packet = (Stanza)RosterTest.this.connection.getSentPacket()) instanceof RosterPacket) || ((IQ)packet).getType() != IQ.Type.set) {
                }
                RosterPacket rosterRequest = (RosterPacket)packet;
                RosterPacket rosterPush = new RosterPacket();
                RosterPacket.Item item = (RosterPacket.Item)rosterRequest.getRosterItems().iterator().next();
                if (item.getItemType() != RosterPacket.ItemType.remove) {
                    item.setItemType(RosterPacket.ItemType.none);
                }
                rosterPush.setType(IQ.Type.set);
                rosterPush.setTo((Jid)RosterTest.this.connection.getUser());
                rosterPush.addRosterItem(item);
                RosterTest.this.connection.processStanza((Stanza)rosterPush);
                IQ response = IQ.createResultIQ((IQ)rosterRequest);
                RosterTest.this.connection.processStanza((Stanza)response);
                if (rosterRequest.getRosterItemCount() != 1) {
                    throw new AssertionError((Object)"A roster set MUST contain one and only one <item/> element.");
                }
                this.verifyUpdateRequest(rosterRequest);
            }
            catch (Throwable e) {
                this.exception = e;
                Assert.fail((String)e.getMessage());
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

