/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.chat;

import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.chat.ChatManagerListener;
import org.jivesoftware.smack.chat.ChatMessageListener;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.test.util.WaitForPacketListener;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;

public class ChatConnectionTest {
    private DummyConnection dc;
    private ChatManager cm;
    private TestChatManagerListener listener;
    private WaitForPacketListener waitListener;

    @Before
    public void setUp() throws Exception {
        ChatManager.setDefaultIsNormalIncluded((boolean)true);
        ChatManager.setDefaultMatchMode((ChatManager.MatchMode)ChatManager.MatchMode.BARE_JID);
        this.dc = DummyConnection.newConnectedDummyConnection();
        this.cm = ChatManager.getInstanceFor((XMPPConnection)this.dc);
        this.listener = new TestChatManagerListener();
        this.cm.addChatListener((ChatManagerListener)this.listener);
        this.waitListener = new WaitForPacketListener();
        this.dc.addSyncStanzaListener((StanzaListener)this.waitListener, null);
    }

    @After
    public void tearDown() throws Exception {
        if (this.dc != null) {
            this.dc.disconnect();
        }
    }

    @Test
    public void validateDefaultSetNormalIncludedFalse() {
        ChatManager.setDefaultIsNormalIncluded((boolean)false);
        Assert.assertFalse((boolean)ChatManager.getInstanceFor((XMPPConnection)new DummyConnection()).isNormalIncluded());
    }

    @Test
    public void validateDefaultSetNormalIncludedTrue() {
        ChatManager.setDefaultIsNormalIncluded((boolean)true);
        Assert.assertTrue((boolean)ChatManager.getInstanceFor((XMPPConnection)new DummyConnection()).isNormalIncluded());
    }

    @Test
    public void validateDefaultSetMatchModeNone() {
        ChatManager.setDefaultMatchMode((ChatManager.MatchMode)ChatManager.MatchMode.NONE);
        Assert.assertEquals((Object)ChatManager.MatchMode.NONE, (Object)ChatManager.getInstanceFor((XMPPConnection)new DummyConnection()).getMatchMode());
    }

    @Test
    public void validateDefaultSetMatchModeEntityBareJid() {
        ChatManager.setDefaultMatchMode((ChatManager.MatchMode)ChatManager.MatchMode.BARE_JID);
        Assert.assertEquals((Object)ChatManager.MatchMode.BARE_JID, (Object)ChatManager.getInstanceFor((XMPPConnection)new DummyConnection()).getMatchMode());
    }

    @Test
    public void validateMessageTypeWithDefaults1() {
        MessageBuilder incomingChat = ChatConnectionTest.createChatPacket("134", true);
        incomingChat.ofType(Message.Type.chat);
        this.processServerMessage((Stanza)incomingChat.build());
        Assert.assertNotNull((Object)this.listener.getNewChat());
    }

    @Test
    public void validateMessageTypeWithDefaults2() {
        MessageBuilder incomingChat = ChatConnectionTest.createChatPacket("134", true);
        incomingChat.ofType(Message.Type.normal);
        this.processServerMessage((Stanza)incomingChat.build());
        Assert.assertNotNull((Object)this.listener.getNewChat());
    }

    @Test
    public void validateMessageTypeWithDefaults3() {
        MessageBuilder incomingChat = ChatConnectionTest.createChatPacket("134", true);
        incomingChat.ofType(Message.Type.groupchat);
        this.processServerMessage((Stanza)incomingChat.build());
        Assert.assertNull((Object)this.listener.getNewChat());
    }

    @Test
    public void validateMessageTypeWithDefaults4() {
        MessageBuilder incomingChat = ChatConnectionTest.createChatPacket("134", true);
        incomingChat.ofType(Message.Type.headline);
        Assert.assertNull((Object)this.listener.getNewChat());
    }

    @Test
    public void validateMessageTypeWithNoNormal1() {
        this.cm.setNormalIncluded(false);
        MessageBuilder incomingChat = ChatConnectionTest.createChatPacket("134", true);
        incomingChat.ofType(Message.Type.chat);
        this.processServerMessage((Stanza)incomingChat.build());
        Assert.assertNotNull((Object)this.listener.getNewChat());
    }

    @Test
    public void validateMessageTypeWithNoNormal2() {
        this.cm.setNormalIncluded(false);
        MessageBuilder incomingChat = ChatConnectionTest.createChatPacket("134", true);
        incomingChat.ofType(Message.Type.normal);
        this.processServerMessage((Stanza)incomingChat.build());
        Assert.assertNull((Object)this.listener.getNewChat());
    }

    @Test
    public void chatMatchedOnJIDWhenNoThreadBareMode() {
        TestMessageListener msgListener = new TestMessageListener();
        TestChatManagerListener listener = new TestChatManagerListener(msgListener);
        this.cm.addChatListener((ChatManagerListener)listener);
        Message incomingChat = ChatConnectionTest.createChatMessage(null, true);
        this.processServerMessage((Stanza)incomingChat);
        Chat newChat = listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        incomingChat = ChatConnectionTest.createChatMessage(null, true);
        this.processServerMessage((Stanza)incomingChat);
        Assert.assertEquals((long)2L, (long)msgListener.getNumMessages());
        incomingChat = ChatConnectionTest.createChatMessage(null, false);
        this.processServerMessage((Stanza)incomingChat);
        Assert.assertEquals((long)3L, (long)msgListener.getNumMessages());
    }

    @Test
    public void chatMatchedOnJIDWhenNoThreadJidMode() {
        TestMessageListener msgListener = new TestMessageListener();
        TestChatManagerListener listener = new TestChatManagerListener(msgListener);
        this.cm.setMatchMode(ChatManager.MatchMode.SUPPLIED_JID);
        this.cm.addChatListener((ChatManagerListener)listener);
        Message incomingChat = ChatConnectionTest.createChatMessage(null, true);
        this.processServerMessage((Stanza)incomingChat);
        Chat newChat = listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        this.cm.removeChatListener((ChatManagerListener)listener);
        incomingChat = ChatConnectionTest.createChatMessage(null, true);
        this.processServerMessage((Stanza)incomingChat);
        Assert.assertEquals((long)2L, (long)msgListener.getNumMessages());
        TestChatManagerListener listener2 = new TestChatManagerListener();
        this.cm.addChatListener((ChatManagerListener)listener2);
        incomingChat = ChatConnectionTest.createChatMessage(null, false);
        this.processServerMessage((Stanza)incomingChat);
        Assert.assertEquals((long)2L, (long)msgListener.getNumMessages());
        Assert.assertNotNull((Object)listener2.getNewChat());
    }

    @Test
    public void chatMatchedOnJIDWhenNoThreadNoneMode() {
        TestMessageListener msgListener = new TestMessageListener();
        TestChatManagerListener listener = new TestChatManagerListener(msgListener);
        this.cm.setMatchMode(ChatManager.MatchMode.NONE);
        this.cm.addChatListener((ChatManagerListener)listener);
        Message incomingChat = ChatConnectionTest.createChatMessage(null, true);
        this.processServerMessage((Stanza)incomingChat);
        Chat newChat = listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertEquals((long)1L, (long)msgListener.getNumMessages());
        this.cm.removeChatListener((ChatManagerListener)listener);
        TestChatManagerListener listener2 = new TestChatManagerListener();
        this.cm.addChatListener((ChatManagerListener)listener2);
        incomingChat = ChatConnectionTest.createChatMessage(null, true);
        this.processServerMessage((Stanza)incomingChat);
        Assert.assertEquals((long)1L, (long)msgListener.getNumMessages());
        Assert.assertNotNull((Object)newChat);
        this.cm.removeChatListener((ChatManagerListener)listener2);
        TestChatManagerListener listener3 = new TestChatManagerListener();
        this.cm.addChatListener((ChatManagerListener)listener3);
        incomingChat = ChatConnectionTest.createChatMessage(null, false);
        this.processServerMessage((Stanza)incomingChat);
        Assert.assertEquals((long)1L, (long)msgListener.getNumMessages());
        Assert.assertNotNull((Object)listener3.getNewChat());
    }

    @Test
    public void chatFoundWhenNoThreadEntityFullJid() {
        Chat outgoing = this.cm.createChat((EntityJid)JidTestUtil.DUMMY_AT_EXAMPLE_ORG, null);
        Message incomingChat = ChatConnectionTest.createChatMessage(null, true);
        this.processServerMessage((Stanza)incomingChat);
        Chat newChat = this.listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertTrue((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatFoundWhenNoThreadBaseJid() {
        Chat outgoing = this.cm.createChat((EntityJid)JidTestUtil.DUMMY_AT_EXAMPLE_ORG, null);
        Message incomingChat = ChatConnectionTest.createChatMessage(null, false);
        this.processServerMessage((Stanza)incomingChat);
        Chat newChat = this.listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertTrue((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatFoundWithSameThreadEntityFullJid() {
        Chat outgoing = this.cm.createChat((EntityJid)JidTestUtil.DUMMY_AT_EXAMPLE_ORG, null);
        Message incomingChat = ChatConnectionTest.createChatMessage(outgoing.getThreadID(), true);
        this.processServerMessage((Stanza)incomingChat);
        Chat newChat = this.listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertTrue((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatFoundWithSameThreadBaseJid() {
        Chat outgoing = this.cm.createChat((EntityJid)JidTestUtil.DUMMY_AT_EXAMPLE_ORG, null);
        Message incomingChat = ChatConnectionTest.createChatMessage(outgoing.getThreadID(), false);
        this.processServerMessage((Stanza)incomingChat);
        Chat newChat = this.listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertTrue((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatNotFoundWithDiffThreadBaseJid() {
        Chat outgoing = this.cm.createChat((EntityJid)JidTestUtil.DUMMY_AT_EXAMPLE_ORG, null);
        Message incomingChat = ChatConnectionTest.createChatMessage(outgoing.getThreadID() + "ff", false);
        this.processServerMessage((Stanza)incomingChat);
        Chat newChat = this.listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertFalse((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatNotFoundWithDiffThreadEntityFullJid() {
        Chat outgoing = this.cm.createChat((EntityJid)JidTestUtil.DUMMY_AT_EXAMPLE_ORG, null);
        Message incomingChat = ChatConnectionTest.createChatMessage(outgoing.getThreadID() + "ff", true);
        this.processServerMessage((Stanza)incomingChat);
        Chat newChat = this.listener.getNewChat();
        Assert.assertNotNull((Object)newChat);
        Assert.assertFalse((newChat == outgoing ? 1 : 0) != 0);
    }

    @Test
    public void chatNotMatchedWithTypeNormal() {
        this.cm.setNormalIncluded(false);
        MessageBuilder incomingChat = ChatConnectionTest.createChatPacket(null, false);
        incomingChat.ofType(Message.Type.normal);
        this.processServerMessage((Stanza)incomingChat.build());
        Assert.assertNull((Object)this.listener.getNewChat());
    }

    private static MessageBuilder createChatPacket(String threadId, boolean isEntityFullJid) {
        MessageBuilder chatMsg = (MessageBuilder)StanzaBuilder.buildMessage().ofType(Message.Type.chat).to((Jid)JidTestUtil.BARE_JID_1);
        chatMsg.setBody("the body message - " + System.currentTimeMillis());
        Object jid = isEntityFullJid ? JidTestUtil.DUMMY_AT_EXAMPLE_ORG_SLASH_DUMMYRESOURCE : JidTestUtil.DUMMY_AT_EXAMPLE_ORG;
        chatMsg.from((Jid)jid);
        if (threadId != null) {
            chatMsg.setThread(threadId);
        }
        return chatMsg;
    }

    private static Message createChatMessage(String threadId, boolean isEntityFullJid) {
        return ChatConnectionTest.createChatPacket(threadId, isEntityFullJid).build();
    }

    private void processServerMessage(Stanza incomingChat) {
        TestChatServer chatServer = new TestChatServer(incomingChat, this.dc);
        chatServer.start();
        try {
            chatServer.join();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        this.waitListener.waitAndReset();
    }

    private static class TestMessageListener
    implements ChatMessageListener {
        private Chat msgChat;
        private int counter = 0;

        private TestMessageListener() {
        }

        public void processMessage(Chat chat, Message message) {
            this.msgChat = chat;
            ++this.counter;
        }

        public Chat getChat() {
            return this.msgChat;
        }

        public int getNumMessages() {
            return this.counter;
        }
    }

    private static class TestChatServer
    extends Thread {
        private final Stanza chatPacket;
        private final DummyConnection con;

        TestChatServer(Stanza chatMsg, DummyConnection connection) {
            this.chatPacket = chatMsg;
            this.con = connection;
        }

        @Override
        public void run() {
            this.con.processStanza(this.chatPacket);
        }
    }

    static class TestChatManagerListener
    extends WaitForPacketListener
    implements ChatManagerListener {
        private Chat newChat;
        private ChatMessageListener listener;

        TestChatManagerListener(TestMessageListener msgListener) {
            this.listener = msgListener;
        }

        TestChatManagerListener() {
        }

        public void chatCreated(Chat chat, boolean createdLocally) {
            this.newChat = chat;
            if (this.listener != null) {
                this.newChat.addMessageListener(this.listener);
            }
            this.reportInvoked();
        }

        public Chat getNewChat() {
            return this.newChat;
        }
    }
}

