/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster.rosterstore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.roster.rosterstore.DirectoryRosterStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;

public class DirectoryRosterStoreTest {
    @Rule
    public TemporaryFolder tmpFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testStoreUninitialized() throws IOException {
        File storeDir = this.tmpFolder.newFolder();
        Assert.assertNull((Object)DirectoryRosterStore.open((File)storeDir));
    }

    @Test
    public void testStoreInitializedEmpty() throws IOException {
        File storeDir = this.tmpFolder.newFolder();
        DirectoryRosterStore store = DirectoryRosterStore.init((File)storeDir);
        Assert.assertNotNull((String)"Initialization returns store", (Object)store);
        Assert.assertEquals((String)"Freshly initialized store must have empty version", (Object)"", (Object)store.getRosterVersion());
        Assert.assertEquals((String)"Freshly initialized store must have no entries", (long)0L, (long)store.getEntries().size());
    }

    @Test
    public void testStoreAddRemove() throws IOException {
        File storeDir = this.tmpFolder.newFolder();
        DirectoryRosterStore store = DirectoryRosterStore.init((File)storeDir);
        Assert.assertEquals((String)"Initial roster version", (Object)"", (Object)store.getRosterVersion());
        EntityBareJid userName = JidTestUtil.DUMMY_AT_EXAMPLE_ORG;
        RosterPacket.Item item1 = new RosterPacket.Item((BareJid)userName, null);
        String version1 = "1";
        store.addEntry(item1, "1");
        Assert.assertEquals((String)"Adding entry sets version correctly", (Object)"1", (Object)store.getRosterVersion());
        RosterPacket.Item storedItem = store.getEntry((Jid)userName);
        Assert.assertNotNull((String)"Added entry not found found", (Object)storedItem);
        Assert.assertEquals((String)"User of added entry", (Object)item1.getJid(), (Object)storedItem.getJid());
        Assert.assertEquals((String)"Name of added entry", (Object)item1.getName(), (Object)storedItem.getName());
        Assert.assertEquals((String)"Groups", (Object)item1.getGroupNames(), (Object)storedItem.getGroupNames());
        Assert.assertEquals((String)"ItemType of added entry", (Object)item1.getItemType(), (Object)storedItem.getItemType());
        Assert.assertEquals((String)"ItemStatus of added entry", (Object)item1.isSubscriptionPending(), (Object)storedItem.isSubscriptionPending());
        Assert.assertEquals((String)"Approved of added entry", (Object)item1.isApproved(), (Object)storedItem.isApproved());
        String version2 = "2";
        RosterPacket.Item item2 = new RosterPacket.Item((BareJid)userName, "Ursula Example");
        item2.addGroupName("users");
        item2.addGroupName("examples");
        item2.setSubscriptionPending(true);
        item2.setItemType(RosterPacket.ItemType.none);
        item2.setApproved(true);
        store.addEntry(item2, "2");
        Assert.assertEquals((String)"Updating entry sets version correctly", (Object)"2", (Object)store.getRosterVersion());
        storedItem = store.getEntry((Jid)userName);
        Assert.assertNotNull((String)"Added entry not found", (Object)storedItem);
        Assert.assertEquals((String)"User of added entry", (Object)item2.getJid(), (Object)storedItem.getJid());
        Assert.assertEquals((String)"Name of added entry", (Object)item2.getName(), (Object)storedItem.getName());
        Assert.assertEquals((String)"Groups", (Object)item2.getGroupNames(), (Object)storedItem.getGroupNames());
        Assert.assertEquals((String)"ItemType of added entry", (Object)item2.getItemType(), (Object)storedItem.getItemType());
        Assert.assertEquals((String)"ItemStatus of added entry", (Object)item2.isSubscriptionPending(), (Object)storedItem.isSubscriptionPending());
        Assert.assertEquals((String)"Approved of added entry", (Object)item2.isApproved(), (Object)storedItem.isApproved());
        List entries = store.getEntries();
        Assert.assertEquals((String)"Number of entries", (long)1L, (long)entries.size());
        RosterPacket.Item item3 = new RosterPacket.Item((BareJid)JidTestUtil.BARE_JID_1, "Foo Bar");
        item3.addGroupName("The Foo Fighters");
        item3.addGroupName("Bar Friends");
        item3.setSubscriptionPending(true);
        item3.setItemType(RosterPacket.ItemType.both);
        RosterPacket.Item item4 = new RosterPacket.Item((BareJid)JidTestUtil.BARE_JID_2, "Baba Baz");
        item4.addGroupName("The Foo Fighters");
        item4.addGroupName("Bar Friends");
        item4.setSubscriptionPending(false);
        item4.setItemType(RosterPacket.ItemType.both);
        item4.setApproved(true);
        ArrayList<RosterPacket.Item> items34 = new ArrayList<RosterPacket.Item>();
        items34.add(item3);
        items34.add(item4);
        String version3 = "3";
        store.resetEntries(items34, version3);
        storedItem = store.getEntry((Jid)JidTestUtil.BARE_JID_1);
        Assert.assertNotNull((String)"Added entry not found", (Object)storedItem);
        Assert.assertEquals((String)"User of added entry", (Object)item3.getJid(), (Object)storedItem.getJid());
        Assert.assertEquals((String)"Name of added entry", (Object)item3.getName(), (Object)storedItem.getName());
        Assert.assertEquals((String)"Groups", (Object)item3.getGroupNames(), (Object)storedItem.getGroupNames());
        Assert.assertEquals((String)"ItemType of added entry", (Object)item3.getItemType(), (Object)storedItem.getItemType());
        Assert.assertEquals((String)"ItemStatus of added entry", (Object)item3.isSubscriptionPending(), (Object)storedItem.isSubscriptionPending());
        Assert.assertEquals((String)"Approved of added entry", (Object)item3.isApproved(), (Object)storedItem.isApproved());
        storedItem = store.getEntry((Jid)JidTestUtil.BARE_JID_2);
        Assert.assertNotNull((String)"Added entry not found", (Object)storedItem);
        Assert.assertEquals((String)"User of added entry", (Object)item4.getJid(), (Object)storedItem.getJid());
        Assert.assertEquals((String)"Name of added entry", (Object)item4.getName(), (Object)storedItem.getName());
        Assert.assertEquals((String)"Groups", (Object)item4.getGroupNames(), (Object)storedItem.getGroupNames());
        Assert.assertEquals((String)"ItemType of added entry", (Object)item4.getItemType(), (Object)storedItem.getItemType());
        Assert.assertEquals((String)"ItemStatus of added entry", (Object)item4.isSubscriptionPending(), (Object)storedItem.isSubscriptionPending());
        Assert.assertEquals((String)"Approved of added entry", (Object)item4.isApproved(), (Object)storedItem.isApproved());
        entries = store.getEntries();
        Assert.assertEquals((String)"Number of entries", (long)2L, (long)entries.size());
        String version4 = "4";
        store.removeEntry((Jid)JidTestUtil.BARE_JID_2, version4);
        Assert.assertEquals((String)"Removing entry sets version correctly", (Object)version4, (Object)store.getRosterVersion());
        Assert.assertNull((String)"Removed entry is gone", (Object)store.getEntry((Jid)userName));
        entries = store.getEntries();
        Assert.assertEquals((String)"Number of entries", (long)1L, (long)entries.size());
    }
}

