/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.JxmppContext;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;

public class RosterPacketProvider
extends IqProvider<RosterPacket> {
    public static final RosterPacketProvider INSTANCE = new RosterPacketProvider();

    /*
     * Enabled aggressive block sorting
     */
    public RosterPacket parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        RosterPacket roster = new RosterPacket();
        String version = parser.getAttributeValue("", "ver");
        roster.setVersion(version);
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String startTag;
                    switch (startTag = parser.getName()) {
                        case "item": {
                            RosterPacket.Item item = RosterPacketProvider.parseItem(parser, jxmppContext);
                            roster.addRosterItem(item);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    String endTag;
                    switch (endTag = parser.getName()) {
                        case "query": {
                            if (parser.getDepth() != initialDepth) break;
                            return roster;
                        }
                    }
                    break;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static RosterPacket.Item parseItem(XmlPullParser parser, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag((XmlPullParser)parser, (String)"item");
        int initialDepth = parser.getDepth();
        String itemName = parser.getAttributeValue("", "name");
        EntityBareJid jid = ParserUtils.getBareJidAttribute((XmlPullParser)parser, (JxmppContext)jxmppContext);
        RosterPacket.Item item = new RosterPacket.Item((BareJid)jid, itemName);
        String ask = parser.getAttributeValue("", "ask");
        item.setSubscriptionPending("subscribe".equals(ask));
        String subscription = parser.getAttributeValue("", "subscription");
        RosterPacket.ItemType type = RosterPacket.ItemType.fromString(subscription);
        item.setItemType(type);
        boolean approved = ParserUtils.getBooleanAttribute((XmlPullParser)parser, (String)"approved", (boolean)false);
        item.setApproved(approved);
        block10: while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "group": {
                            String groupName = parser.nextText();
                            if (groupName != null && groupName.trim().length() > 0) {
                                item.addGroupName(groupName);
                                break;
                            }
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() == initialDepth) break block10;
                }
            }
        }
        ParserUtils.assertAtEndTag((XmlPullParser)parser);
        assert (item != null);
        return item;
    }
}

