/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.iqregister.AccountManager;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.stringprep.XmppStringprepException;

public class IntTestUtil {
    private static final Logger LOGGER = Logger.getLogger(IntTestUtil.class.getName());

    public static UsernameAndPassword registerAccount(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return IntTestUtil.registerAccount(connection, StringUtils.insecureRandomString((int)12), StringUtils.insecureRandomString((int)12));
    }

    public static UsernameAndPassword registerAccount(XMPPConnection connection, String username, String password) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Localpart usernameLocalpart;
        AccountManager accountManager = AccountManager.getInstance((XMPPConnection)connection);
        if (!accountManager.supportsAccountCreation()) {
            throw new UnsupportedOperationException("Account creation/registation is not supported");
        }
        Set requiredAttributes = accountManager.getAccountAttributes();
        if (requiredAttributes.size() > 4) {
            throw new IllegalStateException("Unkown required attributes");
        }
        HashMap<String, String> additionalAttributes = new HashMap<String, String>();
        additionalAttributes.put("name", "Smack Integration Test");
        additionalAttributes.put("email", "flow@igniterealtime.org");
        try {
            usernameLocalpart = Localpart.from((String)username);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException("Invalid username: " + username, e);
        }
        accountManager.createAccount(usernameLocalpart, password, additionalAttributes);
        return new UsernameAndPassword(username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnectAndMaybeDelete(XMPPTCPConnection connection, boolean delete) throws InterruptedException {
        block13: {
            if (!connection.isConnected()) {
                try {
                    connection.connect().login();
                }
                catch (IOException | SmackException | XMPPException e) {
                    LOGGER.log(Level.WARNING, "Exception reconnection account for deletion", e);
                }
            }
            try {
                int attempts;
                if (!delete) break block13;
                int maxAttempts = 3;
                AccountManager am = AccountManager.getInstance((XMPPConnection)connection);
                for (attempts = 0; attempts < 3; ++attempts) {
                    try {
                        am.deleteAccount();
                    }
                    catch (SmackException.NoResponseException | XMPPException.XMPPErrorException e) {
                        LOGGER.log(Level.WARNING, "Exception deleting account for " + connection, e);
                        continue;
                    }
                    catch (SmackException.NotConnectedException e) {
                        LOGGER.log(Level.WARNING, "Exception deleting account for " + connection, e);
                        try {
                            connection.connect().login();
                        }
                        catch (IOException | SmackException | XMPPException e2) {
                            LOGGER.log(Level.WARNING, "Exception while trying to re-connect " + connection, e);
                        }
                        continue;
                    }
                    LOGGER.info("Successfully deleted account of " + connection);
                    break;
                }
                if (attempts > 3) {
                    LOGGER.log(Level.SEVERE, "Could not delete account for connection: " + connection);
                }
            }
            finally {
                connection.disconnect();
            }
        }
    }

    public static final class UsernameAndPassword {
        public final String username;
        public final String password;

        private UsernameAndPassword(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

