/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.roster;

import java.util.Collection;
import java.util.concurrent.TimeoutException;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.util.SimpleResultSyncPoint;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.roster.AbstractRosterListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.RosterListener;
import org.jivesoftware.smack.roster.SubscribeListener;
import org.jivesoftware.smack.roster.packet.RosterPacket;
import org.junit.Assert;
import org.jxmpp.jid.Jid;

public class RosterIntegrationTest
extends AbstractSmackIntegrationTest {
    private final Roster rosterOne;
    private final Roster rosterTwo;

    public RosterIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment);
        this.rosterOne = Roster.getInstanceFor((XMPPConnection)this.conOne);
        this.rosterTwo = Roster.getInstanceFor((XMPPConnection)this.conTwo);
    }

    @SmackIntegrationTest
    public void subscribeRequestListenerTest() throws TimeoutException, Exception {
        this.ensureBothAccountsAreNotInEachOthersRoster();
        this.rosterTwo.setSubscribeListener(new SubscribeListener(){

            public SubscribeListener.SubscribeAnswer processSubscribe(Jid from, Presence subscribeRequest) {
                if (from.equals((CharSequence)RosterIntegrationTest.this.conOne.getUser().asBareJid())) {
                    return SubscribeListener.SubscribeAnswer.Approve;
                }
                return SubscribeListener.SubscribeAnswer.Deny;
            }
        });
        final String conTwosRosterName = "ConTwo " + this.testRunId;
        final SimpleResultSyncPoint addedAndSubscribed = new SimpleResultSyncPoint();
        this.rosterOne.addRosterListener((RosterListener)new AbstractRosterListener(){

            public void entriesAdded(Collection<Jid> addresses) {
                this.checkIfAddedAndSubscribed(addresses);
            }

            public void entriesUpdated(Collection<Jid> addresses) {
                this.checkIfAddedAndSubscribed(addresses);
            }

            private void checkIfAddedAndSubscribed(Collection<Jid> addresses) {
                for (Jid jid : addresses) {
                    if (!jid.equals((CharSequence)RosterIntegrationTest.this.conTwo.getUser().asBareJid())) continue;
                    RosterEntry rosterEntry = RosterIntegrationTest.this.rosterOne.getEntry(RosterIntegrationTest.this.conTwo.getUser().asBareJid());
                    if (!rosterEntry.getName().equals(conTwosRosterName)) {
                        addedAndSubscribed.signalFailure("Roster name does not match");
                        return;
                    }
                    if (!rosterEntry.getType().equals((Object)RosterPacket.ItemType.to)) {
                        return;
                    }
                    addedAndSubscribed.signal();
                }
            }
        });
        this.rosterOne.createEntry(this.conTwo.getUser().asBareJid(), conTwosRosterName, null);
        Assert.assertTrue((boolean)((Boolean)addedAndSubscribed.waitForResult(2L * this.connection.getPacketReplyTimeout())));
    }

    private void ensureBothAccountsAreNotInEachOthersRoster() throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.notInRoster(this.conOne, this.conTwo);
        this.notInRoster(this.conTwo, this.conOne);
    }

    private void notInRoster(XMPPConnection c1, XMPPConnection c2) throws SmackException.NotLoggedInException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Roster roster = Roster.getInstanceFor((XMPPConnection)c1);
        RosterEntry c2Entry = roster.getEntry(c2.getUser().asBareJid());
        if (c2Entry == null) {
            return;
        }
        roster.removeEntry(c2Entry);
    }
}

