/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import java.io.IOException;
import org.igniterealtime.smack.inttest.AbstractSmackLowLevelIntegrationTest;
import org.igniterealtime.smack.inttest.Configuration;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.bookmarks.BookmarkManager;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.MultiUserChatManager;
import org.jivesoftware.smackx.muc.bookmarkautojoin.MucBookmarkAutojoinManager;
import org.junit.Assert;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.jid.parts.Resourcepart;

public class MultiUserChatLowLevelIntegrationTest
extends AbstractSmackLowLevelIntegrationTest {
    public MultiUserChatLowLevelIntegrationTest(Configuration configuration, String testRunId) throws Exception {
        super(configuration, testRunId);
        this.performCheck(new AbstractSmackLowLevelIntegrationTest.ConnectionCallback(){

            @Override
            public void connectionCallback(XMPPTCPConnection connection) throws Exception {
                if (MultiUserChatManager.getInstanceFor((XMPPConnection)connection).getXMPPServiceDomains().isEmpty()) {
                    throw new TestNotPossibleException("MUC component not offered by service");
                }
            }
        });
    }

    @SmackIntegrationTest
    public void testMucBookmarksAutojoin(XMPPTCPConnection connection) throws InterruptedException, TestNotPossibleException, XMPPException, SmackException, IOException {
        BookmarkManager bookmarkManager = BookmarkManager.getBookmarkManager((XMPPConnection)connection);
        if (!bookmarkManager.isSupported()) {
            throw new TestNotPossibleException("Private data storage not supported");
        }
        MultiUserChatManager multiUserChatManager = MultiUserChatManager.getInstanceFor((XMPPConnection)connection);
        Resourcepart mucNickname = Resourcepart.from((String)("Nick-" + StringUtils.randomString((int)6)));
        String randomMucName = StringUtils.randomString((int)6);
        DomainBareJid mucComponent = (DomainBareJid)multiUserChatManager.getXMPPServiceDomains().get(0);
        MultiUserChat muc = multiUserChatManager.getMultiUserChat(JidCreate.entityBareFrom((Localpart)Localpart.from((String)randomMucName), (DomainBareJid)mucComponent));
        MultiUserChat.MucCreateConfigFormHandle handle = muc.createOrJoin(mucNickname);
        if (handle != null) {
            handle.makeInstant();
        }
        muc.leave();
        bookmarkManager.addBookmarkedConference("Smack Inttest: " + this.testRunId, muc.getRoom(), true, mucNickname, null);
        connection.disconnect();
        connection.connect().login();
        MucBookmarkAutojoinManager.getInstanceFor((XMPPConnection)connection).autojoinBookmarkedConferences();
        Assert.assertTrue((boolean)muc.isJoined());
        muc.leave();
    }
}

