/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.List;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.junit.Assert;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;

public class PubSubIntegrationTest
extends AbstractSmackIntegrationTest {
    private final PubSubManager pubSubManagerOne;

    public PubSubIntegrationTest(SmackIntegrationTestEnvironment environment) throws TestNotPossibleException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        super(environment);
        DomainBareJid pubSubService = PubSubManager.getPubSubService((XMPPConnection)this.conOne);
        if (pubSubService == null) {
            throw new TestNotPossibleException("No PubSub service found");
        }
        this.pubSubManagerOne = PubSubManager.getInstance((XMPPConnection)this.conOne, (BareJid)pubSubService);
        if (!this.pubSubManagerOne.canCreateNodesAndPublishItems()) {
            throw new TestNotPossibleException("PubSub service does not allow node creation");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SmackIntegrationTest
    public void simplePubSubNodeTest() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        String nodename = "sinttest-simple-nodename-" + this.testRunId;
        String itemId = "sintest-simple-itemid-" + this.testRunId;
        LeafNode leafNode = this.pubSubManagerOne.createNode(nodename);
        try {
            leafNode.publish(new Item(itemId));
            List items = leafNode.getItems();
            Assert.assertEquals((long)1L, (long)items.size());
            Item item = (Item)items.get(0);
            Assert.assertEquals((Object)itemId, (Object)item.getId());
        }
        finally {
            this.pubSubManagerOne.deleteNode(nodename);
        }
    }
}

