/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest.unittest;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.DummySmackIntegrationTestFramework;
import org.igniterealtime.smack.inttest.FailedTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.SmackIntegrationTestFramework;
import org.igniterealtime.smack.inttest.SmackIntegrationTestUnitTestUtil;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.XMPPError;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SmackIntegrationTestFrameworkUnitTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private static boolean beforeClassInvoked;
    private static boolean afterClassInvoked;

    @Test
    public void throwsRuntimeExceptionsTest() throws KeyManagementException, NoSuchAlgorithmException, SmackException, IOException, XMPPException, InterruptedException {
        this.expectedException.expect(RuntimeException.class);
        this.expectedException.expectMessage("Dummy RuntimeException");
        DummySmackIntegrationTestFramework sinttest = SmackIntegrationTestUnitTestUtil.getFrameworkForUnitTest(ThrowsRuntimeExceptionDummyTest.class);
        sinttest.run();
    }

    @Test
    public void logsNonFatalExceptionTest() throws KeyManagementException, NoSuchAlgorithmException, SmackException, IOException, XMPPException, InterruptedException {
        DummySmackIntegrationTestFramework sinttest = SmackIntegrationTestUnitTestUtil.getFrameworkForUnitTest(ThrowsNonFatalExceptionDummyTest.class);
        SmackIntegrationTestFramework.TestRunResult testRunResult = sinttest.run();
        List failedTests = testRunResult.getFailedTests();
        Assert.assertEquals((long)1L, (long)failedTests.size());
        FailedTest failedTest = (FailedTest)failedTests.get(0);
        Assert.assertTrue((boolean)(failedTest.failureReason instanceof XMPPException.XMPPErrorException));
        XMPPException.XMPPErrorException ex = (XMPPException.XMPPErrorException)failedTest.failureReason;
        Assert.assertEquals((Object)XMPPError.Condition.bad_request, (Object)ex.getXMPPError().getCondition());
        Assert.assertEquals((Object)"I'm not fatal", (Object)ex.getXMPPError().getDescriptiveText());
    }

    @Test
    public void testInvoking() throws KeyManagementException, NoSuchAlgorithmException, SmackException, IOException, XMPPException, InterruptedException {
        beforeClassInvoked = false;
        afterClassInvoked = false;
        DummySmackIntegrationTestFramework sinttest = SmackIntegrationTestUnitTestUtil.getFrameworkForUnitTest(BeforeAfterClassTest.class);
        sinttest.run();
        Assert.assertTrue((String)"A before class method should have been executed to this time", (boolean)beforeClassInvoked);
        Assert.assertTrue((String)"A after class method should have been executed to this time", (boolean)afterClassInvoked);
    }

    public static class BeforeAfterClassTest
    extends AbstractSmackIntegrationTest {
        public BeforeAfterClassTest(SmackIntegrationTestEnvironment environment) {
            super(environment);
        }

        @BeforeClass
        public static void setUp() {
            beforeClassInvoked = true;
        }

        @AfterClass
        public static void tearDown() {
            afterClassInvoked = true;
        }

        @SmackIntegrationTest
        public void test() {
            Assert.assertTrue((String)"A before class method should have been executed to this time", (boolean)beforeClassInvoked);
            Assert.assertFalse((String)"A after class method shouldn't have been executed to this time", (boolean)afterClassInvoked);
        }
    }

    public static class ThrowsNonFatalExceptionDummyTest
    extends AbstractSmackIntegrationTest {
        public static final String DESCRIPTIVE_TEXT = "I'm not fatal";

        public ThrowsNonFatalExceptionDummyTest(SmackIntegrationTestEnvironment environment) {
            super(environment);
        }

        @SmackIntegrationTest
        public void throwRuntimeExceptionTest() throws XMPPException.XMPPErrorException {
            throw new XMPPException.XMPPErrorException(XMPPError.from((XMPPError.Condition)XMPPError.Condition.bad_request, (String)DESCRIPTIVE_TEXT));
        }
    }

    public static class ThrowsRuntimeExceptionDummyTest
    extends AbstractSmackIntegrationTest {
        public static final String RUNTIME_EXCEPTION_MESSAGE = "Dummy RuntimeException";

        public ThrowsRuntimeExceptionDummyTest(SmackIntegrationTestEnvironment environment) {
            super(environment);
        }

        @SmackIntegrationTest
        public void throwRuntimeExceptionTest() {
            throw new RuntimeException(RUNTIME_EXCEPTION_MESSAGE);
        }
    }
}

