/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.igniterealtime.smack.inttest.AbstractSmackIntTest;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.StringUtils;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public final class Configuration {
    public final DomainBareJid service;
    public final String serviceTlsPin;
    public final ConnectionConfiguration.SecurityMode securityMode;
    public final int replyTimeout;
    public final boolean registerAccounts;
    public final String accountOneUsername;
    public final String accountOnePassword;
    public final String accountTwoUsername;
    public final String accountTwoPassword;
    public final String accountThreeUsername;
    public final String accountThreePassword;
    public final boolean debug;
    public final Set<String> enabledTests;
    public final Set<String> disabledTests;
    public final Set<String> testPackages;
    private static final String SINTTEST = "sinttest.";

    private Configuration(DomainBareJid service, String serviceTlsPin, ConnectionConfiguration.SecurityMode securityMode, int replyTimeout, boolean debug, String accountOneUsername, String accountOnePassword, String accountTwoUsername, String accountTwoPassword, String accountThreeUsername, String accountThreePassword, Set<String> enabledTests, Set<String> disabledTests, Set<String> testPackages) {
        this.service = (DomainBareJid)Objects.requireNonNull((Object)service, (String)"'service' must be set. Either via 'properties' files or via system property 'sinttest.service'.");
        this.serviceTlsPin = serviceTlsPin;
        this.securityMode = securityMode;
        this.replyTimeout = replyTimeout;
        this.debug = debug;
        this.registerAccounts = StringUtils.isNullOrEmpty((CharSequence)accountOneUsername) || StringUtils.isNullOrEmpty((CharSequence)accountOnePassword) || StringUtils.isNullOrEmpty((CharSequence)accountTwoUsername) || StringUtils.isNullOrEmpty((CharSequence)accountTwoPassword);
        this.accountOneUsername = accountOneUsername;
        this.accountOnePassword = accountOnePassword;
        this.accountTwoUsername = accountTwoUsername;
        this.accountTwoPassword = accountTwoPassword;
        this.accountThreeUsername = accountThreeUsername;
        this.accountThreePassword = accountThreePassword;
        this.enabledTests = enabledTests;
        this.disabledTests = disabledTests;
        this.testPackages = testPackages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Configuration newConfiguration() throws IOException {
        Properties properties = new Properties();
        File propertiesFile = Configuration.findPropertiesFile();
        if (propertiesFile != null) {
            FileInputStream in = new FileInputStream(propertiesFile);
            Object object = null;
            try {
                properties.load(in);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (object != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
        }
        Properties systemProperties = System.getProperties();
        for (Map.Entry<Object, Object> entry : systemProperties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(SINTTEST)) continue;
            key = key.substring(SINTTEST.length());
            String value = (String)entry.getValue();
            properties.put(key, value);
        }
        Builder builder = Configuration.builder();
        builder.setService(properties.getProperty("service"));
        builder.setServiceTlsPin(properties.getProperty("serviceTlsPin"));
        builder.setSecurityMode(properties.getProperty("securityMode"));
        builder.setReplyTimeout(properties.getProperty("replyTimeout", "60000"));
        String accountOneUsername = properties.getProperty("accountOneUsername");
        String accountOnePassword = properties.getProperty("accountOnePassword");
        String accountTwoUsername = properties.getProperty("accountTwoUsername");
        String accountTwoPassword = properties.getProperty("accountTwoPassword");
        String accountThreeUsername = properties.getProperty("accountThreeUsername");
        String accountThreePassword = properties.getProperty("accountThreePassword");
        builder.setUsernamesAndPassword(accountOneUsername, accountOnePassword, accountTwoUsername, accountTwoPassword, accountThreeUsername, accountThreePassword);
        builder.setDebug(properties.getProperty("debug"));
        builder.setEnabledTests(properties.getProperty("enabledTests"));
        builder.setDisabledTests(properties.getProperty("disabledTests"));
        builder.setTestPackages(properties.getProperty("testPackages"));
        return builder.build();
    }

    private static File findPropertiesFile() {
        LinkedList<String> possibleLocations = new LinkedList<String>();
        possibleLocations.add("properties");
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            possibleLocations.add(userHome + "/.config/smack-integration-test/properties");
        }
        for (String possibleLocation : possibleLocations) {
            File res = new File(possibleLocation);
            if (!res.isFile()) continue;
            return res;
        }
        return null;
    }

    private static Set<String> getTestSetFrom(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(",");
        HashSet<String> res = new HashSet<String>(stringArray.length);
        for (String s : stringArray) {
            res.add(Configuration.getFullTestStringFrom(s));
        }
        return res;
    }

    private static String getFullTestStringFrom(String string) {
        if ((string = string.trim()).startsWith("smackx.") || string.startsWith("smack.")) {
            string = "org.jivesoftware." + string;
        }
        return string;
    }

    public static final class Builder {
        private DomainBareJid service;
        private String serviceTlsPin;
        private ConnectionConfiguration.SecurityMode securityMode;
        private int replyTimeout;
        private String accountOneUsername;
        private String accountOnePassword;
        private String accountTwoUsername;
        private String accountTwoPassword;
        public String accountThreeUsername;
        public String accountThreePassword;
        private boolean debug;
        private Set<String> enabledTests;
        private Set<String> disabledTests;
        private Set<String> testPackages;

        private Builder() {
        }

        public Builder setService(String service) throws XmppStringprepException {
            if (service == null) {
                return this;
            }
            return this.setService(JidCreate.domainBareFrom((String)service));
        }

        public Builder setService(DomainBareJid service) {
            this.service = service;
            return this;
        }

        public Builder addEnabledTest(Class<? extends AbstractSmackIntTest> enabledTest) {
            if (this.enabledTests == null) {
                this.enabledTests = new HashSet<String>();
            }
            this.enabledTests.add(enabledTest.getName());
            return this.addTestPackage(enabledTest.getPackage().getName());
        }

        public Builder addTestPackage(String testPackage) {
            if (this.testPackages == null) {
                this.testPackages = new HashSet<String>();
            }
            this.testPackages.add(testPackage);
            return this;
        }

        public Builder setUsernamesAndPassword(String accountOneUsername, String accountOnePassword, String accountTwoUsername, String accountTwoPassword, String accountThreeUsername, String accountThreePassword) {
            this.accountOneUsername = (String)StringUtils.requireNotNullOrEmpty((CharSequence)accountOneUsername, (String)"accountOneUsername must not be null or empty");
            this.accountOnePassword = (String)StringUtils.requireNotNullOrEmpty((CharSequence)accountOnePassword, (String)"accountOnePassword must not be null or empty");
            this.accountTwoUsername = (String)StringUtils.requireNotNullOrEmpty((CharSequence)accountTwoUsername, (String)"accountTwoUsername must not be null or empty");
            this.accountTwoPassword = (String)StringUtils.requireNotNullOrEmpty((CharSequence)accountTwoPassword, (String)"accountTwoPasswordmust not be null or empty");
            this.accountThreeUsername = (String)StringUtils.requireNotNullOrEmpty((CharSequence)accountThreeUsername, (String)"accountThreeUsername must not be null or empty");
            this.accountThreePassword = (String)StringUtils.requireNotNullOrEmpty((CharSequence)accountThreePassword, (String)"accountThreePassword must not be null or empty");
            return this;
        }

        public Builder setServiceTlsPin(String tlsPin) {
            this.serviceTlsPin = tlsPin;
            return this;
        }

        public Builder setSecurityMode(String securityModeString) {
            this.securityMode = securityModeString != null ? ConnectionConfiguration.SecurityMode.valueOf((String)securityModeString) : ConnectionConfiguration.SecurityMode.required;
            return this;
        }

        public Builder setReplyTimeout(String timeout) {
            if (timeout != null) {
                this.replyTimeout = Integer.valueOf(timeout);
            }
            return this;
        }

        public Builder setDebug(String debugString) {
            if (debugString != null) {
                this.debug = Boolean.valueOf(debugString);
            }
            return this;
        }

        public Builder setEnabledTests(String enabledTestsString) {
            this.enabledTests = Configuration.getTestSetFrom(enabledTestsString);
            return this;
        }

        public Builder setDisabledTests(String disabledTestsString) {
            this.disabledTests = Configuration.getTestSetFrom(disabledTestsString);
            return this;
        }

        public Builder setTestPackages(String testPackagesString) {
            if (testPackagesString != null) {
                String[] testPackagesArray = testPackagesString.split(",");
                this.testPackages = new HashSet<String>(testPackagesArray.length);
                for (String s : testPackagesArray) {
                    this.testPackages.add(s.trim());
                }
            }
            return this;
        }

        public Configuration build() {
            return new Configuration(this.service, this.serviceTlsPin, this.securityMode, this.replyTimeout, this.debug, this.accountOneUsername, this.accountOnePassword, this.accountTwoUsername, this.accountTwoPassword, this.accountThreeUsername, this.accountThreePassword, this.enabledTests, this.disabledTests, this.testPackages);
        }
    }
}

