/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import org.igniterealtime.smack.inttest.AbstractSmackLowLevelIntegrationTest;
import org.igniterealtime.smack.inttest.Configuration;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.sasl.SASLError;
import org.jivesoftware.smack.sasl.SASLErrorException;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.util.StringUtils;
import org.junit.Assert;

public class LoginIntegrationTest
extends AbstractSmackLowLevelIntegrationTest {
    public LoginIntegrationTest(Configuration configuration, String testRunId) {
        super(configuration, testRunId);
    }

    @SmackIntegrationTest
    public void testInvalidLogin() throws SmackException, IOException, XMPPException, InterruptedException, KeyManagementException, NoSuchAlgorithmException {
        String nonExistentUserString = StringUtils.insecureRandomString((int)24);
        XMPPTCPConnectionConfiguration conf = ((XMPPTCPConnectionConfiguration.Builder)this.getConnectionConfiguration().setUsernameAndPassword((CharSequence)nonExistentUserString, "invalidPassword")).build();
        XMPPTCPConnection connection = new XMPPTCPConnection(conf);
        connection.connect();
        try {
            connection.login();
            Assert.fail((String)"Exception expected");
        }
        catch (SASLErrorException e) {
            Assert.assertEquals((Object)SASLError.not_authorized, (Object)e.getSASLFailure().getSASLError());
        }
    }
}

