/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import eu.geekplace.javapinning.java7.Java7Pinning;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.igniterealtime.smack.inttest.AbstractSmackIntTest;
import org.igniterealtime.smack.inttest.Configuration;
import org.igniterealtime.smack.inttest.IntTestUtil;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.SmackIntegrationTestFramework;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jxmpp.jid.DomainBareJid;

public abstract class AbstractSmackLowLevelIntegrationTest
extends AbstractSmackIntTest {
    private final SmackIntegrationTestEnvironment environment;
    protected final Configuration configuration;
    protected final DomainBareJid service;

    public AbstractSmackLowLevelIntegrationTest(SmackIntegrationTestEnvironment environment) {
        super(environment.testRunId, environment.configuration.replyTimeout);
        this.environment = environment;
        this.configuration = environment.configuration;
        this.service = this.configuration.service;
    }

    public final XMPPTCPConnectionConfiguration.Builder getConnectionConfiguration() throws KeyManagementException, NoSuchAlgorithmException {
        XMPPTCPConnectionConfiguration.Builder builder = XMPPTCPConnectionConfiguration.builder();
        if (this.configuration.serviceTlsPin != null) {
            SSLContext sc = Java7Pinning.forPin((String)this.configuration.serviceTlsPin);
            builder.setCustomSSLContext(sc);
        }
        builder.setSecurityMode(this.configuration.securityMode);
        builder.setXmppDomain(this.service);
        return builder;
    }

    protected void performCheck(ConnectionCallback callback) throws Exception {
        XMPPTCPConnection connection = SmackIntegrationTestFramework.getConnectedConnection(this.environment, -1);
        try {
            callback.connectionCallback(connection);
        }
        finally {
            IntTestUtil.disconnectAndMaybeDelete(connection, this.configuration);
        }
    }

    public static interface ConnectionCallback {
        public void connectionCallback(XMPPTCPConnection var1) throws Exception;
    }
}

