/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import eu.geekplace.javapinning.java7.Java7Pinning;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.igniterealtime.smack.inttest.AbstractSmackIntTest;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.AbstractSmackLowLevelIntegrationTest;
import org.igniterealtime.smack.inttest.Configuration;
import org.igniterealtime.smack.inttest.FailedTest;
import org.igniterealtime.smack.inttest.IntTestUtil;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.SuccessfulTest;
import org.igniterealtime.smack.inttest.TestNotPossible;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.iqregister.AccountManager;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.MethodParameterScanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;

public class SmackIntegrationTestFramework {
    private static final Logger LOGGER = Logger.getLogger(SmackIntegrationTestFramework.class.getName());
    private static final char CLASS_METHOD_SEP = '#';
    protected final Configuration config;
    protected TestRunResult testRunResult;
    private SmackIntegrationTestEnvironment environment;
    private static final String USERNAME_PREFIX = "smack-inttest";

    public static void main(String[] args) throws IOException, KeyManagementException, NoSuchAlgorithmException, SmackException, XMPPException, InterruptedException {
        Configuration config = Configuration.newConfiguration();
        SmackIntegrationTestFramework sinttest = new SmackIntegrationTestFramework(config);
        TestRunResult testRunResult = sinttest.run();
        for (Map.Entry entry : testRunResult.impossibleTestClasses.entrySet()) {
            LOGGER.info("Could not run " + ((Class)entry.getKey()).getName() + " because: " + (String)entry.getValue());
        }
        for (TestNotPossible testNotPossible : testRunResult.impossibleTestMethods) {
            LOGGER.info("Could not run " + testNotPossible.testMethod.getName() + " because: " + testNotPossible.testNotPossibleException.getMessage());
        }
        int successfulTests = testRunResult.successfulTests.size();
        int availableTests = testRunResult.getNumberOfAvailableTests();
        int possibleTests = testRunResult.getNumberOfPossibleTests();
        LOGGER.info("SmackIntegrationTestFramework[" + testRunResult.testRunId + ']' + ": Finished [" + successfulTests + '/' + possibleTests + "] (of " + availableTests + " available tests)");
        if (!testRunResult.failedIntegrationTests.isEmpty()) {
            int failedTests = testRunResult.failedIntegrationTests.size();
            LOGGER.warning("The following " + failedTests + " tests failed!");
            for (FailedTest failedTest : testRunResult.failedIntegrationTests) {
                Method method = failedTest.testMethod;
                String className = method.getDeclaringClass().getName();
                String methodName = method.getName();
                Throwable cause = failedTest.failureReason;
                LOGGER.severe(className + '#' + methodName + " failed: " + cause);
            }
            System.exit(2);
        } else {
            LOGGER.info("All possible Smack Integration Tests completed successfully. \\o/");
        }
        System.exit(0);
    }

    public SmackIntegrationTestFramework(Configuration configuration) {
        this.config = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized TestRunResult run() throws KeyManagementException, NoSuchAlgorithmException, SmackException, IOException, XMPPException, InterruptedException {
        this.testRunResult = new TestRunResult();
        LOGGER.info("SmackIntegrationTestFramework [" + this.testRunResult.testRunId + ']' + ": Starting");
        if (this.config.debug) {
            SmackConfiguration.addDisabledSmackClass((String)"org.jivesoftware.smack.debugger.JulDebugger");
            SmackConfiguration.DEBUG = true;
        }
        if (this.config.replyTimeout > 0) {
            SmackConfiguration.setDefaultReplyTimeout((int)this.config.replyTimeout);
        }
        if (this.config.securityMode != ConnectionConfiguration.SecurityMode.required) {
            AccountManager.sensitiveOperationOverInsecureConnectionDefault((boolean)true);
        }
        String[] testPackages = this.config.testPackages == null ? new String[]{"org.jivesoftware.smackx", "org.jivesoftware.smack"} : this.config.testPackages.toArray(new String[this.config.testPackages.size()]);
        Reflections reflections = new Reflections(new Object[]{testPackages, new SubTypesScanner(), new TypeAnnotationsScanner(), new MethodAnnotationsScanner(), new MethodParameterScanner()});
        Set inttestClasses = reflections.getSubTypesOf(AbstractSmackIntegrationTest.class);
        Set lowLevelInttestClasses = reflections.getSubTypesOf(AbstractSmackLowLevelIntegrationTest.class);
        HashSet<Class<? extends AbstractSmackIntTest>> classes = new HashSet<Class<? extends AbstractSmackIntTest>>(inttestClasses.size() + lowLevelInttestClasses.size());
        classes.addAll(inttestClasses);
        classes.addAll(lowLevelInttestClasses);
        if (classes.isEmpty()) {
            throw new IllegalStateException("No test classes found");
        }
        LOGGER.info("SmackIntegrationTestFramework [" + this.testRunResult.testRunId + "]: Finished scanning for tests, preparing environment");
        this.environment = this.prepareEnvironment();
        try {
            this.runTests(classes);
        }
        finally {
            this.disconnectAndMaybeDelete(this.environment.conOne);
            this.disconnectAndMaybeDelete(this.environment.conTwo);
            this.disconnectAndMaybeDelete(this.environment.conThree);
        }
        return this.testRunResult;
    }

    /*
     * Exception decompiling
     */
    private void runTests(Set<Class<? extends AbstractSmackIntTest>> classes) throws SmackException.NoResponseException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeLowLevel(Method testMethod, AbstractSmackIntTest test) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InterruptedException {
        int i;
        int numberOfConnections = testMethod.getParameterTypes().length;
        XMPPTCPConnection[] connections = null;
        try {
            if (numberOfConnections > 0 && !this.config.isAccountRegistrationPossible()) {
                throw new TestNotPossibleException("Must create accounts for this test, but it's not enabled");
            }
            connections = new XMPPTCPConnection[numberOfConnections];
            for (i = 0; i < numberOfConnections; ++i) {
                connections[i] = SmackIntegrationTestFramework.getConnectedConnection(this.environment, i);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new InvocationTargetException(e);
        }
        try {
            testMethod.invoke((Object)test, (Object[])connections);
        }
        finally {
            for (i = 0; i < numberOfConnections; ++i) {
                IntTestUtil.disconnectAndMaybeDelete(connections[i], this.config);
            }
        }
    }

    protected void disconnectAndMaybeDelete(XMPPTCPConnection connection) throws InterruptedException {
        IntTestUtil.disconnectAndMaybeDelete(connection, this.config);
    }

    protected SmackIntegrationTestEnvironment prepareEnvironment() throws SmackException, IOException, XMPPException, InterruptedException, KeyManagementException, NoSuchAlgorithmException {
        XMPPTCPConnection conOne = null;
        XMPPTCPConnection conTwo = null;
        XMPPTCPConnection conThree = null;
        try {
            conOne = this.getConnectedConnectionFor(AccountNum.One);
            conTwo = this.getConnectedConnectionFor(AccountNum.Two);
            conThree = this.getConnectedConnectionFor(AccountNum.Three);
        }
        catch (Exception e) {
            if (conOne != null) {
                conOne.disconnect();
            }
            if (conTwo != null) {
                conTwo.disconnect();
            }
            if (conThree != null) {
                conThree.disconnect();
            }
            throw e;
        }
        return new SmackIntegrationTestEnvironment(conOne, conTwo, conThree, this.testRunResult.testRunId, this.config);
    }

    private XMPPTCPConnection getConnectedConnectionFor(AccountNum accountNum) throws SmackException, IOException, XMPPException, InterruptedException, KeyManagementException, NoSuchAlgorithmException {
        String middlefix;
        String accountPassword;
        String accountUsername;
        switch (accountNum) {
            case One: {
                accountUsername = this.config.accountOneUsername;
                accountPassword = this.config.accountOnePassword;
                middlefix = "one";
                break;
            }
            case Two: {
                accountUsername = this.config.accountTwoUsername;
                accountPassword = this.config.accountTwoPassword;
                middlefix = "two";
                break;
            }
            case Three: {
                accountUsername = this.config.accountThreeUsername;
                accountPassword = this.config.accountThreePassword;
                middlefix = "three";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (StringUtils.isNullOrEmpty((CharSequence)accountUsername)) {
            accountUsername = "smack-inttest-" + middlefix + '-' + this.testRunResult.testRunId;
        }
        if (StringUtils.isNullOrEmpty((CharSequence)accountPassword)) {
            accountPassword = StringUtils.insecureRandomString((int)16);
        }
        XMPPTCPConnectionConfiguration.Builder builder = (XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setXmppDomain(this.config.service)).setUsernameAndPassword((CharSequence)accountUsername, accountPassword)).setResource((CharSequence)(middlefix + '-' + this.testRunResult.testRunId))).setSecurityMode(this.config.securityMode);
        if (StringUtils.isNotEmpty((CharSequence)this.config.serviceTlsPin)) {
            SSLContext sc = Java7Pinning.forPin((String)this.config.serviceTlsPin);
            builder.setCustomSSLContext(sc);
        }
        XMPPTCPConnection connection = new XMPPTCPConnection(builder.build());
        connection.connect();
        if (this.config.isAccountRegistrationPossible()) {
            IntTestUtil.UsernameAndPassword uap = IntTestUtil.registerAccount(connection, accountUsername, accountPassword, this.config);
            connection.disconnect();
            connection.connect();
            connection.login((CharSequence)uap.username, uap.password);
        } else {
            connection.login();
        }
        return connection;
    }

    static XMPPTCPConnection getConnectedConnection(SmackIntegrationTestEnvironment environment, int connectionId) throws KeyManagementException, NoSuchAlgorithmException, InterruptedException, SmackException, IOException, XMPPException {
        Configuration config = environment.configuration;
        XMPPTCPConnectionConfiguration.Builder builder = XMPPTCPConnectionConfiguration.builder();
        if (config.serviceTlsPin != null) {
            SSLContext sc = Java7Pinning.forPin((String)config.serviceTlsPin);
            builder.setCustomSSLContext(sc);
        }
        builder.setSecurityMode(config.securityMode);
        builder.setXmppDomain(config.service);
        XMPPTCPConnection connection = new XMPPTCPConnection(builder.build());
        connection.connect();
        IntTestUtil.UsernameAndPassword uap = IntTestUtil.registerAccount(connection, environment, connectionId);
        connection.login((CharSequence)uap.username, uap.password);
        return connection;
    }

    private static Exception throwFatalException(Throwable e) throws Error, SmackException.NoResponseException, InterruptedException {
        if (e instanceof SmackException.NoResponseException) {
            throw (SmackException.NoResponseException)e;
        }
        if (e instanceof InterruptedException) {
            throw (InterruptedException)e;
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        return (Exception)e;
    }

    private static boolean isInSet(Class<?> clz, Set<String> classes) {
        if (classes == null) {
            return false;
        }
        String className = clz.getName();
        String unqualifiedClassName = clz.getSimpleName();
        return classes.contains(className) || classes.contains(unqualifiedClassName);
    }

    public static final class TestRunResult {
        public final String testRunId = StringUtils.insecureRandomString((int)5).toLowerCase(Locale.US);
        private final List<SuccessfulTest> successfulTests = Collections.synchronizedList(new LinkedList());
        private final List<FailedTest> failedIntegrationTests = Collections.synchronizedList(new LinkedList());
        private final List<TestNotPossible> impossibleTestMethods = Collections.synchronizedList(new LinkedList());
        private final Map<Class<? extends AbstractSmackIntTest>, String> impossibleTestClasses = new HashMap<Class<? extends AbstractSmackIntTest>, String>();
        private final AtomicInteger numberOfAvailableTests = new AtomicInteger();
        private final AtomicInteger numberOfPossibleTests = new AtomicInteger();

        private TestRunResult() {
        }

        public String getTestRunId() {
            return this.testRunId;
        }

        public int getNumberOfAvailableTests() {
            return this.numberOfAvailableTests.get();
        }

        public int getNumberOfPossibleTests() {
            return this.numberOfPossibleTests.get();
        }

        public List<SuccessfulTest> getSuccessfulTests() {
            return Collections.unmodifiableList(this.successfulTests);
        }

        public List<FailedTest> getFailedTests() {
            return Collections.unmodifiableList(this.failedIntegrationTests);
        }

        public List<TestNotPossible> getNotPossibleTests() {
            return Collections.unmodifiableList(this.impossibleTestMethods);
        }

        public Map<Class<? extends AbstractSmackIntTest>, String> getImpossibleTestClasses() {
            return Collections.unmodifiableMap(this.impossibleTestClasses);
        }

        static /* synthetic */ AtomicInteger access$500(TestRunResult x0) {
            return x0.numberOfAvailableTests;
        }

        static /* synthetic */ AtomicInteger access$600(TestRunResult x0) {
            return x0.numberOfPossibleTests;
        }
    }

    static enum AccountNum {
        One,
        Two,
        Three;

    }

    public static enum TestType {
        Normal,
        LowLevel;

    }
}

