/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.mam;

import java.util.List;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.forward.packet.Forwarded;
import org.jivesoftware.smackx.mam.MamManager;
import org.jivesoftware.smackx.mam.element.MamPrefsIQ;
import org.junit.Assert;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;

public class MamIntegrationTest
extends AbstractSmackIntegrationTest {
    private final MamManager mamManagerConTwo;

    public MamIntegrationTest(SmackIntegrationTestEnvironment environment) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, TestNotPossibleException {
        super(environment);
        this.mamManagerConTwo = MamManager.getInstanceFor((XMPPConnection)this.conTwo);
        if (!this.mamManagerConTwo.isSupportedByServer()) {
            throw new TestNotPossibleException("Message Archive Management (XEP-0313) is not supported by the server.");
        }
    }

    @SmackIntegrationTest
    public void mamTest() throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotLoggedInException {
        EntityBareJid userOne = this.conOne.getUser().asEntityBareJid();
        EntityBareJid userTwo = this.conTwo.getUser().asEntityBareJid();
        this.mamManagerConTwo.updateArchivingPreferences(null, null, MamPrefsIQ.DefaultBehavior.always);
        Message message = new Message((Jid)userTwo);
        String messageId = message.setStanzaId();
        String messageBody = "test message";
        message.setBody(messageBody);
        this.conOne.sendStanza((Stanza)message);
        int pageSize = 20;
        MamManager.MamQueryResult mamQueryResult = this.mamManagerConTwo.queryArchive(Integer.valueOf(pageSize), null, null, (Jid)userOne, null);
        while (!mamQueryResult.mamFin.isComplete()) {
            mamQueryResult = this.mamManagerConTwo.pageNext(mamQueryResult, pageSize);
        }
        List forwardedMessages = mamQueryResult.forwardedMessages;
        Message mamMessage = (Message)((Forwarded)forwardedMessages.get(forwardedMessages.size() - 1)).getForwardedStanza();
        Assert.assertEquals((Object)messageId, (Object)mamMessage.getStanzaId());
        Assert.assertEquals((Object)messageBody, (Object)mamMessage.getBody());
        Assert.assertEquals((Object)this.conOne.getUser(), (Object)mamMessage.getFrom());
        Assert.assertEquals((Object)userTwo, (Object)mamMessage.getTo());
    }
}

