/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import junit.framework.TestCase;
import org.igniterealtime.smack.inttest.SmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.omemo.AbstractOmemoIntegrationTest;
import org.jivesoftware.smackx.omemo.OmemoIntegrationTestHelper;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoService;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jxmpp.jid.BareJid;

public class OmemoInitializationTest
extends AbstractOmemoIntegrationTest {
    private OmemoManager alice;
    private OmemoStore<?, ?, ?, ?, ?, ?, ?, ?, ?> store;

    @Override
    public void before() {
        this.alice = OmemoManager.getInstanceFor((XMPPConnection)this.conOne, (Integer)666);
        this.store = OmemoService.getInstance().getOmemoStoreBackend();
    }

    public OmemoInitializationTest(SmackIntegrationTestEnvironment environment) throws TestNotPossibleException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, InterruptedException {
        super(environment);
    }

    @SmackIntegrationTest
    public void initializationTest() throws XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, SmackException.NotLoggedInException, CorruptedOmemoKeyException {
        OmemoIntegrationTestHelper.setUpOmemoManager(this.alice);
        TestCase.assertNotNull((String)"IdentityKey must not be null after initialization.", (Object)this.store.loadOmemoIdentityKeyPair(this.alice));
        TestCase.assertTrue((String)"We must have 100 preKeys.", (this.store.loadOmemoPreKeys(this.alice).size() == 100 ? 1 : 0) != 0);
        TestCase.assertNotNull((String)"Our signedPreKey must not be null.", (Object)this.store.loadCurrentSignedPreKeyId(this.alice));
        TestCase.assertTrue((String)"Published deviceList must contain our deviceId.", (boolean)OmemoService.fetchDeviceList((OmemoManager)this.alice, (BareJid)this.alice.getOwnJid()).getDeviceIds().contains(this.alice.getDeviceId()));
        TestCase.assertTrue((String)"Our fingerprint must be of correct length.", (OmemoService.getInstance().getOmemoStoreBackend().getFingerprint(this.alice).length() == 64 ? 1 : 0) != 0);
    }

    @Override
    public void after() {
        this.alice.shutdown();
        OmemoIntegrationTestHelper.cleanServerSideTraces(this.alice);
    }
}

