/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.io.File;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smackx.omemo.FileBasedOmemoStore;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoService;
import org.jivesoftware.smackx.omemo.element.OmemoBundleVAxolotlElement;
import org.jivesoftware.smackx.omemo.exceptions.CannotEstablishOmemoSessionException;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.internal.CachedDeviceList;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.util.OmemoConstants;
import org.jivesoftware.smackx.pubsub.PubSubAssertionError;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jxmpp.jid.BareJid;

final class OmemoIntegrationTestHelper {
    private static final Logger LOGGER = Logger.getLogger(OmemoIntegrationTestHelper.class.getSimpleName());

    OmemoIntegrationTestHelper() {
    }

    static void cleanServerSideTraces(OmemoManager omemoManager) {
        OmemoIntegrationTestHelper.cleanUpPubSub(omemoManager);
        OmemoIntegrationTestHelper.cleanUpRoster(omemoManager);
    }

    static void deletePath(File storePath) {
        FileBasedOmemoStore.deleteDirectory((File)storePath);
    }

    static void deletePath(OmemoManager omemoManager) {
        OmemoService.getInstance().getOmemoStoreBackend().purgeOwnDeviceKeys(omemoManager);
    }

    static void cleanUpPubSub(OmemoManager omemoManager) {
        PubSubManager pm = PubSubManager.getInstance((XMPPConnection)omemoManager.getConnection(), (BareJid)omemoManager.getOwnJid());
        try {
            omemoManager.requestDeviceListUpdateFor(omemoManager.getOwnJid());
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException throwable) {
            // empty catch block
        }
        CachedDeviceList deviceList = OmemoService.getInstance().getOmemoStoreBackend().loadCachedDeviceList(omemoManager, omemoManager.getOwnJid());
        Iterator iterator = deviceList.getAllDevices().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            try {
                pm.getLeafNode(OmemoConstants.PEP_NODE_BUNDLE_FROM_DEVICE_ID((int)id)).deleteAllItems();
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | PubSubAssertionError.DiscoInfoNodeAssertionError | PubSubException.NotALeafNodeException throwable) {
                // empty catch block
            }
            try {
                pm.deleteNode(OmemoConstants.PEP_NODE_BUNDLE_FROM_DEVICE_ID((int)id));
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | PubSubAssertionError throwable) {}
        }
        try {
            pm.getLeafNode("eu.siacs.conversations.axolotl.devicelist").deleteAllItems();
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | PubSubAssertionError.DiscoInfoNodeAssertionError | PubSubException.NotALeafNodeException throwable) {
            // empty catch block
        }
        try {
            pm.deleteNode("eu.siacs.conversations.axolotl.devicelist");
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException | PubSubAssertionError throwable) {
            // empty catch block
        }
    }

    static void cleanUpRoster(OmemoManager omemoManager) {
        Roster roster = Roster.getInstanceFor((XMPPConnection)omemoManager.getConnection());
        for (RosterEntry r : roster.getEntries()) {
            try {
                roster.removeEntry(r);
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | SmackException.NotLoggedInException | XMPPException.XMPPErrorException throwable) {}
        }
    }

    static void subscribe(OmemoManager alice, OmemoManager bob, String nick) throws SmackException.NotLoggedInException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        Roster aliceRoster = Roster.getInstanceFor((XMPPConnection)alice.getConnection());
        Roster bobsRoster = Roster.getInstanceFor((XMPPConnection)bob.getConnection());
        bobsRoster.setSubscriptionMode(Roster.SubscriptionMode.accept_all);
        aliceRoster.createEntry(bob.getOwnJid(), nick, null);
    }

    static void unidirectionalTrust(OmemoManager alice, OmemoManager bob) throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, CannotEstablishOmemoSessionException {
        alice.requestDeviceListUpdateFor(bob.getOwnJid());
        LOGGER.log(Level.INFO, "Current deviceList state: " + alice.getOwnDevice() + " knows " + bob.getOwnDevice() + ": " + OmemoService.getInstance().getOmemoStoreBackend().loadCachedDeviceList(alice, bob.getOwnJid()));
        TestCase.assertTrue((String)"Trusting party must know the others device at this point.", (boolean)alice.getOmemoService().getOmemoStoreBackend().loadCachedDeviceList(alice, bob.getOwnJid()).getActiveDevices().contains(bob.getDeviceId()));
        alice.buildSessionsWith(bob.getOwnJid());
        TestCase.assertTrue((String)"Trusting party must have a session with the other end at this point.", (!alice.getOmemoService().getOmemoStoreBackend().loadAllRawSessionsOf(alice, bob.getOwnJid()).isEmpty() ? 1 : 0) != 0);
        alice.getOmemoService().getOmemoStoreBackend().trustOmemoIdentity(alice, bob.getOwnDevice(), alice.getOmemoService().getOmemoStoreBackend().getFingerprint(alice, bob.getOwnDevice()));
    }

    static void setUpOmemoManager(OmemoManager omemoManager) throws CorruptedOmemoKeyException, InterruptedException, SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.XMPPErrorException, SmackException.NotLoggedInException, PubSubException.NotALeafNodeException {
        omemoManager.initialize();
        OmemoBundleVAxolotlElement bundle = OmemoService.fetchBundle((OmemoManager)omemoManager, (OmemoDevice)omemoManager.getOwnDevice());
        TestCase.assertNotNull((String)"Bundle must not be null.", (Object)bundle);
        TestCase.assertEquals((String)"Published Bundle must equal our local bundle.", (Object)bundle, (Object)omemoManager.getOmemoService().getOmemoStoreBackend().packOmemoBundle(omemoManager));
    }
}

