/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.io.File;
import java.util.logging.Level;
import org.igniterealtime.smack.inttest.AbstractSmackIntegrationTest;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.igniterealtime.smack.inttest.TestNotPossibleException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.omemo.OmemoConfiguration;
import org.jivesoftware.smackx.omemo.OmemoIntegrationTestHelper;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoService;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.jxmpp.jid.DomainBareJid;

public abstract class AbstractOmemoIntegrationTest
extends AbstractSmackIntegrationTest {
    static final File storePath;

    public AbstractOmemoIntegrationTest(SmackIntegrationTestEnvironment environment) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, TestNotPossibleException {
        super(environment);
        if (OmemoConfiguration.getFileBasedOmemoStoreDefaultPath() == null) {
            OmemoConfiguration.setFileBasedOmemoStoreDefaultPath((File)storePath);
        }
        if (!OmemoManager.serverSupportsOmemo((XMPPConnection)this.connection, (DomainBareJid)this.connection.getXMPPServiceDomain())) {
            throw new TestNotPossibleException("Server does not support OMEMO (PubSub)");
        }
        if (!OmemoService.isServiceRegistered()) {
            throw new TestNotPossibleException("No OmemoService registered.");
        }
    }

    @BeforeClass
    public void beforeTest() {
        LOGGER.log(Level.INFO, "START EXECUTION");
        OmemoIntegrationTestHelper.deletePath(storePath);
        this.before();
    }

    @AfterClass
    public void afterTest() {
        this.after();
        OmemoIntegrationTestHelper.deletePath(storePath);
        LOGGER.log(Level.INFO, "END EXECUTION");
    }

    public abstract void before();

    public abstract void after();

    static {
        String userHome = System.getProperty("user.home");
        if (userHome != null) {
            File f = new File(userHome);
            storePath = new File(f, ".config/smack-integration-test/store");
        } else {
            storePath = new File("int_test_omemo_store");
        }
    }
}

