/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.inttest;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.igniterealtime.smack.inttest.Configuration;
import org.igniterealtime.smack.inttest.SmackIntegrationTestEnvironment;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.admin.ServiceAdministrationManager;
import org.jivesoftware.smackx.iqregister.AccountManager;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.stringprep.XmppStringprepException;

public class IntTestUtil {
    private static final Logger LOGGER = Logger.getLogger(IntTestUtil.class.getName());

    public static UsernameAndPassword registerAccount(XMPPTCPConnection connection, SmackIntegrationTestEnvironment environment, int connectionId) throws InterruptedException, XMPPException, SmackException, IOException {
        String username = "sinttest-" + environment.testRunId + "-" + connectionId;
        return IntTestUtil.registerAccount(connection, username, StringUtils.insecureRandomString((int)12), environment.configuration);
    }

    public static UsernameAndPassword registerAccount(XMPPTCPConnection connection, String accountUsername, String accountPassword, Configuration config) throws InterruptedException, XMPPException, SmackException, IOException {
        switch (config.accountRegistration) {
            case inBandRegistration: {
                return IntTestUtil.registerAccountViaIbr((XMPPConnection)connection, accountUsername, accountPassword);
            }
            case serviceAdministration: {
                return IntTestUtil.registerAccountViaAdmin(connection, accountUsername, accountPassword, config.adminAccountUsername, config.adminAccountPassword);
            }
        }
        throw new AssertionError();
    }

    public static UsernameAndPassword registerAccountViaAdmin(XMPPTCPConnection connection, String username, String password, String adminAccountUsername, String adminAccountPassword) throws InterruptedException, XMPPException, SmackException, IOException {
        connection.login((CharSequence)adminAccountUsername, adminAccountPassword);
        ServiceAdministrationManager adminManager = ServiceAdministrationManager.getInstanceFor((XMPPConnection)connection);
        EntityBareJid userJid = JidCreate.entityBareFrom((Localpart)Localpart.from((String)username), (DomainBareJid)connection.getServiceName());
        adminManager.addUser(userJid, password);
        connection.disconnect();
        connection.connect();
        return new UsernameAndPassword(username, password);
    }

    public static UsernameAndPassword registerAccountViaIbr(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return IntTestUtil.registerAccountViaIbr(connection, StringUtils.insecureRandomString((int)12), StringUtils.insecureRandomString((int)12));
    }

    public static UsernameAndPassword registerAccountViaIbr(XMPPConnection connection, String username, String password) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Localpart usernameLocalpart;
        AccountManager accountManager = AccountManager.getInstance((XMPPConnection)connection);
        if (!accountManager.supportsAccountCreation()) {
            throw new UnsupportedOperationException("Account creation/registation is not supported");
        }
        Set requiredAttributes = accountManager.getAccountAttributes();
        if (requiredAttributes.size() > 4) {
            throw new IllegalStateException("Unkown required attributes");
        }
        HashMap<String, String> additionalAttributes = new HashMap<String, String>();
        additionalAttributes.put("name", "Smack Integration Test");
        additionalAttributes.put("email", "flow@igniterealtime.org");
        try {
            usernameLocalpart = Localpart.from((String)username);
        }
        catch (XmppStringprepException e) {
            throw new IllegalArgumentException("Invalid username: " + username, e);
        }
        accountManager.createAccount(usernameLocalpart, password, additionalAttributes);
        return new UsernameAndPassword(username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void disconnectAndMaybeDelete(XMPPTCPConnection connection, Configuration config) throws InterruptedException {
        try {
            if (!config.isAccountRegistrationPossible()) {
                return;
            }
            Configuration.AccountRegistration accountDeletionMethod = config.accountRegistration;
            AccountManager accountManager = AccountManager.getInstance((XMPPConnection)connection);
            try {
                if (accountManager.isSupported()) {
                    accountDeletionMethod = Configuration.AccountRegistration.inBandRegistration;
                }
            }
            catch (SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                LOGGER.log(Level.WARNING, "Could not test if XEP-0077 account deletion is possible", e);
            }
            switch (accountDeletionMethod) {
                case inBandRegistration: {
                    IntTestUtil.deleteViaIbr(connection);
                    return;
                }
                case serviceAdministration: {
                    IntTestUtil.deleteViaServiceAdministration(connection, config);
                    return;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        finally {
            connection.disconnect();
        }
    }

    public static void deleteViaServiceAdministration(XMPPTCPConnection connection, Configuration config) {
        int attempts;
        EntityBareJid accountToDelete = connection.getUser().asEntityBareJid();
        int maxAttempts = 3;
        for (attempts = 0; attempts < 3; ++attempts) {
            connection.disconnect();
            try {
                connection.connect().login((CharSequence)config.adminAccountUsername, config.adminAccountPassword);
            }
            catch (IOException | InterruptedException | SmackException | XMPPException e) {
                LOGGER.log(Level.WARNING, "Exception deleting account for " + connection, e);
                continue;
            }
            ServiceAdministrationManager adminManager = ServiceAdministrationManager.getInstanceFor((XMPPConnection)connection);
            try {
                adminManager.deleteUser(accountToDelete);
                break;
            }
            catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                LOGGER.log(Level.WARNING, "Exception deleting account for " + connection, e);
            }
        }
        if (attempts > 3) {
            LOGGER.log(Level.SEVERE, "Could not delete account for connection: " + connection);
        }
    }

    public static void deleteViaIbr(XMPPTCPConnection connection) throws InterruptedException {
        int attempts;
        if (!connection.isConnected()) {
            try {
                connection.connect().login();
            }
            catch (IOException | SmackException | XMPPException e) {
                LOGGER.log(Level.WARNING, "Exception reconnection account for deletion", e);
            }
        }
        int maxAttempts = 3;
        AccountManager am = AccountManager.getInstance((XMPPConnection)connection);
        for (attempts = 0; attempts < 3; ++attempts) {
            try {
                am.deleteAccount();
            }
            catch (SmackException.NoResponseException | XMPPException.XMPPErrorException e) {
                LOGGER.log(Level.WARNING, "Exception deleting account for " + connection, e);
                continue;
            }
            catch (SmackException.NotConnectedException e) {
                LOGGER.log(Level.WARNING, "Exception deleting account for " + connection, e);
                try {
                    connection.connect().login();
                }
                catch (IOException | SmackException | XMPPException e2) {
                    LOGGER.log(Level.WARNING, "Exception while trying to re-connect " + connection, e);
                }
                continue;
            }
            LOGGER.info("Successfully deleted account of " + connection);
            break;
        }
        if (attempts > 3) {
            LOGGER.log(Level.SEVERE, "Could not delete account for connection: " + connection);
        }
    }

    public static final class UsernameAndPassword {
        public final String username;
        public final String password;

        private UsernameAndPassword(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

